/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AbstractMarkableChart;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.MarkedPoints;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.Plot;
import com.googlecode.charts4j.PlotImpl;
import com.googlecode.charts4j.Shape;
import com.googlecode.charts4j.ShapeMarker;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.parameters.ChartType;

public class ScatterPlot
extends AbstractMarkableChart {
    private final Plot sPlotData;

    ScatterPlot(Plot scatterPlotData) {
        this.sPlotData = scatterPlotData;
    }

    protected void prepareData() {
        super.prepareData();
        PlotImpl scatterPlotData = (PlotImpl)this.sPlotData;
        this.parameterManager.addData(scatterPlotData.getXData());
        this.parameterManager.addData(scatterPlotData.getYData());
        if (scatterPlotData.getPointSizes() != null && scatterPlotData.getPointSizes().getSize() > 0) {
            this.parameterManager.addData(scatterPlotData.getPointSizes());
        }
        if (scatterPlotData.getColor() != null) {
            this.parameterManager.addColor(scatterPlotData.getColor());
        }
        if (scatterPlotData.getLegend() != null) {
            this.parameterManager.addLegend(scatterPlotData.getLegend());
        }
        ImmutableList<Marker> markers = scatterPlotData.getMarkers();
        for (Marker m : markers) {
            this.parameterManager.addMarkers(m, 0);
        }
        if (markers.isEmpty()) {
            Color color = scatterPlotData.getColor() != null ? scatterPlotData.getColor() : Color.BLACK;
            this.parameterManager.addMarker(new ShapeMarker(Shape.CIRCLE, color, 10), 0, 0, 1, 1);
        }
        ImmutableList<MarkedPoints> markedPointsList = scatterPlotData.getMarkedPointsList();
        for (MarkedPoints mp : markedPointsList) {
            this.parameterManager.addMarker(mp.getMarker(), 0, mp.getStartIndex(), mp.getEndIndex(), mp.getN());
        }
        this.parameterManager.setChartTypeParameter(ChartType.SCATTER_CHART);
    }
}

