/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import org.antlr.v4.Tool;
import org.antlr.v4.codegen.OutputModelController;
import org.antlr.v4.codegen.OutputModelWalker;
import org.antlr.v4.codegen.ParserFactory;
import org.antlr.v4.codegen.Target;
import org.antlr.v4.codegen.model.OutputModelObject;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class CodeGenerator {
    public static final String TEMPLATE_ROOT = "org/antlr/v4/tool/templates/codegen";
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    public static final String DEFAULT_LANGUAGE = "Java";
    public static final String vocabFilePattern = "<tokens.keys:{t | <t>=<tokens.(t)>\n}><literals.keys:{t | <t>=<literals.(t)>\n}>";
    public final Grammar g;
    public final Tool tool;
    public final String language;
    private Target target;
    public int lineWidth = 72;

    private CodeGenerator(String language) {
        this.g = null;
        this.tool = null;
        this.language = language;
    }

    public CodeGenerator(Grammar g) {
        this(g.tool, g, g.getOptionString("language"));
    }

    public CodeGenerator(Tool tool, Grammar g, String language) {
        this.g = g;
        this.tool = tool;
        this.language = language != null ? language : DEFAULT_LANGUAGE;
    }

    public static boolean targetExists(String language) {
        String targetName = "org.antlr.v4.codegen.target." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            Constructor<Target> ctor = c.getConstructor(CodeGenerator.class);
            CodeGenerator gen = new CodeGenerator(language);
            Target target = ctor.newInstance(gen);
            return target.templatesExist();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Target getTarget() {
        if (this.target == null && CodeGenerator.targetExists(this.language)) {
            this.loadLanguageTarget(this.language);
        }
        return this.target;
    }

    public STGroup getTemplates() {
        Target t2 = this.getTarget();
        return t2 == null ? null : t2.getTemplates();
    }

    protected void loadLanguageTarget(String language) {
        String targetName = "org.antlr.v4.codegen.target." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            Constructor<Target> ctor = c.getConstructor(CodeGenerator.class);
            this.target = ctor.newInstance(this);
        }
        catch (Exception e) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, e, targetName);
        }
    }

    private OutputModelController createController() {
        ParserFactory factory = new ParserFactory(this);
        OutputModelController controller = new OutputModelController(factory);
        factory.setController(controller);
        return controller;
    }

    private ST walk(OutputModelObject outputModel) {
        OutputModelWalker walker = new OutputModelWalker(this.tool, this.getTemplates());
        return walker.walk(outputModel);
    }

    public ST generateLexer() {
        return this.walk(this.createController().buildLexerOutputModel());
    }

    public ST generateParser() {
        return this.walk(this.createController().buildParserOutputModel());
    }

    public ST generateListener() {
        return this.walk(this.createController().buildListenerOutputModel());
    }

    public ST generateBaseListener() {
        return this.walk(this.createController().buildBaseListenerOutputModel());
    }

    public ST generateVisitor() {
        return this.walk(this.createController().buildVisitorOutputModel());
    }

    public ST generateBaseVisitor() {
        return this.walk(this.createController().buildBaseVisitorOutputModel());
    }

    ST getTokenVocabOutput() {
        ST vocabFileST = new ST(vocabFilePattern);
        LinkedHashMap<String, Integer> tokens = new LinkedHashMap<String, Integer>();
        for (String t2 : this.g.tokenNameToTypeMap.keySet()) {
            int tokenType = this.g.tokenNameToTypeMap.get(t2);
            if (tokenType < 1) continue;
            tokens.put(t2, tokenType);
        }
        vocabFileST.add("tokens", tokens);
        LinkedHashMap<String, Integer> literals = new LinkedHashMap<String, Integer>();
        for (String literal : this.g.stringLiteralToTypeMap.keySet()) {
            int tokenType = this.g.stringLiteralToTypeMap.get(literal);
            if (tokenType < 1) continue;
            literals.put(literal, tokenType);
        }
        vocabFileST.add("literals", literals);
        return vocabFileST;
    }

    public void writeRecognizer(ST outputFileST) {
        this.getTarget().genFile(this.g, outputFileST, this.getRecognizerFileName());
    }

    public void writeListener(ST outputFileST) {
        this.getTarget().genFile(this.g, outputFileST, this.getListenerFileName());
    }

    public void writeBaseListener(ST outputFileST) {
        this.getTarget().genFile(this.g, outputFileST, this.getBaseListenerFileName());
    }

    public void writeVisitor(ST outputFileST) {
        this.getTarget().genFile(this.g, outputFileST, this.getVisitorFileName());
    }

    public void writeBaseVisitor(ST outputFileST) {
        this.getTarget().genFile(this.g, outputFileST, this.getBaseVisitorFileName());
    }

    public void writeHeaderFile() {
        String fileName = this.getHeaderFileName();
        if (fileName == null) {
            return;
        }
        if (this.getTemplates().isDefined("headerFile")) {
            ST extST = this.getTemplates().getInstanceOf("headerFileExtension");
            ST headerFileST = null;
            this.getTarget().genRecognizerHeaderFile(this.g, headerFileST, extST.render(this.lineWidth));
        }
    }

    public void writeVocabFile() {
        ST tokenVocabSerialization = this.getTokenVocabOutput();
        String fileName = this.getVocabFileName();
        if (fileName != null) {
            this.getTarget().genFile(this.g, tokenVocabSerialization, fileName);
        }
    }

    public void write(ST code, String fileName) {
        try {
            Writer w = this.tool.getOutputFileWriter(this.g, fileName);
            AutoIndentWriter wr = new AutoIndentWriter(w);
            wr.setLineWidth(this.lineWidth);
            code.write(wr);
            w.close();
        }
        catch (IOException ioe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_WRITE_FILE, ioe, fileName);
        }
    }

    public String getRecognizerFileName() {
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String recognizerName = this.g.getRecognizerName();
        return recognizerName + extST.render();
    }

    public String getListenerFileName() {
        assert (this.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "Listener";
        return listenerName + extST.render();
    }

    public String getVisitorFileName() {
        assert (this.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "Visitor";
        return listenerName + extST.render();
    }

    public String getBaseListenerFileName() {
        assert (this.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "BaseListener";
        return listenerName + extST.render();
    }

    public String getBaseVisitorFileName() {
        assert (this.g.name != null);
        ST extST = this.getTemplates().getInstanceOf("codeFileExtension");
        String listenerName = this.g.name + "BaseVisitor";
        return listenerName + extST.render();
    }

    public String getVocabFileName() {
        return this.g.name + VOCAB_FILE_EXTENSION;
    }

    public String getHeaderFileName() {
        ST extST = this.getTemplates().getInstanceOf("headerFileExtension");
        if (extST == null) {
            return null;
        }
        String recognizerName = this.g.getRecognizerName();
        return recognizerName + extST.render();
    }
}

