/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntMatrix;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class IntSixStepFNTStrategy
extends IntParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (length > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.transform(arrayAccess, modulus);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        if (length < 2L) {
            return;
        }
        assert (length == (length & -length));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.inverseTransform(arrayAccess, modulus, totalTransformLength);
        arrayAccess.close();
    }

    void transform(ArrayAccess arrayAccess, int modulus) throws ApfloatRuntimeException {
        int length = arrayAccess.getLength();
        if (length < 2) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int w1 = this.modPow(w, n2);
        int[] wTable = this.createWTable(w1, n1);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        IntMatrix.transpose(arrayAccess, n1, n2);
        this.transformRows(n1, n2, false, arrayAccess, wTable, permutationTable);
        IntMatrix.transpose(arrayAccess, n2, n1);
        this.multiplyElements(arrayAccess, 0, n1, n2, w, 1);
        if (n1 != n2) {
            int w2 = this.modPow(w, n1);
            wTable = this.createWTable(w2, n2);
        }
        this.transformRows(n2, n1, false, arrayAccess, wTable, null);
    }

    void inverseTransform(ArrayAccess arrayAccess, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        int length = arrayAccess.getLength();
        if (length < 2) {
            return;
        }
        assert (length == (length & -length));
        int logLength = Util.log2down(length);
        int n1 = logLength >> 1;
        int n2 = logLength - n1;
        n1 = 1 << n1;
        n2 = 1 << n2;
        this.setModulus(IntModConstants.MODULUS[modulus]);
        int w = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int w2 = this.modPow(w, n1);
        int inverseTotalTransformLength = this.modDivide(1, (int)totalTransformLength);
        int[] wTable = this.createWTable(w2, n2);
        int[] permutationTable = Scramble.createScrambleTable(n1);
        this.transformRows(n2, n1, true, arrayAccess, wTable, null);
        this.multiplyElements(arrayAccess, 0, n1, n2, w, inverseTotalTransformLength);
        IntMatrix.transpose(arrayAccess, n1, n2);
        if (n1 != n2) {
            for (int i = 1; i < n1; ++i) {
                wTable[i] = wTable[2 * i];
            }
        }
        this.transformRows(n1, n2, true, arrayAccess, wTable, permutationTable);
        IntMatrix.transpose(arrayAccess, n2, n1);
    }
}

