/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Author;

public class JournalArticle
implements Serializable {
    private static final long serialVersionUID = 5062668226159515468L;
    private List<Author> authorList = new ArrayList<Author>();
    private List<Author> editorList = new ArrayList<Author>();
    private String title = "";
    private String ref = "";
    private String journalName = "";
    private String volume;
    private String startPage;
    private int publicationDate;
    private String publisher = "";
    private String refn = "";
    private String pmid = "";
    private String doi = "";
    private boolean published = false;

    public List<Author> getAuthorList() {
        return this.authorList;
    }

    public void setAuthorList(List<Author> authorList) {
        this.authorList = authorList;
    }

    public List<Author> getEditorList() {
        return this.editorList;
    }

    public void setEditorList(List<Author> editorList) {
        this.editorList = editorList;
    }

    public String getDoi() {
        return this.doi;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public void setIsPublished(Boolean state) {
        this.published = state;
    }

    public String getPmid() {
        return this.pmid;
    }

    public void setPmid(String pmid) {
        this.pmid = pmid;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getRefn() {
        return this.refn;
    }

    public void setRefn(String refn) {
        this.refn = refn;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public int getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(int publicationDate) {
        this.publicationDate = publicationDate;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        this.startPage = startPage;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuffer jrnlString = new StringBuffer();
        StringBuffer authString = new StringBuffer("JRNL        AUTH   ");
        StringBuffer titlString = new StringBuffer("JRNL        TITL   ");
        StringBuffer editString = new StringBuffer("JRNL        EDIT   ");
        StringBuffer refString = new StringBuffer("JRNL        REF    ");
        StringBuffer publString = new StringBuffer("JRNL        PUBL   ");
        StringBuffer refnString = new StringBuffer("JRNL        REFN                   ");
        StringBuffer pmidString = new StringBuffer("JRNL        PMID   ");
        StringBuffer doiString = new StringBuffer("JRNL        DOI    ");
        for (Author author : this.authorList) {
            authString.append(author).append(",");
        }
        jrnlString.append(authString.toString()).append(eol);
        titlString.append(this.title);
        jrnlString.append(titlString.toString()).append(eol);
        if (!this.editorList.isEmpty()) {
            for (Author editor : this.editorList) {
                editString.append(editor).append(",");
            }
            jrnlString.append(editString.toString()).append(eol);
        }
        refString.append(this.ref);
        jrnlString.append(refString.toString()).append(eol);
        if (!this.publisher.equals("")) {
            publString.append(this.publisher);
            jrnlString.append(publString.toString()).append(eol);
        }
        if (!this.refn.equals("")) {
            refnString.append(this.refn);
            jrnlString.append(refnString.toString()).append(eol);
        }
        if (!this.pmid.equals("")) {
            pmidString.append(this.pmid);
            jrnlString.append(pmidString.toString()).append(eol);
        }
        if (!this.doi.equals("")) {
            doiString.append(this.doi);
            jrnlString.append(doiString.toString()).append(eol);
        }
        return jrnlString.toString();
    }
}

