/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.StrucAligParameters;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.bio.structure.align.helper.IndexPair;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.jama.Matrix;

public class BioJavaStructureAlignment
implements StructureAlignment {
    public static final String algorithmName = "BioJava_structure";
    private static final float versionNr = 0.1f;
    StrucAligParameters params = new StrucAligParameters();

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return null;
    }

    @Override
    public void setParameters(ConfigStrucAligParams o) {
        if (!(o instanceof StrucAligParameters)) {
            throw new IllegalArgumentException("Provided parameters are not of type StrucAligParameters!");
        }
        this.params = (StrucAligParameters)((Object)o);
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String printHelp() {
        return "not implemented yet. Algorithm still under development.";
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2) throws StructureException {
        StrucAligParameters params = StrucAligParameters.getDefaultParameters();
        return this.align(ca1, ca2, params);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object params) throws StructureException {
        if (!(params instanceof StrucAligParameters)) {
            throw new IllegalArgumentException("BioJava structure alignment requires a StrucAligParameters class for the arguments.");
        }
        this.params = (StrucAligParameters)params;
        AFPChain afpChain = new AFPChain();
        StructurePairAligner aligner = new StructurePairAligner();
        aligner.align(ca1, ca2, this.params);
        AlternativeAlignment[] aligs = aligner.getAlignments();
        if (aligs.length > 0) {
            AlternativeAlignment altAlig = aligs[0];
            this.copyResults(afpChain, altAlig, ca1, ca2);
        }
        return afpChain;
    }

    private void copyResults(AFPChain afpChain, AlternativeAlignment altAlig, Atom[] ca1, Atom[] ca2) {
        afpChain.setAlgorithmName(this.getAlgorithmName());
        afpChain.setVersion(this.getVersion());
        afpChain.setAlignScore(altAlig.getScore());
        afpChain.setOptLength(altAlig.getEqr());
        afpChain.setBlockRotationMatrix(new Matrix[]{altAlig.getRotationMatrix()});
        afpChain.setBlockShiftVector(new Atom[]{altAlig.getShift()});
        afpChain.setBlockNum(1);
        double rmsd = altAlig.getRmsd();
        afpChain.setBlockRmsd(new double[]{rmsd});
        int nAtom = altAlig.getEqr();
        int lcmp = altAlig.getPath().length;
        int[] optLen = new int[]{nAtom};
        afpChain.setOptLen(optLen);
        afpChain.setOptLength(nAtom);
        afpChain.setAlnLength(lcmp);
        int[][][] optAln = new int[1][2][lcmp];
        afpChain.setOptAln(optAln);
        afpChain.setOptRmsd(new double[]{rmsd});
        afpChain.setTotalRmsdOpt(rmsd);
        afpChain.setChainRmsd(rmsd);
        int nse1 = ca1.length;
        int nse2 = ca2.length;
        char[] alnseq1 = new char[nse1 + nse2 + 1];
        char[] alnseq2 = new char[nse1 + nse2 + 1];
        char[] alnsymb = new char[nse1 + nse2 + 1];
        IndexPair[] path = altAlig.getPath();
        int pos = 0;
        for (int ia = 0; ia < lcmp; ++ia) {
            char l1;
            IndexPair align_se = path[ia];
            if (align_se.getRow() != -1 && align_se.getCol() != -1) {
                optAln[0][0][pos] = align_se.getRow();
                optAln[0][1][pos] = align_se.getCol();
                l1 = BioJavaStructureAlignment.getOneLetter(ca1[align_se.getRow()].getGroup());
                char l2 = BioJavaStructureAlignment.getOneLetter(ca2[align_se.getCol()].getGroup());
                alnseq1[ia] = Character.toUpperCase(l1);
                alnseq2[ia] = Character.toUpperCase(l2);
                alnsymb[ia] = 49;
                ++pos;
                continue;
            }
            alnsymb[ia] = 32;
            if (align_se.getRow() == -1) {
                alnseq1[ia] = 45;
            } else {
                l1 = BioJavaStructureAlignment.getOneLetter(ca1[align_se.getRow()].getGroup());
                alnseq1[ia] = Character.toLowerCase(l1);
            }
            if (align_se.getCol() == -1) {
                alnseq2[ia] = 45;
                continue;
            }
            char l2 = BioJavaStructureAlignment.getOneLetter(ca2[align_se.getCol()].getGroup());
            alnseq2[ia] = Character.toLowerCase(l2);
        }
        afpChain.setAlnseq1(alnseq1);
        afpChain.setAlnseq2(alnseq2);
        afpChain.setAlnsymb(alnsymb);
    }

    private static char getOneLetter(Group g) {
        try {
            Character c = StructureTools.get1LetterCode(g.getPDBName());
            return c.charValue();
        }
        catch (Exception e) {
            return 'X';
        }
    }
}

