/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.ce;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.AbstractStructureAlignment;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.ce.CECalculator;
import org.biojava.bio.structure.align.ce.CeParameters;
import org.biojava.bio.structure.align.ce.CeUserArgumentProcessor;
import org.biojava.bio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.jama.Matrix;

public class CeMain
extends AbstractStructureAlignment
implements StructureAlignment {
    public static final String algorithmName = "jCE";
    public static final String version = "1.1";
    protected CeParameters params = new CeParameters();
    protected CECalculator calculator = new CECalculator(this.params);
    private Atom[] ca2clone;

    public static void main(String[] args) {
        CeMain ce = new CeMain();
        if (args.length == 0) {
            System.out.println(ce.printHelp());
            return;
        }
        if (args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help"))) {
            System.out.println(ce.printHelp());
            return;
        }
        CeUserArgumentProcessor processor = new CeUserArgumentProcessor();
        processor.process(args);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object param2) throws StructureException {
        if (!(param2 instanceof CeParameters)) {
            throw new IllegalArgumentException("CE algorithm needs an object of call CeParameters as argument.");
        }
        this.params = (CeParameters)param2;
        this.ca2clone = new Atom[ca2.length];
        int pos = 0;
        for (Atom a : ca2) {
            Group g = (Group)a.getGroup().clone();
            this.ca2clone[pos] = g.getAtom(" CA ");
            ++pos;
        }
        this.calculator = new CECalculator(this.params);
        AFPChain afpChain = new AFPChain();
        afpChain = this.calculator.extractFragments(afpChain, ca1, this.ca2clone);
        this.calculator.traceFragmentMatrix(afpChain, ca1, this.ca2clone);
        this.calculator.nextStep(afpChain, ca1, this.ca2clone);
        afpChain.setAlgorithmName(this.getAlgorithmName());
        afpChain.setVersion(version);
        try {
            afpChain.setName1(ca1[0].getGroup().getChain().getParent().getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            afpChain.setName2(ca2[0].getGroup().getChain().getParent().getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (afpChain.getNrEQR() == 0) {
            return afpChain;
        }
        int winSize = this.params.getWinSize();
        int winSizeComb1 = (winSize - 1) * (winSize - 2) / 2;
        double[][] m = this.calculator.initSumOfDistances(ca1.length, ca2.length, winSize, winSizeComb1, ca1, this.ca2clone);
        afpChain.setDistanceMatrix(new Matrix(m));
        afpChain.setSequentialAlignment(true);
        return afpChain;
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2) throws StructureException {
        if (this.params == null) {
            this.params = new CeParameters();
        }
        return this.align(ca1, ca2, this.params);
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(ConfigStrucAligParams params) {
        if (!(params instanceof CeParameters)) {
            throw new IllegalArgumentException("provided parameter object is not of type CeParameter");
        }
        this.params = (CeParameters)params;
    }

    @Override
    public String getVersion() {
        return version;
    }

    public CECalculator getCECalculator() {
        return this.calculator;
    }
}

