/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBStatus;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.bio.structure.io.mmcif.ReducedChemCompProvider;
import org.biojava.bio.structure.io.util.FileDownloadUtils;
import org.biojava3.core.util.InputStreamProvider;

public class PDBFileReader
implements StructureIOFile {
    public static final String LOAD_CHEM_COMP_PROPERTY = "loadChemCompInfo";
    String path;
    List<String> extensions = new ArrayList<String>();
    boolean autoFetch;
    private boolean fetchCurrent;
    private boolean fetchFileEvenIfObsolete;
    boolean pdbDirectorySplit;
    private int bioAssemblyId = 0;
    private boolean bioAssemblyFallback = true;
    private boolean loadedBioAssembly = false;
    public static final String lineSplit = System.getProperty("file.separator");
    public static final String DEFAULT_PDB_FILE_SERVER = "ftp.wwpdb.org";
    public static final String PDB_FILE_SERVER_PROPERTY = "PDB.FILE.SERVER";
    private static final String CURRENT_FILES_PATH = "/pub/pdb/data/structures/divided/pdb/";
    private static final String OBSOLETE_FILES_PATH = "/pub/pdb/data/structures/obsolete/pdb/";
    private static final String BIO_ASSEMBLY_FILES_PATH = "/pub/pdb/data/biounit/coordinates/divided/";
    private static final String LOCAL_BIO_ASSEMBLY_DIRECTORY = "bio_assembly";
    FileParsingParameters params;
    public static final long lastRemediationDate;

    public static void main(String[] args) {
        PDBFileReader pdbreader = new PDBFileReader();
        String property = "java.io.tmpdir";
        String tempdir = System.getProperty(property);
        pdbreader.setPath(tempdir);
        FileParsingParameters params = new FileParsingParameters();
        pdbreader.setFileParsingParameters(params);
        try {
            Structure struc = pdbreader.getStructureById("193D");
            System.out.println(struc);
            List<Compound> compounds = struc.getCompounds();
            for (Compound comp : compounds) {
                List<Chain> chains = comp.getChains();
                System.out.print(">Chains :");
                for (Chain c : chains) {
                    System.out.print(c.getChainID() + " ");
                }
                System.out.println();
                if (chains.size() <= 0) continue;
                System.out.println(chains.get(0).getAtomSequence());
                System.out.println(chains.get(0).getSeqResSequence());
                System.out.print("  Atom Ligands: ");
                for (Group g : chains.get(0).getAtomLigands()) {
                    System.out.print(g.getPDBName() + " ");
                }
                System.out.println(" ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PDBFileReader() {
        this.extensions.add(".ent");
        this.extensions.add(".pdb");
        this.extensions.add(".ent.gz");
        this.extensions.add(".pdb.gz");
        this.extensions.add(".ent.Z");
        this.extensions.add(".pdb.Z");
        this.autoFetch = false;
        this.pdbDirectorySplit = false;
        this.params = new FileParsingParameters();
    }

    private void checkPath() {
        if (this.path == null || this.path.equals("") || this.path.equals("null")) {
            String syspath = System.getProperty("PDB_DIR");
            if (syspath != null && !syspath.equals("") && !syspath.equals("null")) {
                this.path = syspath;
                return;
            }
            String property = "java.io.tmpdir";
            String tempdir = System.getProperty(property);
            if (!tempdir.endsWith(lineSplit)) {
                tempdir = tempdir + lineSplit;
            }
            System.err.println("you did not set the path in PDBFileReader, don't know where to write the downloaded file to");
            System.err.println("assuming default location is temp directory: " + tempdir);
            this.path = tempdir;
        }
    }

    @Override
    public void setPath(String p) {
        System.setProperty("PDB_DIR", p);
        this.path = p;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void addExtension(String s) {
        this.extensions.add(s);
    }

    @Override
    public void clearExtensions() {
        this.extensions.clear();
    }

    @Override
    public boolean isPdbDirectorySplit() {
        return this.pdbDirectorySplit;
    }

    @Override
    public void setPdbDirectorySplit(boolean pdbDirectorySplit) {
        this.pdbDirectorySplit = pdbDirectorySplit;
    }

    public void setBioAssemblyId(int bioAssemblyId) {
        this.bioAssemblyId = bioAssemblyId;
    }

    public void setBioAssemblyFallback(boolean bioAssemblyFallback) {
        this.bioAssemblyFallback = bioAssemblyFallback;
    }

    public InputStream getInputStream(String pdbId) throws IOException {
        if (pdbId.length() < 4) {
            throw new IOException("the provided ID does not look like a PDB ID : " + pdbId);
        }
        this.checkPath();
        InputStream inputStream = null;
        String pdbFile = this.getLocalPDBFilePath(pdbId);
        if (pdbFile != null) {
            InputStreamProvider isp = new InputStreamProvider();
            try {
                inputStream = isp.getInputStream(pdbFile);
                return inputStream;
            }
            catch (Exception e) {
                e.printStackTrace();
                pdbFile = null;
            }
        }
        if (pdbFile == null) {
            if (this.autoFetch) {
                if (this.fetchCurrent && !this.fetchFileEvenIfObsolete) {
                    String current = PDBStatus.getCurrent(pdbId);
                    if (current == null) {
                        current = pdbId;
                    }
                    return this.downloadAndGetInputStream(current, CURRENT_FILES_PATH);
                }
                if (this.fetchFileEvenIfObsolete && PDBStatus.getStatus(pdbId) == PDBStatus.Status.OBSOLETE) {
                    return this.downloadAndGetInputStream(pdbId, OBSOLETE_FILES_PATH);
                }
                return this.downloadAndGetInputStream(pdbId, CURRENT_FILES_PATH);
            }
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return null;
    }

    private String getLocalPDBFilePath(String pdbId) {
        String ppath;
        String fpath;
        String pdbFile = null;
        File f2 = null;
        if (this.pdbDirectorySplit) {
            String middle = pdbId.substring(1, 3).toLowerCase();
            fpath = this.path + lineSplit + middle + lineSplit + pdbId;
            ppath = this.path + lineSplit + middle + lineSplit + "pdb" + pdbId;
        } else {
            fpath = this.path + lineSplit + pdbId;
            ppath = this.path + lineSplit + "pdb" + pdbId;
        }
        String[] paths = new String[]{fpath, ppath};
        block0: for (int p = 0; p < paths.length; ++p) {
            String testpath = paths[p];
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = this.extensions.get(i);
                f2 = new File(testpath + ex);
                if (f2.exists()) {
                    long lastModified;
                    pdbFile = testpath + ex;
                    if (this.params.isUpdateRemediatedFiles() && (lastModified = f2.lastModified()) < lastRemediationDate) {
                        System.out.println("replacing file " + pdbFile + " with latest remediated file from PDB.");
                        pdbFile = null;
                        return null;
                    }
                    return pdbFile;
                }
                if (pdbFile != null) continue block0;
            }
        }
        return null;
    }

    public InputStream getInputStreamBioAssembly(String pdbId) throws IOException {
        InputStreamProvider isp;
        String fpath;
        this.loadedBioAssembly = true;
        InputStream inputStream = null;
        if (pdbId.length() < 4) {
            throw new IOException("the provided ID does not look like a PDB ID : " + pdbId);
        }
        this.checkPath();
        String uPath = FileDownloadUtils.toUnixPath(this.path);
        String dir = uPath + LOCAL_BIO_ASSEMBLY_DIRECTORY;
        File tmp = new File(dir);
        if (!tmp.exists()) {
            tmp.mkdir();
        }
        if (this.pdbDirectorySplit) {
            String middle = pdbId.substring(1, 3).toLowerCase();
            fpath = dir + "/" + middle + "/";
        } else {
            fpath = dir + "/";
        }
        String fileName = fpath + this.getBiologicalAsssemblyFileName(pdbId.toLowerCase(), this.bioAssemblyId);
        File f2 = new File(fileName);
        if (f2.exists()) {
            isp = new InputStreamProvider();
            try {
                inputStream = isp.getInputStream(fileName);
                return inputStream;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.bioAssemblyFallback) {
            if (this.pdbDirectorySplit) {
                String middle = pdbId.substring(1, 3).toLowerCase();
                fpath = uPath + middle + "/";
            } else {
                fpath = uPath;
            }
            fileName = fpath + "pdb" + pdbId + ".ent.gz";
            f2 = new File(fileName);
            if (f2.exists()) {
                try {
                    isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(fileName);
                    System.out.println("Loaded original PDB file as a fallback." + fileName);
                    this.loadedBioAssembly = false;
                    return inputStream;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.autoFetch) {
            if (this.fetchCurrent && !this.fetchFileEvenIfObsolete) {
                String current = PDBStatus.getCurrent(pdbId);
                if (current == null) {
                    current = pdbId;
                }
                if ((inputStream = this.downloadAndGetInputStreamBioAssembly(current, BIO_ASSEMBLY_FILES_PATH)) != null) {
                    return inputStream;
                }
            } else {
                if (this.fetchFileEvenIfObsolete && PDBStatus.getStatus(pdbId) == PDBStatus.Status.OBSOLETE) {
                    String message = "No biological assembly with PDB code " + pdbId + " found!";
                    throw new IOException(message);
                }
                inputStream = this.downloadAndGetInputStreamBioAssembly(pdbId, BIO_ASSEMBLY_FILES_PATH);
                if (inputStream != null) {
                    return inputStream;
                }
            }
        }
        if (this.bioAssemblyFallback && (inputStream = this.getInputStream(pdbId)) != null) {
            System.out.println("Biological assembly file for PDB ID: " + pdbId + " is not available. " + "Loaded original PDB file as a fallback from local cache.");
            return this.getInputStream(pdbId);
        }
        return null;
    }

    private File downloadPDB(String pdbId, String pathOnServer) {
        if (this.path == null || this.path.equals("")) {
            String property = "java.io.tmpdir";
            String tempdir = System.getProperty(property);
            if (!tempdir.endsWith(lineSplit)) {
                tempdir = tempdir + lineSplit;
            }
            System.err.println("you did not set the path in PDBFileReader, don;t know where to write the downloaded file to");
            System.err.println("assuming default location is temp directory: " + tempdir);
            this.path = tempdir;
        }
        File realFile = null;
        pdbId = pdbId.toLowerCase();
        String middle = pdbId.substring(1, 3);
        if (this.pdbDirectorySplit) {
            String dir = this.path + lineSplit + middle;
            File directoryCheck = new File(dir);
            if (!directoryCheck.exists()) {
                directoryCheck.mkdir();
            }
            realFile = new File(dir + lineSplit + "pdb" + pdbId + ".ent.gz");
        } else {
            realFile = new File(this.path + lineSplit + "pdb" + pdbId + ".ent.gz");
        }
        String serverName = System.getProperty(PDB_FILE_SERVER_PROPERTY);
        if (serverName == null) {
            serverName = DEFAULT_PDB_FILE_SERVER;
        }
        String ftp = String.format("ftp://%s%s%s/pdb%s.ent.gz", serverName, pathOnServer, middle, pdbId);
        try {
            URL url = new URL(ftp);
            FileDownloadUtils.downloadGzipCompressedFile(url, realFile);
        }
        catch (Exception e) {
            System.err.println("Problem while downloading PDB ID " + pdbId + " from FTP server.");
            System.err.println("Failed URL: " + ftp);
            e.printStackTrace();
            return null;
        }
        return realFile;
    }

    private File downloadPDBBiologicalAssembly(String pdbId, String pathOnServer) {
        this.loadedBioAssembly = true;
        this.checkPath();
        String fileName = this.getBiologicalAsssemblyFileName(pdbId, this.bioAssemblyId);
        pdbId = pdbId.toLowerCase();
        String middle = pdbId.substring(1, 3);
        String serverName = System.getProperty(PDB_FILE_SERVER_PROPERTY);
        if (serverName == null) {
            serverName = DEFAULT_PDB_FILE_SERVER;
        }
        String ftp = String.format("ftp://%s%s%s/%s", serverName, pathOnServer, middle, fileName);
        System.out.println("Fetching " + ftp);
        URL url = null;
        try {
            url = new URL(ftp);
        }
        catch (MalformedURLException e1) {
            System.err.println("Problem while downloading Biological Assembly " + pdbId + " from FTP server.");
            e1.printStackTrace();
            return null;
        }
        File f2 = null;
        try {
            f2 = this.downloadFileIfAvailable(url, pdbId, fileName);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (f2 == null) {
            if (this.bioAssemblyFallback) {
                System.out.println("Biological unit file for PDB ID: " + pdbId + " is not available. " + "Downloading original PDB file as a fallback.");
                this.loadedBioAssembly = false;
                String fallBackPDBF = this.getLocalPDBFilePath(pdbId);
                if (fallBackPDBF != null) {
                    return new File(fallBackPDBF);
                }
                return this.downloadPDB(pdbId, CURRENT_FILES_PATH);
            }
            return null;
        }
        return f2;
    }

    private File downloadFileIfAvailable(URL url, String pdbId, String fileName) throws IOException {
        String middle = pdbId.substring(1, 3);
        String uPath = FileDownloadUtils.toUnixPath(this.path);
        File tempFile = null;
        if (this.pdbDirectorySplit) {
            String dir = uPath + LOCAL_BIO_ASSEMBLY_DIRECTORY + "/" + middle;
            File directoryCheck = new File(dir);
            if (!directoryCheck.exists()) {
                directoryCheck.mkdir();
            }
            tempFile = new File(dir + "/" + fileName);
        } else {
            tempFile = new File(this.path + LOCAL_BIO_ASSEMBLY_DIRECTORY + "/" + fileName);
        }
        return FileDownloadUtils.downloadFileIfAvailable(url, tempFile);
    }

    private InputStream downloadAndGetInputStream(String pdbId, String pathOnServer) throws IOException {
        File tmp = this.downloadPDB(pdbId, pathOnServer);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            InputStream is = prov.getInputStream(tmp);
            return is;
        }
        throw new IOException("could not find PDB " + pdbId + " in file system and also could not download");
    }

    private InputStream downloadAndGetInputStreamBioAssembly(String pdbId, String pathOnServer) throws IOException {
        File tmp = this.downloadPDBBiologicalAssembly(pdbId, pathOnServer);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            InputStream is = prov.getInputStream(tmp);
            return is;
        }
        throw new IOException("Could not find Biological Assembly " + pdbId + " in file system and also could not download");
    }

    public boolean checkFileExists(String pdbId) {
        String path = this.getLocalPDBFilePath(pdbId);
        return path != null;
    }

    public void downloadPDB(String pdbId) {
        if (this.checkFileExists(pdbId)) {
            return;
        }
        if (this.autoFetch) {
            if (this.fetchCurrent && !this.fetchFileEvenIfObsolete) {
                String current = PDBStatus.getCurrent(pdbId);
                if (current == null) {
                    current = pdbId;
                }
                this.downloadPDB(current, CURRENT_FILES_PATH);
            } else if (this.fetchFileEvenIfObsolete && PDBStatus.getStatus(pdbId) == PDBStatus.Status.OBSOLETE) {
                this.downloadPDB(pdbId, OBSOLETE_FILES_PATH);
            } else {
                this.downloadPDB(pdbId, CURRENT_FILES_PATH);
            }
        }
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException {
        InputStream inStream = null;
        inStream = this.bioAssemblyId == 0 ? this.getInputStream(pdbId) : this.getInputStreamBioAssembly(pdbId);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(this.params);
        Structure struc = pdbpars.parsePDBFile(inStream);
        struc.setBiologicalAssembly(this.loadedBioAssembly);
        return struc;
    }

    @Override
    public Structure getStructure(String filename) throws IOException {
        File f2 = new File(filename);
        return this.getStructure(f2);
    }

    @Override
    public Structure getStructure(File filename) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        return this.getStructure(inStream);
    }

    private Structure getStructure(InputStream inStream) throws IOException {
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(this.params);
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    public Structure getStructure(URL u) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(u);
        return this.getStructure(inStream);
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
        if (!params.isLoadChemCompInfo()) {
            ChemCompGroupFactory.setChemCompProvider(new ReducedChemCompProvider());
        }
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    @Override
    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    @Override
    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    public void setFetchFileEvenIfObsolete(boolean fetchFileEvenIfObsolete) {
        this.fetchFileEvenIfObsolete = fetchFileEvenIfObsolete;
    }

    public boolean isFetchFileEvenIfObsolete() {
        return this.fetchFileEvenIfObsolete;
    }

    public void setFetchCurrent(boolean fetchNewestCurrent) {
        this.fetchCurrent = fetchNewestCurrent;
    }

    public boolean isFetchCurrent() {
        return this.fetchCurrent;
    }

    private String getBiologicalAsssemblyFileName(String pdbId, int biologicalAssemblyId) {
        return pdbId + ".pdb" + biologicalAssemblyId + ".gz";
    }

    static {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd", Locale.US);
        long t2 = 0L;
        try {
            Date d = formatter.parse("2011/07/12");
            t2 = d.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        lastRemediationDate = t2;
    }
}

