/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.bio.structure.align.util.UserConfiguration;
import org.biojava.bio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.bio.structure.io.mmcif.ChemCompProvider;
import org.biojava.bio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.bio.structure.io.mmcif.DownloadChemCompProvider;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava3.core.util.InputStreamProvider;

public class AllChemCompProvider
implements ChemCompProvider,
Runnable {
    static String path;
    private static final String lineSplit;
    private static String serverLocation;
    static ChemicalComponentDictionary dict;
    static AtomicBoolean loading;
    static AtomicBoolean isInitialized;

    public AllChemCompProvider() {
        if (loading.get()) {
            System.err.println("other thread is already loading all chemcomps, no need to init twice");
            return;
        }
        if (isInitialized.get()) {
            return;
        }
        loading.set(true);
        Thread t2 = new Thread(this);
        t2.start();
    }

    public static void checkPath() {
        UserConfiguration config = new UserConfiguration();
        path = config.getCacheFilePath();
    }

    private void ensureFileExists() {
        String fileName = AllChemCompProvider.getLocalFileName();
        File f2 = new File(fileName);
        if (!f2.exists()) {
            try {
                AllChemCompProvider.downloadFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadFile() throws IOException, FileNotFoundException {
        String localName = AllChemCompProvider.getLocalFileName();
        String u = serverLocation + "components.cif.gz";
        AllChemCompProvider.downloadFileFromRemote(new URL(u), new File(localName));
    }

    private static void downloadFileFromRemote(URL remoteURL, File localFile) throws FileNotFoundException, IOException {
        int bytesRead;
        System.out.println("downloading " + remoteURL + " to: " + localFile);
        FileOutputStream out = new FileOutputStream(localFile);
        InputStream in = remoteURL.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    private static String getLocalFileName() {
        String dir = path + DownloadChemCompProvider.CHEM_COMP_CACHE_DIRECTORY + lineSplit;
        File f2 = new File(dir);
        if (!f2.exists()) {
            System.out.println("creating directory " + f2);
            f2.mkdir();
        }
        String fileName = path + DownloadChemCompProvider.CHEM_COMP_CACHE_DIRECTORY + lineSplit + "components.cif.gz";
        return fileName;
    }

    private void loadAllChemComps() {
        String fileName = AllChemCompProvider.getLocalFileName();
        System.out.println("loading " + fileName);
        InputStreamProvider isp = new InputStreamProvider();
        try {
            InputStream inStream = isp.getInputStream(fileName);
            SimpleMMcifParser parser = new SimpleMMcifParser();
            ChemCompConsumer consumer = new ChemCompConsumer();
            parser.addMMcifConsumer(consumer);
            parser.parse(new BufferedReader(new InputStreamReader(inStream)));
            dict = consumer.getDictionary();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        while (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return dict.getChemComp(recordName);
    }

    @Override
    public void run() {
        long timeS = System.currentTimeMillis();
        try {
            AllChemCompProvider.checkPath();
            this.ensureFileExists();
            this.loadAllChemComps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long timeE = System.currentTimeMillis();
        System.out.println("time to init chem comp dictionary: " + (timeE - timeS) / 1000L + " sec.");
        loading.set(false);
        isInitialized.set(true);
    }

    static {
        lineSplit = System.getProperty("file.separator");
        serverLocation = "ftp://ftp.wwpdb.org/pub/pdb/data/monomers/";
        loading = new AtomicBoolean(false);
        isInitialized = new AtomicBoolean(false);
    }
}

