/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.rcsb;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReadUtils {
    private static final Logger logger = LogManager.getLogger((String)ReadUtils.class.getPackage().getName());
    private static boolean documentBuilderFactorySet = false;

    static String toStr(String s) {
        if (s == "") {
            return null;
        }
        return s;
    }

    static NodeList getNodes(InputStream stream) throws IOException {
        if (!documentBuilderFactorySet) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            documentBuilderFactorySet = true;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document2 = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Couldn't configure parser", (Throwable)e);
            stream.close();
            throw new IOException(e);
        }
        try {
            document2 = builder.parse(stream);
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
            logger.error("Couldn't parse stream", (Throwable)e);
            stream.close();
            throw new IOException(e);
        }
        Element root2 = document2.getDocumentElement();
        return root2.getChildNodes();
    }

    static Double toDouble(String s) {
        if (s == "") {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            logger.error(s + " is not a floating-point number", (Throwable)e);
            return null;
        }
    }

    static Integer toInt(String s) {
        if (s == "") {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            logger.error(s + " is not an integer", (Throwable)e);
            return null;
        }
    }
}

