/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.List;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;

public class SequenceAsStringHelper<C extends Compound> {
    public String getSequenceAsString(List<C> parsedCompounds, CompoundSet<C> compoundSet, Integer bioBegin, Integer bioEnd, Strand strand) {
        if (parsedCompounds.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (strand.equals((Object)Strand.NEGATIVE)) {
            if (bioBegin <= bioEnd) {
                for (int index2 = bioEnd - 1; index2 >= bioBegin - 1; --index2) {
                    Compound compound = (Compound)parsedCompounds.get(index2);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
            } else {
                Compound compound;
                int index3;
                for (index3 = bioBegin - 1; index3 >= 0; --index3) {
                    compound = (Compound)parsedCompounds.get(index3);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
                for (index3 = parsedCompounds.size() - 1; index3 >= bioEnd - 1; --index3) {
                    compound = (Compound)parsedCompounds.get(index3);
                    builder.append(compoundSet.getStringForCompound(compound));
                }
            }
        } else if (bioBegin <= bioEnd) {
            for (int index4 = bioBegin - 1; index4 <= bioEnd - 1; ++index4) {
                Compound compound = (Compound)parsedCompounds.get(index4);
                builder.append(compoundSet.getStringForCompound(compound));
            }
        } else {
            Compound compound;
            int index5;
            for (index5 = bioBegin - 1; index5 <= parsedCompounds.size() - 1; ++index5) {
                compound = (Compound)parsedCompounds.get(index5);
                builder.append(compoundSet.getStringForCompound(compound));
            }
            for (index5 = 0; index5 <= bioEnd - 1; ++index5) {
                compound = (Compound)parsedCompounds.get(index5);
                builder.append(compoundSet.getStringForCompound(compound));
            }
        }
        return builder.toString();
    }
}

