/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedDataBlock;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.tribble.util.SeekableStream;

public class BigBedIterator
implements Iterator<BedFeature> {
    private static Logger log = Logger.getLogger(BigBedIterator.class);
    private RPChromosomeRegion selectionRegion;
    private boolean contained;
    private RPChromosomeRegion hitRegion;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree chromDataTree;
    private ArrayList<RPTreeLeafNodeItem> leafHitList;
    private HashMap<Integer, String> chromosomeMap;
    private int leafItemIndex;
    RPTreeLeafNodeItem leafHitItem;
    private BigBedDataBlock bedDataBlock;
    private boolean dataBlockRead;
    private ArrayList<BedFeature> bedFeatureList;
    private int bedFeatureIndex;
    private boolean empty = false;

    public BigBedIterator(SeekableStream fis, BPTree chromIDTree, RPTree chromDataTree, RPChromosomeRegion selectionRegion, boolean contained) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: BigBedIterator selection region is null\n");
        }
        this.fis = fis;
        this.chromIDTree = chromIDTree;
        this.chromDataTree = chromDataTree;
        this.selectionRegion = selectionRegion;
        this.contained = contained;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            this.empty = true;
        }
    }

    public BigBedIterator() {
        this.empty = true;
    }

    @Override
    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.bedFeatureIndex < this.bedFeatureList.size()) {
            return true;
        }
        return this.leafItemIndex < this.leafHitList.size();
    }

    @Override
    public BedFeature next() {
        if (this.bedFeatureIndex < this.bedFeatureList.size()) {
            return this.bedFeatureList.get(this.bedFeatureIndex++);
        }
        int nHits = this.getHitRegion(this.selectionRegion, this.contained);
        if (nHits > 0) {
            return this.bedFeatureList.get(this.bedFeatureIndex++);
        }
        String result2 = String.format("Failed to find data for bed region (%d,%d,%d,%d)\n", this.hitRegion.getStartChromID(), this.hitRegion.getStartBase(), this.hitRegion.getEndChromID(), this.hitRegion.getEndBase());
        log.error(result2);
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public RPChromosomeRegion getSelectionRegion() {
        return this.selectionRegion;
    }

    public int setSelectionRegion(RPChromosomeRegion selectionRegion, boolean contained) {
        this.selectionRegion = selectionRegion;
        this.contained = contained;
        this.leafHitList = null;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            throw new RuntimeException("No wig data found in the selection region");
        }
        return hitCount;
    }

    public boolean isContained() {
        return this.contained;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromIDTree;
    }

    public RPTree getChromosomeDataTree() {
        return this.chromDataTree;
    }

    public ArrayList<RPTreeLeafNodeItem> getLeafItems() {
        return this.leafHitList;
    }

    private int getHitRegion(RPChromosomeRegion hitRegion, boolean contained) {
        int hitCount = 0;
        if (this.leafHitList == null ? (hitCount = this.getHitList(hitRegion, contained)) == 0 : (hitCount = this.leafHitList.size() - this.leafItemIndex) == 0) {
            return 0;
        }
        this.dataBlockRead = this.getDataBlock(this.leafItemIndex++);
        if (!this.dataBlockRead) {
            hitCount = this.getHitRegion(hitRegion, contained);
        }
        return hitCount;
    }

    private int getHitList(RPChromosomeRegion hitRegion, boolean contained) {
        this.leafHitList = this.chromDataTree.getChromosomeDataHits(hitRegion, contained);
        int nHits = this.leafHitList.size();
        if (nHits == 0) {
            return 0;
        }
        this.leafItemIndex = 0;
        int startChromID = this.leafHitList.get(0).getChromosomeBounds().getStartChromID();
        int startBase = this.leafHitList.get(0).getChromosomeBounds().getStartBase();
        int endChromID = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndChromID();
        int endBase = this.leafHitList.get(nHits - 1).getChromosomeBounds().getEndBase();
        this.hitRegion = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return nHits;
    }

    private boolean getDataBlock(int leafItemIndex) {
        if (leafItemIndex >= this.leafHitList.size()) {
            return false;
        }
        this.leafHitItem = this.leafHitList.get(leafItemIndex);
        int startChromID = this.leafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = this.leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.chromDataTree.isIsLowToHigh();
        int uncompressBufSize = this.chromDataTree.getUncompressBuffSize();
        this.bedDataBlock = new BigBedDataBlock(this.fis, this.leafHitItem, this.chromosomeMap, isLowToHigh, uncompressBufSize);
        this.bedFeatureList = this.bedDataBlock.getBedData(this.selectionRegion, this.contained);
        this.bedFeatureIndex = 0;
        return this.bedFeatureList.size() > 0;
    }
}

