/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.collections;

import gnu.trove.map.hash.TLongIntHashMap;

public class HashLongLongArray {
    public static final long EMPTY_VALUE = 0L;
    static final long EMPTY_VALUE_TROVE = 0L;
    static final int INITIAL_NUMBER_OF_BUCKETS = 1024;
    static final int INITIAL_BUCKET_SIZE = 2;
    static final float BUCKET_EXPANSION_FACTOR = 1.3f;
    static final int BUCKET_CAPACITY_EXPANSION_FACTOR = 2;
    TLongIntHashMap hash = new TLongIntHashMap();
    long[][] buckets = new long[1024][];
    int bucketsUsed;
    int[] bucketFirstAvailable = new int[1024];
    int latestBucketLength = 0;

    public HashLongLongArray() {
        this.buckets[0] = new long[0];
        this.bucketsUsed = 1;
    }

    public boolean contains(long key, long value2) {
        int bucketNumber = this.getBucketNumber(key);
        if (bucketNumber == 0) {
            return false;
        }
        long[] bucket = this.buckets[bucketNumber];
        if (bucket == null) {
            return false;
        }
        int len = this.bucketFirstAvailable[bucketNumber];
        for (int i = 0; i < len; ++i) {
            if (bucket[i] != value2) continue;
            return true;
        }
        return false;
    }

    public long[] getBucket(long key) {
        int bnum = this.getBucketNumber(key);
        if ((long)bnum == 0L) {
            return null;
        }
        this.latestBucketLength = this.bucketFirstAvailable[bnum];
        return this.buckets[bnum];
    }

    public int getBucketLength(long key) {
        int bnum = this.getBucketNumber(key);
        if ((long)bnum == 0L) {
            return 0;
        }
        return this.bucketFirstAvailable[bnum];
    }

    int getBucketNumber(long key) {
        return this.hash.get(key);
    }

    public int getLatestBucketLength() {
        return this.latestBucketLength;
    }

    public long[] keys() {
        return this.hash.keys();
    }

    public void put(long key, long value2) {
        long[] bucket;
        int bucketNumber = this.getBucketNumber(key);
        if (bucketNumber == 0) {
            bucketNumber = this.bucketsUsed++;
            this.hash.put(key, bucketNumber);
            if (this.bucketsUsed > this.buckets.length) {
                int newSize = (int)((float)this.buckets.length * 1.3f);
                long[][] newBuckets = new long[newSize][];
                int[] newBucketFa = new int[newSize];
                System.arraycopy(this.buckets, 0, newBuckets, 0, this.buckets.length);
                System.arraycopy(this.bucketFirstAvailable, 0, newBucketFa, 0, this.buckets.length);
                this.buckets = newBuckets;
                this.bucketFirstAvailable = newBucketFa;
            }
        }
        if ((bucket = this.buckets[bucketNumber]) == null) {
            this.buckets[bucketNumber] = new long[2];
            bucket = this.buckets[bucketNumber];
        }
        int bucketIndex = this.bucketFirstAvailable[bucketNumber];
        int n = bucketNumber;
        this.bucketFirstAvailable[n] = this.bucketFirstAvailable[n] + 1;
        if (bucketIndex >= bucket.length) {
            int newSize = bucket.length * 2;
            long[] newRefs = new long[newSize];
            System.arraycopy(bucket, 0, newRefs, 0, bucket.length);
            this.buckets[bucketNumber] = newRefs;
            bucket = newRefs;
        }
        bucket[bucketIndex] = value2;
    }

    public boolean replace(long key, long value2, long newValue) {
        int bucketNumber = this.getBucketNumber(key);
        if (bucketNumber == 0) {
            return false;
        }
        long[] bucket = this.buckets[bucketNumber];
        if (bucket == null) {
            return false;
        }
        int len = this.bucketFirstAvailable[bucketNumber];
        for (int i = 0; i < len; ++i) {
            if (bucket[i] != value2) continue;
            bucket[i] = newValue;
            return true;
        }
        return false;
    }

    public String toString() {
        long total = 0L;
        long min2 = Integer.MAX_VALUE;
        long max2 = 0L;
        long bucketsLen = 0L;
        for (int i = 1; i < this.bucketsUsed; ++i) {
            int bucketIndex;
            int len = bucketIndex = this.bucketFirstAvailable[i];
            total += (long)len;
            max2 = Math.max(max2, (long)len);
            min2 = Math.min(min2, (long)len);
            bucketsLen += (long)this.buckets[i].length;
        }
        double avg = (double)total / (double)this.bucketsUsed;
        return "References: " + total + "\tbucketsLen: " + bucketsLen + "\tBuckets: " + this.bucketsUsed + "\tBucket size: min: " + min2 + ", max: " + max2 + ", avg: " + avg + "\tHash.size: " + this.hash.size();
    }
}

