/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.util.HashMap;
import java.util.Map;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.vcf.EffFormatVersion;

public enum EffectType {
    CHROMOSOME_LARGE_DELETION(VariantEffect.EffectImpact.HIGH),
    CHROMOSOME_LARGE_INVERSION(VariantEffect.EffectImpact.HIGH),
    CHROMOSOME_LARGE_DUPLICATION(VariantEffect.EffectImpact.HIGH),
    GENE_REARRANGEMENT(VariantEffect.EffectImpact.HIGH),
    GENE_DELETED(VariantEffect.EffectImpact.HIGH),
    TRANSCRIPT_DELETED(VariantEffect.EffectImpact.HIGH),
    EXON_DELETED(VariantEffect.EffectImpact.HIGH),
    EXON_DELETED_PARTIAL(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION_REVERESE(VariantEffect.EffectImpact.HIGH),
    GENE_FUSION_HALF(VariantEffect.EffectImpact.HIGH),
    FRAME_SHIFT(VariantEffect.EffectImpact.HIGH),
    STOP_GAINED(VariantEffect.EffectImpact.HIGH),
    STOP_LOST(VariantEffect.EffectImpact.HIGH),
    START_LOST(VariantEffect.EffectImpact.HIGH),
    SPLICE_SITE_ACCEPTOR(VariantEffect.EffectImpact.HIGH),
    SPLICE_SITE_DONOR(VariantEffect.EffectImpact.HIGH),
    RARE_AMINO_ACID(VariantEffect.EffectImpact.HIGH),
    EXON_DUPLICATION(VariantEffect.EffectImpact.HIGH),
    EXON_DUPLICATION_PARTIAL(VariantEffect.EffectImpact.HIGH),
    EXON_INVERSION(VariantEffect.EffectImpact.HIGH),
    EXON_INVERSION_PARTIAL(VariantEffect.EffectImpact.HIGH),
    PROTEIN_PROTEIN_INTERACTION_LOCUS(VariantEffect.EffectImpact.HIGH),
    PROTEIN_STRUCTURAL_INTERACTION_LOCUS(VariantEffect.EffectImpact.HIGH),
    NON_SYNONYMOUS_CODING(VariantEffect.EffectImpact.MODERATE),
    GENE_DUPLICATION(VariantEffect.EffectImpact.MODERATE),
    TRANSCRIPT_DUPLICATION(VariantEffect.EffectImpact.MODERATE),
    UTR_5_DELETED(VariantEffect.EffectImpact.MODERATE),
    UTR_3_DELETED(VariantEffect.EffectImpact.MODERATE),
    SPLICE_SITE_BRANCH_U12(VariantEffect.EffectImpact.MODERATE),
    GENE_INVERSION(VariantEffect.EffectImpact.MODERATE),
    TRANSCRIPT_INVERSION(VariantEffect.EffectImpact.MODERATE),
    CODON_INSERTION(VariantEffect.EffectImpact.MODERATE),
    CODON_CHANGE_PLUS_CODON_INSERTION(VariantEffect.EffectImpact.MODERATE),
    CODON_DELETION(VariantEffect.EffectImpact.MODERATE),
    CODON_CHANGE_PLUS_CODON_DELETION(VariantEffect.EffectImpact.MODERATE),
    NON_SYNONYMOUS_STOP(VariantEffect.EffectImpact.LOW),
    NON_SYNONYMOUS_START(VariantEffect.EffectImpact.LOW),
    SPLICE_SITE_REGION(VariantEffect.EffectImpact.LOW),
    SPLICE_SITE_BRANCH(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_CODING(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_START(VariantEffect.EffectImpact.LOW),
    SYNONYMOUS_STOP(VariantEffect.EffectImpact.LOW),
    CODON_CHANGE(VariantEffect.EffectImpact.LOW),
    START_GAINED(VariantEffect.EffectImpact.LOW),
    MOTIF(VariantEffect.EffectImpact.LOW),
    MOTIF_DELETED(VariantEffect.EffectImpact.LOW),
    FEATURE_FUSION(VariantEffect.EffectImpact.LOW),
    UTR_5_PRIME(VariantEffect.EffectImpact.MODIFIER),
    UTR_3_PRIME(VariantEffect.EffectImpact.MODIFIER),
    REGULATION(VariantEffect.EffectImpact.MODIFIER),
    MICRO_RNA(VariantEffect.EffectImpact.MODIFIER),
    UPSTREAM(VariantEffect.EffectImpact.MODIFIER),
    DOWNSTREAM(VariantEffect.EffectImpact.MODIFIER),
    NEXT_PROT(VariantEffect.EffectImpact.MODIFIER),
    INTRON_CONSERVED(VariantEffect.EffectImpact.MODIFIER),
    INTRON(VariantEffect.EffectImpact.MODIFIER),
    INTRAGENIC(VariantEffect.EffectImpact.MODIFIER),
    INTERGENIC_CONSERVED(VariantEffect.EffectImpact.MODIFIER),
    INTERGENIC(VariantEffect.EffectImpact.MODIFIER),
    CDS(VariantEffect.EffectImpact.MODIFIER),
    EXON(VariantEffect.EffectImpact.MODIFIER),
    TRANSCRIPT(VariantEffect.EffectImpact.MODIFIER),
    GENE(VariantEffect.EffectImpact.MODIFIER),
    SEQUENCE(VariantEffect.EffectImpact.MODIFIER),
    CHROMOSOME_ELONGATION(VariantEffect.EffectImpact.MODIFIER),
    CUSTOM(VariantEffect.EffectImpact.MODIFIER),
    CHROMOSOME(VariantEffect.EffectImpact.MODIFIER),
    GENOME(VariantEffect.EffectImpact.MODIFIER),
    NONE(VariantEffect.EffectImpact.MODIFIER);

    private final VariantEffect.EffectImpact effectImpact;
    static Map<String, EffectType> so2efftype;

    private EffectType(VariantEffect.EffectImpact effectImpact) {
        this.effectImpact = effectImpact;
    }

    public static EffectType parse(EffFormatVersion formatVersion, String str) {
        try {
            return EffectType.valueOf(str);
        }
        catch (Exception exception) {
            if (so2efftype.isEmpty()) {
                EffectType.so2efftype(formatVersion, null);
                EffectType.so2efftype(formatVersion, Variant.NO_VARIANT);
            }
            if (so2efftype.containsKey(str)) {
                return so2efftype.get(str);
            }
            throw new RuntimeException("Cannot parse EffectType '" + str + "'");
        }
    }

    static void so2efftype(EffFormatVersion formatVersion, Variant variant) {
        for (EffectType efftype : EffectType.values()) {
            String so = efftype.toSequenceOntology(formatVersion, variant);
            for (String soSingle : so.split(formatVersion.separatorSplit())) {
                if (so2efftype.containsKey(soSingle)) continue;
                so2efftype.put(soSingle, efftype);
            }
        }
        HashMap<String, EffectType> oldSo2efftype = new HashMap<String, EffectType>();
        oldSo2efftype.put("non_coding_exon_variant", EXON);
        oldSo2efftype.put("inframe_insertion", CODON_INSERTION);
        oldSo2efftype.put("inframe_deletion", CODON_DELETION);
        oldSo2efftype.put("transcript", TRANSCRIPT);
        for (String so : oldSo2efftype.keySet()) {
            if (so2efftype.containsKey(so)) continue;
            so2efftype.put(so, (EffectType)((Object)oldSo2efftype.get(so)));
        }
    }

    public VariantEffect.EffectImpact effectImpact() {
        return this.effectImpact;
    }

    public EffectType getGeneRegion() {
        switch (this) {
            case NONE: 
            case CHROMOSOME: 
            case CHROMOSOME_LARGE_DELETION: 
            case CHROMOSOME_LARGE_DUPLICATION: 
            case CHROMOSOME_LARGE_INVERSION: 
            case CHROMOSOME_ELONGATION: 
            case CUSTOM: 
            case SEQUENCE: {
                return CHROMOSOME;
            }
            case INTERGENIC: 
            case INTERGENIC_CONSERVED: 
            case FEATURE_FUSION: {
                return INTERGENIC;
            }
            case UPSTREAM: {
                return UPSTREAM;
            }
            case UTR_5_PRIME: 
            case UTR_5_DELETED: 
            case START_GAINED: {
                return UTR_5_PRIME;
            }
            case SPLICE_SITE_ACCEPTOR: {
                return SPLICE_SITE_ACCEPTOR;
            }
            case SPLICE_SITE_BRANCH_U12: 
            case SPLICE_SITE_BRANCH: {
                return SPLICE_SITE_BRANCH;
            }
            case SPLICE_SITE_DONOR: {
                return SPLICE_SITE_DONOR;
            }
            case SPLICE_SITE_REGION: {
                return SPLICE_SITE_REGION;
            }
            case TRANSCRIPT_DELETED: 
            case TRANSCRIPT_DUPLICATION: 
            case TRANSCRIPT_INVERSION: 
            case INTRAGENIC: 
            case NEXT_PROT: 
            case TRANSCRIPT: 
            case CDS: {
                return TRANSCRIPT;
            }
            case GENE: 
            case GENE_DELETED: 
            case GENE_DUPLICATION: 
            case GENE_FUSION: 
            case GENE_FUSION_HALF: 
            case GENE_FUSION_REVERESE: 
            case GENE_INVERSION: 
            case GENE_REARRANGEMENT: {
                return GENE;
            }
            case EXON: 
            case EXON_DELETED: 
            case EXON_DELETED_PARTIAL: 
            case EXON_DUPLICATION: 
            case EXON_DUPLICATION_PARTIAL: 
            case EXON_INVERSION: 
            case EXON_INVERSION_PARTIAL: 
            case NON_SYNONYMOUS_START: 
            case NON_SYNONYMOUS_CODING: 
            case SYNONYMOUS_CODING: 
            case SYNONYMOUS_START: 
            case FRAME_SHIFT: 
            case CODON_CHANGE: 
            case CODON_INSERTION: 
            case CODON_CHANGE_PLUS_CODON_INSERTION: 
            case CODON_DELETION: 
            case CODON_CHANGE_PLUS_CODON_DELETION: 
            case START_LOST: 
            case STOP_GAINED: 
            case SYNONYMOUS_STOP: 
            case NON_SYNONYMOUS_STOP: 
            case STOP_LOST: 
            case RARE_AMINO_ACID: 
            case PROTEIN_PROTEIN_INTERACTION_LOCUS: 
            case PROTEIN_STRUCTURAL_INTERACTION_LOCUS: {
                return EXON;
            }
            case INTRON: 
            case INTRON_CONSERVED: {
                return INTRON;
            }
            case UTR_3_PRIME: 
            case UTR_3_DELETED: {
                return UTR_3_PRIME;
            }
            case DOWNSTREAM: {
                return DOWNSTREAM;
            }
            case REGULATION: {
                return REGULATION;
            }
            case MOTIF: 
            case MOTIF_DELETED: {
                return MOTIF;
            }
            case MICRO_RNA: {
                return MICRO_RNA;
            }
            case GENOME: {
                return GENOME;
            }
        }
        throw new RuntimeException("Unknown gene region for effect type: '" + (Object)((Object)this) + "'");
    }

    public boolean isFusion() {
        return this == GENE_FUSION || this == GENE_FUSION_REVERESE || this == GENE_FUSION_HALF || this == FEATURE_FUSION;
    }

    public String toSequenceOntology(EffFormatVersion formatVersion, Variant variant) {
        switch (this) {
            case CDS: {
                return "coding_sequence_variant";
            }
            case CHROMOSOME_LARGE_DELETION: {
                return "chromosome_number_variation";
            }
            case CHROMOSOME_LARGE_DUPLICATION: {
                return "duplication";
            }
            case CHROMOSOME_LARGE_INVERSION: {
                return "inversion";
            }
            case CHROMOSOME: {
                return "chromosome";
            }
            case CHROMOSOME_ELONGATION: {
                return "feature_elongation";
            }
            case CODON_CHANGE: {
                return "coding_sequence_variant";
            }
            case CODON_CHANGE_PLUS_CODON_INSERTION: {
                return "disruptive_inframe_insertion";
            }
            case CODON_CHANGE_PLUS_CODON_DELETION: {
                return "disruptive_inframe_deletion";
            }
            case CODON_DELETION: {
                return "conservative_inframe_deletion";
            }
            case CODON_INSERTION: {
                return "conservative_inframe_insertion";
            }
            case DOWNSTREAM: {
                return "downstream_gene_variant";
            }
            case EXON: {
                if (variant != null && (!variant.isVariant() || variant.isInterval())) {
                    return "exon_region";
                }
                return "non_coding_transcript_exon_variant";
            }
            case EXON_DELETED: {
                return "exon_loss_variant";
            }
            case EXON_DELETED_PARTIAL: {
                return "exon_loss_variant";
            }
            case EXON_DUPLICATION: {
                return "duplication";
            }
            case EXON_DUPLICATION_PARTIAL: {
                return "duplication";
            }
            case EXON_INVERSION: {
                return "inversion";
            }
            case EXON_INVERSION_PARTIAL: {
                return "inversion";
            }
            case FEATURE_FUSION: {
                return "feature_fusion";
            }
            case FRAME_SHIFT: {
                return "frameshift_variant";
            }
            case GENE: {
                return "gene_variant";
            }
            case GENE_INVERSION: {
                return "inversion";
            }
            case GENE_DELETED: {
                return "feature_ablation";
            }
            case GENE_DUPLICATION: {
                return "duplication";
            }
            case GENE_FUSION: {
                return "gene_fusion";
            }
            case GENE_FUSION_HALF: {
                return "transcript_ablation";
            }
            case GENE_FUSION_REVERESE: {
                return "bidirectional_gene_fusion";
            }
            case GENE_REARRANGEMENT: {
                return "rearranged_at_DNA_level";
            }
            case INTERGENIC: {
                return "intergenic_region";
            }
            case INTERGENIC_CONSERVED: {
                return "conserved_intergenic_variant";
            }
            case INTRON: {
                return "intron_variant";
            }
            case INTRON_CONSERVED: {
                return "conserved_intron_variant";
            }
            case INTRAGENIC: {
                return "intragenic_variant";
            }
            case MICRO_RNA: {
                return "miRNA";
            }
            case MOTIF: {
                return "TF_binding_site_variant";
            }
            case MOTIF_DELETED: {
                return "TFBS_ablation";
            }
            case NEXT_PROT: {
                return "sequence_feature";
            }
            case NON_SYNONYMOUS_CODING: {
                return "missense_variant";
            }
            case NON_SYNONYMOUS_START: {
                return "initiator_codon_variant";
            }
            case NON_SYNONYMOUS_STOP: {
                return "stop_retained_variant";
            }
            case PROTEIN_PROTEIN_INTERACTION_LOCUS: {
                return "protein_protein_contact";
            }
            case PROTEIN_STRUCTURAL_INTERACTION_LOCUS: {
                return "structural_interaction_variant";
            }
            case RARE_AMINO_ACID: {
                return "rare_amino_acid_variant";
            }
            case REGULATION: {
                return "regulatory_region_variant";
            }
            case SPLICE_SITE_ACCEPTOR: {
                return "splice_acceptor_variant";
            }
            case SPLICE_SITE_DONOR: {
                return "splice_donor_variant";
            }
            case SPLICE_SITE_REGION: {
                return "splice_region_variant";
            }
            case SPLICE_SITE_BRANCH: {
                return "splice_branch_variant";
            }
            case SPLICE_SITE_BRANCH_U12: {
                return "splice_branch_variant";
            }
            case START_LOST: {
                return "start_lost";
            }
            case START_GAINED: {
                return "5_prime_UTR_premature_start_codon_gain_variant";
            }
            case STOP_GAINED: {
                return "stop_gained";
            }
            case STOP_LOST: {
                return "stop_lost";
            }
            case SYNONYMOUS_CODING: {
                return "synonymous_variant";
            }
            case SYNONYMOUS_STOP: {
                return "stop_retained_variant";
            }
            case SYNONYMOUS_START: {
                return "initiator_codon_variant" + formatVersion.separator() + "non_canonical_start_codon";
            }
            case TRANSCRIPT: {
                return "non_coding_transcript_variant";
            }
            case TRANSCRIPT_DELETED: {
                return "transcript_ablation";
            }
            case TRANSCRIPT_DUPLICATION: {
                return "duplication";
            }
            case TRANSCRIPT_INVERSION: {
                return "inversion";
            }
            case UPSTREAM: {
                return "upstream_gene_variant";
            }
            case UTR_3_PRIME: {
                return "3_prime_UTR_variant";
            }
            case UTR_3_DELETED: {
                return "3_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case UTR_5_PRIME: {
                return "5_prime_UTR_variant";
            }
            case UTR_5_DELETED: {
                return "5_prime_UTR_truncation" + formatVersion.separator() + "exon_loss_variant";
            }
            case CUSTOM: {
                return "custom";
            }
            case NONE: 
            case SEQUENCE: 
            case GENOME: {
                return "";
            }
        }
        throw new RuntimeException("Unknown SO term for " + this.toString());
    }

    static {
        so2efftype = new HashMap<String, EffectType>();
    }
}

