/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import org.snpeff.interval.VariantBnd;
import org.snpeff.svg.Svg;

public class SvgBnd
extends Svg {
    public static final int BND_CURL_SIZE = 50;
    VariantBnd varBnd;
    Svg svgTr1;
    Svg svgTr2;

    public SvgBnd(VariantBnd varBnd, Svg svgTr1, Svg svgTr2) {
        this.varBnd = varBnd;
        this.svgTr1 = svgTr1;
        this.svgTr2 = svgTr2;
        this.lineStrokeWidth = 10;
        this.lineColor = "#ff00ff";
    }

    String bndType1() {
        StringBuilder sb = new StringBuilder();
        int pos1 = this.pos1();
        double x1 = this.svgTr1.pos2coord(pos1);
        double y1 = this.svgTr1.baseY + this.svgTr1.rectHeight / 2;
        int pos2 = this.pos2();
        double x2 = this.svgTr2.pos2coord(pos2);
        double y2 = this.svgTr2.baseY + this.svgTr2.rectHeight / 2;
        double d = this.lineStrokeWidth / 2;
        if (x1 < x2) {
            double x3 = (x1 + x2) / 2.0;
            sb.append(this.line(x1, y1, x3, y1));
            sb.append(this.line(x3, y1 - d, x3, y2 + d));
            sb.append(this.line(x2, y2, x3, y2));
        } else {
            double x1e = Math.min((double)this.sizeX, x1 + 50.0);
            double x2e = Math.max(0.0, x2 - 50.0);
            double ymid = (y1 + y2) / 2.0;
            sb.append(this.line(x1, y1, x1e, y1));
            sb.append(this.line(x1e, y1 - d, x1e, ymid + d));
            sb.append(this.line(x1e, ymid, x2e, ymid));
            sb.append(this.line(x2e, y2 + d, x2e, ymid - d));
            sb.append(this.line(x2, y2, x2e, y2));
        }
        return sb.toString();
    }

    String bndType2() {
        StringBuilder sb = new StringBuilder();
        int pos1 = this.pos1();
        double x1 = this.svgTr1.pos2coord(pos1);
        double y1 = this.svgTr1.baseY + this.svgTr1.rectHeight / 2;
        int pos2 = this.pos2();
        double x2 = this.svgTr2.pos2coord(pos2);
        double y2 = this.svgTr2.baseY + this.svgTr2.rectHeight / 2;
        double x3 = Math.min((double)this.sizeX, Math.max(x1, x2) + 50.0);
        double d = this.lineStrokeWidth / 2;
        sb.append(this.line(x1, y1, x3, y1));
        sb.append(this.line(x3, y1 - d, x3, y2 + d));
        sb.append(this.line(x2, y2, x3, y2));
        return sb.toString();
    }

    String bndType3() {
        StringBuilder sb = new StringBuilder();
        int pos1 = this.pos1();
        double x1 = this.svgTr1.pos2coord(pos1);
        double y1 = this.svgTr1.baseY + this.svgTr1.rectHeight / 2;
        int pos2 = this.pos2();
        double x2 = this.svgTr2.pos2coord(pos2);
        double y2 = this.svgTr2.baseY + this.svgTr2.rectHeight / 2;
        double d = this.lineStrokeWidth / 2;
        if (x2 < x1) {
            double x3 = (x1 + x2) / 2.0;
            sb.append(this.line(x1, y1, x3, y1));
            sb.append(this.line(x3, y1 - d, x3, y2 + d));
            sb.append(this.line(x2, y2, x3, y2));
        } else {
            double x1e = Math.max(0.0, x1 - 50.0);
            double x2e = Math.min((double)this.sizeX, x2 + 50.0);
            double ymid = (y1 + y2) / 2.0;
            sb.append(this.line(x1, y1, x1e, y1));
            sb.append(this.line(x1e, y1 - d, x1e, ymid + d));
            sb.append(this.line(x1e, ymid, x2e, ymid));
            sb.append(this.line(x2e, y2 + d, x2e, ymid - d));
            sb.append(this.line(x2, y2, x2e, y2));
        }
        return sb.toString();
    }

    String bndType4() {
        StringBuilder sb = new StringBuilder();
        int pos1 = this.pos1();
        double x1 = this.svgTr1.pos2coord(pos1);
        double y1 = this.svgTr1.baseY + this.svgTr1.rectHeight / 2;
        int pos2 = this.pos2();
        double x2 = this.svgTr2.pos2coord(pos2);
        double y2 = this.svgTr2.baseY + this.svgTr2.rectHeight / 2;
        double x3 = Math.max(0.0, Math.min(x1, x2) - 50.0);
        double d = this.lineStrokeWidth / 2;
        sb.append(this.line(x1, y1, x3, y1));
        sb.append(this.line(x3, y1 - d, x3, y2 + d));
        sb.append(this.line(x2, y2, x3, y2));
        return sb.toString();
    }

    int pos1() {
        return this.varBnd.getStart();
    }

    int pos2() {
        return this.varBnd.getEndPoint().getStart();
    }

    @Override
    public String toString() {
        if (!this.varBnd.isBefore()) {
            if (!this.varBnd.isLeft()) {
                return this.bndType1();
            }
            return this.bndType2();
        }
        if (this.varBnd.isLeft()) {
            return this.bndType3();
        }
        return this.bndType4();
    }
}

