/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdDbNsfp;

public class TestCasesDbNsfp
extends TestCase {
    public static boolean verbose = false;
    public static boolean debug = false;
    protected String[] defaultExtraArgs = null;
    protected boolean removeDataTypesCache = false;

    public List<VcfEntry> annotate(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        this.removeDataTypesCache(dbFileName);
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdDbNsfp cmd = (SnpSiftCmdDbNsfp)snpSift.cmd();
        cmd.setDbFileName(dbFileName);
        cmd.setVerbose(verbose);
        cmd.setSuppressOutput(!verbose);
        cmd.setDebug(debug);
        cmd.setTabixCheck(false);
        List<VcfEntry> results = cmd.run(true);
        Assert.assertTrue(results != null);
        Assert.assertTrue(results.size() > 0);
        return results;
    }

    public Map<String, String> annotateGetFiledTypes(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        this.removeDataTypesCache(dbFileName);
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdDbNsfp cmd = (SnpSiftCmdDbNsfp)snpSift.cmd();
        cmd.setDbFileName(dbFileName);
        cmd.setVerbose(verbose);
        cmd.setSuppressOutput(!verbose);
        cmd.setDebug(debug);
        cmd.setTabixCheck(false);
        List<VcfEntry> results = cmd.run(true);
        Assert.assertTrue(results != null);
        Assert.assertTrue(results.size() > 0);
        return cmd.getFieldsType();
    }

    protected String[] argsList(String dbFileName, String fileName, String[] extraArgs) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("dbNsfp");
        if (this.defaultExtraArgs != null) {
            for (String arg : this.defaultExtraArgs) {
                argsList.add(arg);
            }
        }
        if (extraArgs != null) {
            for (String arg : extraArgs) {
                argsList.add(arg);
            }
        }
        argsList.add(fileName);
        return argsList.toArray(new String[0]);
    }

    void removeDataTypesCache(String dbFileName) {
        String dtcFileName;
        File dtc;
        if (this.removeDataTypesCache && (dtc = new File(dtcFileName = dbFileName + ".data_types")).delete() && verbose) {
            Gpr.debug("Removing data types cache file: " + dtcFileName);
        }
    }

    public void test_01() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbNSFP_chr1_69134.vcf";
        String dbFileName = "test/dbNSFP2.0b3.chr1_69134.txt.gz";
        String[] args = new String[]{"-collapse", "-f", "GERP++_RS,GERP++_NR,ESP6500_AA_AF,29way_logOdds,Polyphen2_HVAR_pred,SIFT_score,Uniprot_acc,Ensembl_transcriptid"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals("2.31", vcfEntry.getInfo("dbNSFP_GERP___RS"));
        Assert.assertEquals("2.31", vcfEntry.getInfo("dbNSFP_GERP___NR"));
        Assert.assertEquals("0.004785", vcfEntry.getInfo("dbNSFP_ESP6500_AA_AF"));
        Assert.assertEquals("8.5094", vcfEntry.getInfo("dbNSFP_29way_logOdds"));
        Assert.assertEquals("B", vcfEntry.getInfo("dbNSFP_Polyphen2_HVAR_pred"));
        Assert.assertEquals("0.090000", vcfEntry.getInfo("dbNSFP_SIFT_score"));
        Assert.assertEquals("Q8NH21", vcfEntry.getInfo("dbNSFP_Uniprot_acc"));
        Assert.assertEquals("ENST00000534990,ENST00000335137", vcfEntry.getInfo("dbNSFP_Ensembl_transcriptid"));
    }

    public void test_02() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbnsfp_multiple.vcf";
        String dbFileName = "test/test_dbnsfp_multiple_lines.txt.gz";
        String fields = "genename,Ensembl_geneid,Ensembl_transcriptid,aaref,aaalt";
        String[] args = new String[]{"-collapse", "-f", fields};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals("ENST00000368485,ENST00000515190", vcfEntry.getInfo("dbNSFP_Ensembl_transcriptid"));
        Assert.assertEquals("IL6R", vcfEntry.getInfo("dbNSFP_genename"));
        Assert.assertEquals("ENSG00000160712", vcfEntry.getInfo("dbNSFP_Ensembl_geneid"));
        Assert.assertEquals("A,L", vcfEntry.getInfo("dbNSFP_aaalt"));
        Assert.assertEquals("D,I", vcfEntry.getInfo("dbNSFP_aaref"));
    }

    public void test_03() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbnsfp_multiple_noCollapse.vcf";
        String dbFileName = "test/test_dbnsfp_multiple_noCollapse.txt.gz";
        String fields = "aaalt,Ensembl_transcriptid,Polyphen2_HDIV_score,Polyphen2_HVAR_pred";
        String[] args = new String[]{"-nocollapse", "-f", fields};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals("ENST00000347404,ENST00000537835,ENST00000378535,ENST00000228280", vcfEntry.getInfo("dbNSFP_Ensembl_transcriptid"));
        Assert.assertEquals("0.449,.,0.192", vcfEntry.getInfo("dbNSFP_Polyphen2_HDIV_score"));
        Assert.assertEquals("B,.,B", vcfEntry.getInfo("dbNSFP_Polyphen2_HVAR_pred"));
        Assert.assertEquals("A,R,T", vcfEntry.getInfo("dbNSFP_aaalt"));
    }

    public void test_04() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbNSFP_04.vcf";
        String dbFileName = "test/dbNSFP2.3.test.txt.gz";
        String[] args = new String[]{"-collapse", "-f", "pos(1-coor)"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        for (VcfEntry vcfEntry : results) {
            String posDb = vcfEntry.getInfo("dbNSFP_pos_1_coor_");
            int pos = vcfEntry.getStart() + 1;
            Assert.assertEquals("" + pos, posDb);
        }
    }

    public void test_05() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbNSFP_05.vcf";
        String dbFileName = "test/dbNSFP2.3.test.txt.gz";
        String[] args = new String[]{"-f", "pos(1-coor)"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        for (VcfEntry vcfEntry : results) {
            String posDb = vcfEntry.getInfo("dbNSFP_pos_1_coor_");
            int pos = vcfEntry.getStart() + 1;
            if (debug) {
                Gpr.debug(vcfEntry.getChromosomeName() + ":" + pos + "\t" + posDb);
            }
            if (pos != 249213000) {
                Assert.assertEquals("" + pos, posDb);
                continue;
            }
            Assert.assertEquals(null, posDb);
        }
    }

    public void test_06() {
        Gpr.debug("Test");
        String vcfFileName = "test/test_dbNSFP_06.vcf";
        String dbFileName = "test/dbNSFP2.3.test.txt.gz";
        String[] args = new String[]{"-f", "pos(1-coor)"};
        this.annotate(dbFileName, vcfFileName, args);
    }

    public void test_07() {
        String vcfFileName = "test/test.dbnsfp.07.vcf";
        String dbFileName = "test/dbNSFP2.4.head_100.txt.gz";
        String[] args = new String[]{"-f", "SIFT_score"};
        Map<String, String> fieldTypes = this.annotateGetFiledTypes(dbFileName, vcfFileName, args);
        Assert.assertEquals("Float", fieldTypes.get("SIFT_score"));
    }

    public void test_08() {
        String vcfFileName = "test/test_dbNSFP_8.vcf";
        String dbFileName = "test/dbNSFP2.4.chr4_55946200_55946300.txt.gz";
        String[] args = new String[]{"-collapse", "-a", "-f", "Polyphen2_HDIV_score"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals(".,1.0,1.0", vcfEntry.getInfo("dbNSFP_Polyphen2_HDIV_score"));
    }

    public void test_09() {
        String vcfFileName = "test/test_dbNSFP_8.vcf";
        String dbFileName = "test/dbNSFP2.4.chr4_55946200_55946300.txt.gz";
        String[] args = new String[]{"-a", "-f", "GERP++_NR"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals("5.62,5.62,5.62", vcfEntry.getInfo("dbNSFP_GERP___NR"));
    }

    public void test_10() {
        String vcfFileName = "test/test_dbNSFP_10.vcf";
        String dbFileName = "test/dbNSFP2.4.chr4_55946200_55946300.txt.gz";
        String[] args = new String[]{"-collapse", "-a", "-m", "-f", "Polyphen2_HDIV_score"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals(".", vcfEntry.getInfo("dbNSFP_Polyphen2_HDIV_score"));
    }

    public void test_11() {
        String vcfFileName = "test/test_dbNSFP_11.vcf";
        String dbFileName = "test/dbNSFP2.4.chr4_55946200_55946300.txt.gz";
        String[] args = new String[]{"-collapse", "-a", "-m", "-f", "Polyphen2_HDIV_score"};
        List<VcfEntry> results = this.annotate(dbFileName, vcfFileName, args);
        VcfEntry vcfEntry = results.get(0);
        Assert.assertEquals(".,1.0", vcfEntry.getInfo("dbNSFP_Polyphen2_HDIV_score"));
    }
}

