/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.gtex;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.gtex.GtexExperiment;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Gtex
implements Iterable<GtexExperiment> {
    public static final String NA_VALUE = "NA";
    boolean verbose = false;
    HashMap<String, GtexExperiment> experiments = new HashMap();
    HashMap<String, Integer> geneId2Index = new HashMap();
    String[] geneIds;

    public Collection<String> getGeneIds() {
        return this.geneId2Index.keySet();
    }

    public int getIndex(String geneId) {
        return this.geneId2Index.get(geneId);
    }

    @Override
    public Iterator<GtexExperiment> iterator() {
        return this.experiments.values().iterator();
    }

    public void load(String samples, String data2) {
        this.loadSamples(samples);
        this.loadData(data2);
    }

    protected void loadData(String data2) {
        if (this.verbose) {
            Timer.showStdErr("Loaded GTEx data from file " + data2);
        }
        if (!Gpr.canRead(data2)) {
            throw new RuntimeException("Cannot find data file '" + data2 + "'");
        }
        this.geneId2Index = new HashMap();
        LineFileIterator lfi = new LineFileIterator(data2);
        String[] exIds = null;
        int index = 0;
        for (String line : lfi) {
            String[] fields = line.split("\t", -1);
            if (lfi.getLineNum() <= 1) {
                exIds = fields;
                for (int i = 0; i < exIds.length; ++i) {
                    exIds[i] = exIds[i].replace('.', '-');
                }
                continue;
            }
            String geneId = fields[0];
            geneId = geneId.split("\\.")[0];
            this.geneId2Index.put(geneId, index);
            for (int i = 2; i < fields.length; ++i) {
                String exId = exIds[i];
                GtexExperiment gtexExperiment = this.experiments.get(exId);
                if (gtexExperiment == null) {
                    throw new RuntimeException("Cannot find experiment '" + exId + "'");
                }
                if (gtexExperiment.size() != index) {
                    throw new RuntimeException("Index doesn't match: " + gtexExperiment.size() + "!=" + index);
                }
                double value2 = Double.NaN;
                if (!fields[i].equals(NA_VALUE)) {
                    value2 = Gpr.parseDoubleSafe(fields[i]);
                }
                gtexExperiment.add(value2);
            }
            ++index;
        }
        if (this.verbose) {
            Timer.showStdErr("Done. Loaded " + this.experiments.size() + " experiments.");
        }
    }

    protected void loadSamples(String samples) {
        if (this.verbose) {
            Timer.showStdErr("Loaded GTEx experiments from file " + samples);
        }
        if (!Gpr.canRead(samples)) {
            throw new RuntimeException("Cannot find samples file '" + samples + "'");
        }
        this.experiments = new HashMap();
        LineFileIterator lfi = new LineFileIterator(samples);
        for (String line : lfi) {
            if (lfi.getLineNum() <= 1) continue;
            GtexExperiment gtexExperiment = new GtexExperiment(this, line);
            this.experiments.put(gtexExperiment.getId(), gtexExperiment);
        }
        if (this.verbose) {
            Timer.showStdErr("Done. Loaded " + this.experiments.size() + " experiments.");
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GtexExperiment gex : this.experiments.values()) {
            sb.append(gex + "\n");
        }
        return sb.toString();
    }
}

