/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.outputFormatter;

import java.util.HashSet;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.outputFormatter.OutputFormatter;
import org.snpeff.snpEffect.VariantEffect;

public class BedOutputFormatter
extends OutputFormatter {
    public BedOutputFormatter() {
        this.outOffset = 0;
    }

    @Override
    public String endSection(Marker marker) {
        if (marker instanceof Variant) {
            return super.endSection(marker);
        }
        return null;
    }

    @Override
    public void setOutOffset(int outOffset) {
        throw new RuntimeException("Cannot set output offset on '" + this.getClass().getSimpleName() + "' formatter!");
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof Variant) {
            super.startSection(marker);
        }
    }

    @Override
    public String toString() {
        Variant seqChange = (Variant)this.section;
        HashSet<String> chEffs = new HashSet<String>();
        for (VariantEffect varEff : this.variantEffects) {
            if (this.variantEffectResutFilter != null && this.variantEffectResutFilter.filter(varEff)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(varEff.effect(true, false, false, this.useSequenceOntology, false));
            Marker m = varEff.getMarker();
            if (m == null) continue;
            chEffs.add(m.idChain("|", ":", this.useGeneId, varEff));
        }
        StringBuilder changeEffSb = new StringBuilder();
        changeEffSb.append(seqChange.getId());
        for (String chEff : chEffs) {
            changeEffSb.append(";");
            changeEffSb.append(chEff);
        }
        return this.chrStr + seqChange.getChromosomeName() + "\t" + (seqChange.getStart() + this.outOffset) + "\t" + (seqChange.getEnd() + 1) + "\t" + changeEffSb.toString();
    }

    @Override
    public String toStringHeader() {
        return "# SnpEff version " + this.version + "\n# Command line: " + this.commandLineStr + "\n# Chromo\tStart\tEnd\tName;Effect|Gene|BioType\tScore";
    }
}

