/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.snpeff.RegulationConsensusMultipleBed;
import org.snpeff.RegulationFileConsensus;
import org.snpeff.RegulationFileSplitBytType;
import org.snpeff.SnpEff;
import org.snpeff.codons.FindRareAaIntervals;
import org.snpeff.fileIterator.MotifFileIterator;
import org.snpeff.fileIterator.RegulationGffFileIterator;
import org.snpeff.interval.ExonSpliceCharacterizer;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Motif;
import org.snpeff.interval.RareAminoAcid;
import org.snpeff.motif.Jaspar;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.commandLine.SnpEffCmdCds;
import org.snpeff.snpEffect.commandLine.SnpEffCmdProtein;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGenBank;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGenesFile;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff2;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff3;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryKnownGene;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdBuild
extends SnpEff {
    SnpEff.GeneDatabaseFormat geneDatabaseFormat = null;
    boolean checkNumOk = true;
    boolean storeAlignments;
    boolean storeSequences = false;
    boolean regSortedByType = false;
    String cellType = null;
    SnpEffCmdProtein snpEffCmdProtein;
    SnpEffCmdCds snpEffCmdCds;

    void checkDb(SnpEffPredictorFactory snpEffectPredictorFactory) {
        String cdsFile = this.config.getFileNameCds();
        if (Gpr.canRead(cdsFile)) {
            if (this.verbose) {
                Timer.showStdErr("CDS check (FASTA file): '" + cdsFile + "'\n");
            }
            this.snpEffCmdCds = new SnpEffCmdCds(this.config);
            this.snpEffCmdCds.setVerbose(this.verbose);
            this.snpEffCmdCds.setDebug(this.debug);
            this.snpEffCmdCds.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdCds.setCheckNumOk(this.checkNumOk);
            this.snpEffCmdCds.run();
        } else if (this.debug) {
            Timer.showStdErr("\tOptional file '" + cdsFile + "' not found, nothing done.");
        }
        String protFile = null;
        Map<String, String> proteinByTrId = snpEffectPredictorFactory.getProteinByTrId();
        protFile = this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK ? this.config.getBaseFileNameGenes() + ".gbk" : (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL ? this.config.getBaseFileNameGenes() + ".embl" : this.config.getFileNameProteins());
        if (Gpr.canRead(protFile)) {
            if (this.verbose) {
                Timer.showStdErr("Protein check file: '" + protFile + "'\n");
            }
            this.snpEffCmdProtein = new SnpEffCmdProtein(this.config, protFile);
            this.snpEffCmdProtein.setVerbose(this.verbose);
            this.snpEffCmdProtein.setDebug(this.debug);
            this.snpEffCmdProtein.setStoreAlignments(this.storeAlignments);
            this.snpEffCmdProtein.setCheckNumOk(this.checkNumOk);
            this.snpEffCmdProtein.setProteinByTrId(proteinByTrId);
            this.snpEffCmdProtein.run();
        } else if (this.debug) {
            Timer.showStdErr("\tOptional file '" + protFile + "' not found, nothing done.");
        }
    }

    SnpEffPredictorFactory createSnpEffPredictorFactory() {
        if (this.geneDatabaseFormat == null) {
            this.geneDatabaseFormat = this.guessGenesFormat();
        }
        SnpEffPredictorFactory factory = null;
        if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GTF22) {
            factory = new SnpEffPredictorFactoryGtf22(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF3) {
            factory = new SnpEffPredictorFactoryGff3(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF2) {
            factory = new SnpEffPredictorFactoryGff2(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.REFSEQ) {
            factory = new SnpEffPredictorFactoryRefSeq(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.KNOWN_GENES) {
            factory = new SnpEffPredictorFactoryKnownGene(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            factory = new SnpEffPredictorFactoryGenBank(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL) {
            factory = new SnpEffPredictorFactoryEmbl(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.BIOMART) {
            factory = new SnpEffPredictorFactoryGenesFile(this.config);
        } else {
            throw new RuntimeException("Unimplemented format " + (Object)((Object)this.geneDatabaseFormat));
        }
        factory.setVerbose(this.verbose);
        factory.setDebug(this.debug);
        factory.setStoreSequences(this.storeSequences);
        return factory;
    }

    protected boolean fileExists(String path) {
        return Gpr.exists(path) || Gpr.exists(path + ".gz");
    }

    public SnpEffCmdCds getSnpEffCmdCds() {
        return this.snpEffCmdCds;
    }

    public SnpEffCmdProtein getSnpEffCmdProtein() {
        return this.snpEffCmdProtein;
    }

    protected SnpEff.GeneDatabaseFormat guessGenesFormat() {
        String genesBase = this.config.getBaseFileNameGenes();
        if (this.fileExists(genesBase + ".gtf")) {
            return SnpEff.GeneDatabaseFormat.GTF22;
        }
        if (this.fileExists(genesBase + ".gff")) {
            return SnpEff.GeneDatabaseFormat.GFF3;
        }
        if (this.fileExists(genesBase + ".gff2")) {
            return SnpEff.GeneDatabaseFormat.GFF2;
        }
        if (this.fileExists(genesBase + ".gbk")) {
            return SnpEff.GeneDatabaseFormat.GENBANK;
        }
        if (this.fileExists(genesBase + ".embl")) {
            return SnpEff.GeneDatabaseFormat.EMBL;
        }
        if (this.fileExists(genesBase + ".refseq")) {
            return SnpEff.GeneDatabaseFormat.REFSEQ;
        }
        if (this.fileExists(genesBase + ".kg")) {
            return SnpEff.GeneDatabaseFormat.KNOWN_GENES;
        }
        if (this.fileExists(genesBase + ".biomart")) {
            return SnpEff.GeneDatabaseFormat.BIOMART;
        }
        if (this.geneDatabaseFormat == null) {
            this.fatalError("Cannot guess input database format for genome '" + this.genomeVer + "'. No genes file found '" + genesBase + ".*'");
        }
        return null;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-gff3": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF3;
                        break;
                    }
                    case "-gff2": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF2;
                        break;
                    }
                    case "-gtf22": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GTF22;
                        break;
                    }
                    case "-refseq": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.REFSEQ;
                        break;
                    }
                    case "-genbank": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GENBANK;
                        break;
                    }
                    case "-knowngenes": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.KNOWN_GENES;
                        break;
                    }
                    case "-embl": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.EMBL;
                        break;
                    }
                    case "-txt": {
                        this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.BIOMART;
                        break;
                    }
                    case "-storeseqs": {
                        this.storeSequences = true;
                        break;
                    }
                    case "-nostoreseqs": {
                        this.storeSequences = false;
                        break;
                    }
                    case "-onlyreg": {
                        this.onlyRegulation = true;
                        break;
                    }
                    case "-celltype": {
                        if (i + 1 < args.length) {
                            this.cellType = args[++i];
                            break;
                        }
                        this.usage("Missing 'regType' argument");
                        break;
                    }
                    case "-regsortedbytype": {
                        this.regSortedByType = true;
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void rareAa(SnpEffectPredictor snpEffectPredictor) {
        block7: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Rare amino acid annotations");
            }
            String proteinsFile = this.config.getFileNameProteins();
            try {
                FindRareAaIntervals findRare = new FindRareAaIntervals(snpEffectPredictor.getGenome());
                findRare.setVerbose(this.verbose);
                Collection<RareAminoAcid> raas = findRare.findRareAa(proteinsFile);
                for (RareAminoAcid raa : raas) {
                    if (this.verbose) {
                        System.err.println("\tAdding: " + raa);
                    }
                    snpEffectPredictor.add(raa);
                }
                if (this.verbose) {
                    Timer.showStdErr("Done.");
                }
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional protein sequence file '" + proteinsFile + "', nothing done.");
                }
                if (!this.debug) break block7;
                t.printStackTrace();
            }
        }
    }

    void readRegulationBed() {
        if (this.verbose) {
            Timer.showStdErr("[Optional] Reading regulation elements: BED ");
        }
        String inDir = this.config.getDirRegulationBed();
        String outDir = this.config.getDirDataGenomeVersion();
        File dir = new File(inDir);
        if (!dir.exists() || !dir.isDirectory()) {
            if (this.verbose) {
                Timer.showStdErr("Cannot find optional regulation dir '" + inDir + "', nothing done.");
            }
            return;
        }
        RegulationConsensusMultipleBed regBeds = new RegulationConsensusMultipleBed(inDir, outDir);
        regBeds.setVerbose(this.verbose);
        regBeds.setCellType(this.cellType);
        regBeds.run();
    }

    void readRegulationGff() {
        String regulationFileName;
        if (this.verbose) {
            Timer.showStdErr("[Optional] Reading regulation elements: GFF");
        }
        if (!Gpr.canRead(regulationFileName = this.config.getBaseFileNameRegulation() + ".gff")) {
            if (this.verbose) {
                Timer.showStdErr("Warning: Cannot read optional regulation file '" + regulationFileName + "', nothing done.");
            }
            return;
        }
        RegulationGffFileIterator regulationFileIterator = new RegulationGffFileIterator(regulationFileName);
        RegulationFileSplitBytType regSplit = new RegulationFileSplitBytType();
        regSplit.setVerbose(this.verbose);
        regSplit.splitFile(regulationFileIterator, this.config.getDirDataGenomeVersion());
        for (String regFileName : regSplit.getRegFileNames()) {
            regulationFileIterator = new RegulationGffFileIterator(regFileName);
            RegulationFileConsensus regulationGffConsensus = new RegulationFileConsensus();
            regulationGffConsensus.setVerbose(this.verbose);
            regulationGffConsensus.setOutputDir(this.config.getDirDataGenomeVersion());
            regulationGffConsensus.readFile(regulationFileIterator);
            regulationGffConsensus.save();
        }
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    void readRegulationMotif() {
        block11: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Reading motifs: GFF");
            }
            String motifFileName = this.config.getBaseFileNameMotif() + ".gff";
            String motifBinFileName = this.config.getBaseFileNameMotif() + ".bin";
            String pwmsFileName = this.config.getDirDataGenomeVersion() + "/pwms.bin";
            if (!Gpr.exists(pwmsFileName)) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot open PWMs file " + pwmsFileName + ". Nothing done");
                }
                return;
            }
            try {
                if (this.verbose) {
                    Timer.showStdErr("\tLoading PWMs from : " + pwmsFileName);
                }
                Jaspar jaspar = new Jaspar();
                jaspar.load(pwmsFileName);
                if (this.verbose) {
                    Timer.showStdErr("\tLoading motifs from : " + motifFileName);
                }
                MotifFileIterator motifFileIterator = new MotifFileIterator(motifFileName, this.config.getGenome(), jaspar);
                Markers motifs = new Markers();
                for (Motif motif : motifFileIterator) {
                    motifs.add(motif);
                }
                if (this.verbose) {
                    Timer.showStdErr("\tLoadded motifs: " + motifs.size());
                }
                if (this.verbose) {
                    Timer.showStdErr("\tSaving motifs to: " + motifBinFileName);
                }
                motifs.save(motifBinFileName);
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional motif file '" + motifFileName + "', nothing done.");
                }
                if (!this.debug) break block11;
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Building database for '" + this.genomeVer + "'");
        }
        this.loadConfig();
        if (!this.onlyRegulation) {
            SnpEffPredictorFactory snpEffectPredictorFactory = this.createSnpEffPredictorFactory();
            SnpEffectPredictor snpEffectPredictor = snpEffectPredictorFactory.create();
            this.config.setSnpEffectPredictor(snpEffectPredictor);
            ExonSpliceCharacterizer exonSpliceCharacterizer = new ExonSpliceCharacterizer(snpEffectPredictor.getGenome());
            exonSpliceCharacterizer.setVerbose(this.verbose);
            exonSpliceCharacterizer.characterize();
            this.rareAa(snpEffectPredictor);
            this.checkDb(snpEffectPredictorFactory);
            if (this.verbose) {
                Timer.showStdErr("Saving database");
            }
            snpEffectPredictor.save(this.config);
        }
        if (this.cellType == null) {
            this.readRegulationGff();
        }
        this.readRegulationBed();
        this.readRegulationMotif();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return true;
    }

    public void setCheckNumOk(boolean checkNumOk) {
        this.checkNumOk = checkNumOk;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff build [options] genome_version");
        System.err.println("\nBuild DB options:");
        System.err.println("\nDatabase format option (default: Auto detect):");
        System.err.println("\t-embl                        : Use Embl format.");
        System.err.println("\t-genbank                     : Use GenBank format.");
        System.err.println("\t-gff2                        : Use GFF2 format (obsolete).");
        System.err.println("\t-gff3                        : Use GFF3 format.");
        System.err.println("\t-gtf22                       : Use GTF 2.2 format.");
        System.err.println("\t-knowngenes                  : Use KnownGenes table from UCSC.");
        System.err.println("\t-refseq                      : Use RefSeq table from UCSC.");
        System.err.println("\nDatabase build options:");
        System.err.println("\t-cellType <type>             : Only build regulation tracks for cellType <type>.");
        System.err.println("\t-noStoreSeqs                 : Do not store sequence in binary files. Default: " + !this.storeSequences);
        System.err.println("\t-onlyReg                     : Only build regulation tracks.");
        System.err.println("\t-regSortedByType             : The 'regulation.gff' file is sorted by 'regulation type' instead of sorted by chromosome:pos. Default: " + this.regSortedByType);
        System.err.println("\t-storeSeqs                   : Store sequence in binary files. Default: " + this.storeSequences);
        this.usageGeneric();
        System.exit(-1);
    }
}

