/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import org.junit.Assert;
import org.junit.Test;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.integration.TestCasesHgvsBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.vcf.VcfEntry;

public class TestCasesHgvsExon
extends TestCasesHgvsBase {
    @Test
    public void test_01_coding() {
        Gpr.debug("Test");
        int N = 1000;
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor(false, true);
            if (this.debug) {
                System.out.println("HGSV Test iteration: " + i + "\n" + this.transcript);
            } else if (this.verbose) {
                System.out.println("HGSV Coding\titeration: " + i + "\t" + (this.transcript.isStrandPlus() ? "+" : "-") + "\t" + this.transcript.cds());
            } else {
                Gpr.showMark(i + 1, 1);
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int pos = exon.getStart();
                while (exon.getStart() <= pos && pos <= exon.getEnd()) {
                    char refBase = this.chromoBases[pos];
                    refBase = Character.toUpperCase(refBase);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int minCodonPos = cdsCodonNum * 3;
                    int maxCodonPos = minCodonPos + 3;
                    if (maxCodonPos < this.transcript.cds().length()) {
                        String codon = this.transcript.cds().substring(minCodonPos, maxCodonPos);
                        codon = codon.toUpperCase();
                        String aa = codonTable.aaThreeLetterCode(codonTable.aa(codon));
                        char snp = refBase;
                        while (snp == refBase) {
                            snp = Character.toUpperCase(GprSeq.randBase(this.rand));
                        }
                        String newCodon = codon.substring(0, cdsCodonPos) + snp + codon.substring(cdsCodonPos + 1);
                        String newAa = codonTable.aaThreeLetterCode(codonTable.aa(newCodon));
                        String protHgvs = "";
                        String dnaHgvs = "c." + (cdsBaseNum + 1) + refBase + ">" + snp;
                        protHgvs = newAa.equals(aa) ? (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "p." + aa + "1?" : "p." + aa + "1?") : "p." + aa + (cdsCodonNum + 1) + newAa) : (cdsCodonNum == 0 && codonTable.isStart(codon) ? (codonTable.isStart(newCodon) ? "p." + aa + "1?" : "p." + aa + "1?") : (codonTable.isStop(codon) ? "p." + aa + (cdsCodonNum + 1) + newAa + "ext*?" : (codonTable.isStop(newCodon) ? "p." + aa + (cdsCodonNum + 1) + "*" : "p." + aa + (cdsCodonNum + 1) + newAa)));
                        String effectExpected = protHgvs + "/" + dnaHgvs;
                        Variant variant = new Variant((Marker)this.chromosome, pos, refBase + "", snp + "", "");
                        if (!variant.isVariant()) {
                            protHgvs = "EXON";
                        }
                        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
                        Assert.assertEquals(true, effects.size() <= 1);
                        if (effects.size() == 1) {
                            VariantEffect effect = effects.get();
                            String effStr = effect.getHgvs();
                            if (this.debug) {
                                System.out.println("\tPos: " + pos + "\tCDS base num: " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]\t" + variant + "\tCodon: " + codon + " -> " + newCodon + "\tAA: " + aa + " -> " + newAa + "\tEffect expected: " + effectExpected + "\tEffect: " + effStr);
                            }
                            Assert.assertEquals(effectExpected, effStr);
                            if (!VcfEntry.isValidInfoValue(effStr)) {
                                String err2 = "No white-space, semi-colons, or equals-signs are permitted in INFO field. Value:\"" + effStr + "\"";
                                System.err.println(err2);
                                throw new RuntimeException(err2);
                            }
                        }
                    }
                    ++pos;
                    ++cdsBaseNum;
                }
            }
        }
        System.err.println("");
    }
}

