/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import java.util.Optional;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationSpliceRegion
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String file = "tests/integration/splice_region/test.splice_region_01.vcf";
        String[] args = new String[]{"-canon"};
        int pos = 117174416;
        List<VcfEntry> vcfEntries = this.snpEffect("testHg19Chr7", file, args, EffFormatVersion.FORMAT_ANN_1);
        if (this.verbose) {
            vcfEntries.stream().forEach(v -> System.out.println("VcfEffect:" + v));
        }
        Optional oeff = vcfEntries.stream().filter(v -> v.getStart() == pos).flatMap(v -> v.getVcfEffects().stream()).findFirst();
        if (this.verbose) {
            System.out.println("VcfEffect:" + oeff);
        }
        Assert.assertNotNull("Could not find any variant effect at position " + pos, oeff.isPresent());
        List<EffectType> effTypes = ((VcfEffect)oeff.get()).getEffectTypes();
        if (this.verbose) {
            System.out.println("effTypes:" + effTypes);
        }
        Assert.assertTrue("Effect type 'SPLICE_SITE_REGION' not found", effTypes.contains((Object)EffectType.SPLICE_SITE_REGION));
    }
}

