/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.junit.Test;
import org.snpeff.gsa.ScoreList;
import org.snpeff.util.Gpr;

public class TestCasesGenePvalueList {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        double[] pvals = new double[]{0.01, 0.2, 0.3};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.MIN);
        Assert.assertEquals(0.01, pvalue);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        double[] pvals = new double[]{0.01, 0.2, 0.3};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.AVG);
        Assert.assertEquals(0.17, pvalue);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        double[] pvals = new double[]{0.01, 0.9, 0.2, 0.9, 0.3, 0.9, 0.01, 0.9, 0.2, 0.9, 0.3, 0.9, 0.01, 0.9, 0.2, 0.9, 0.3, 0.9, 0.17, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.AVG_MIN_10);
        Assert.assertEquals(0.17, pvalue);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        Random rand = new Random(20130609L);
        for (int i = 0; i < 100000; ++i) {
            int degOfFreedom = rand.nextInt(20) + 1;
            double chi2 = 0.0;
            for (int j = 0; j < degOfFreedom; ++j) {
                double z = rand.nextGaussian();
                chi2 += z * z;
            }
            double pval = ScoreList.chiSquareCDFComplementary(chi2, degOfFreedom);
            double prob = new ChiSquaredDistribution(degOfFreedom).cumulativeProbability(chi2);
            Assert.assertEquals(1.0, pval + prob);
        }
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        double[] pvals = new double[]{0.01, 0.2, 0.3};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.FISHER_CHI_SQUARE);
        Assert.assertEquals(0.021561751324834642, pvalue);
    }

    @Test
    public void test_06() {
        Gpr.debug("Test");
        double[] pvals = new double[]{0.01, 0.2, 0.3};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.Z_SCORES);
        Assert.assertEquals(0.01651203260896289, pvalue);
    }

    @Test
    public void test_07() {
        Gpr.debug("Test");
        double[] pvals = new double[]{2.354054E-7, 2.10159E-5, 2.576842E-5, 9.814783E-5, 1.05261E-4, 1.241481E-4, 1.325988E-4, 1.568503E-4, 2.254557E-4, 3.79538E-4, 6.114943E-4, 0.001613954, 0.00330243, 0.003538342, 0.005236997, 0.006831909, 0.007059226, 0.008805129, 0.00940104, 0.01129798, 0.02115017, 0.04922736, 0.06053298, 0.06262239, 0.07395153, 0.08281103, 0.08633331, 0.1190654, 0.1890796, 0.2058494, 0.2209214, 0.2856, 0.3048895, 0.4660682, 0.4830809, 0.4921755, 0.5319453, 0.575155, 0.5783195, 0.6185894, 0.636362, 0.6448587, 0.6558414, 0.6885884, 0.7189864, 0.8179539, 0.8274487, 0.89713, 0.911868, 0.943789};
        ScoreList gpl = new ScoreList();
        for (double pval : pvals) {
            gpl.add(pval);
        }
        double pvalue = gpl.score(ScoreList.ScoreSummary.FDR);
        Assert.assertEquals(0.028244949999999998, pvalue);
        pvalue = gpl.pValueFdr(5.0E-4);
        Assert.assertEquals(4.294736666666667E-4, pvalue);
        pvalue = gpl.pValueFdr(6.0E-4);
        Assert.assertEquals(4.294736666666667E-4, pvalue);
    }

    @Test
    public void test_08() {
        double quantile;
        int i;
        Gpr.debug("Test");
        ScoreList pvlist = new ScoreList();
        int max2 = 1000;
        for (i = 0; i < max2; ++i) {
            quantile = (double)i / (double)max2;
            pvlist.add(quantile);
        }
        for (i = 0; i < max2; ++i) {
            quantile = (double)i / (double)max2;
            double pval = pvlist.quantile(quantile);
            Assert.assertEquals(quantile, pval);
        }
    }

    @Test
    public void test_09() {
        double quantile;
        int i;
        Gpr.debug("Test");
        ScoreList pvlist = new ScoreList();
        int max2 = 1000;
        for (i = 0; i < max2; ++i) {
            quantile = (double)i / (double)max2;
            pvlist.add(quantile);
        }
        for (i = 0; i < max2; ++i) {
            quantile = (double)i / (double)max2;
            double pval = pvlist.cdf(quantile);
            Assert.assertEquals(quantile, pval);
        }
    }
}

