/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CytoBands;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;

public class TestCasesStructuralTranslocations {
    EffFormatVersion formatVersion = EffFormatVersion.FORMAT_ANN;
    boolean debug;
    boolean verbose = this.debug = false;
    Random rand = new Random(20160229L);
    Config config;
    String chr1Seq;
    String chr2Seq;
    Genome genome;
    Chromosome chr1;
    Chromosome chr2;
    Gene gene1;
    Gene gene2;
    Transcript tr1;
    Transcript tr2;
    SnpEffectPredictor snpEffectPredictor;

    Set<String> arrayToSet(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array != null) {
            for (String h : array) {
                set.add(h);
            }
        }
        return set;
    }

    protected void checkEffects(Variant variant, EffectType[] expEffs, EffectType[] notExpEffs, String[] expHgvsp, String[] expHgvsc, VariantEffect.EffectImpact expectedImpact, String[] expAnns) {
        HashSet<EffectType> expectedEffs = new HashSet<EffectType>();
        if (expEffs != null) {
            for (EffectType et : expEffs) {
                expectedEffs.add(et);
            }
        }
        HashSet<EffectType> notExpectedEffs = new HashSet<EffectType>();
        if (notExpEffs != null) {
            for (EffectType et : notExpEffs) {
                notExpectedEffs.add(et);
            }
        }
        Set<String> expectedHgvsp = this.arrayToSet(expHgvsp);
        Set<String> expectedHgvsc = this.arrayToSet(expHgvsc);
        Set<String> expectedAnns = this.arrayToSet(expAnns);
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
            for (Gene g : this.genome.getGenes()) {
                Gpr.debug("\tGene: " + g.getId() + "\t" + this.gene1.getStart() + " - " + this.gene1.getEnd());
                for (Transcript tr : g) {
                    Gpr.debug(tr + "\n\n" + tr.toStringAsciiArt(true));
                }
            }
        }
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        if (this.verbose) {
            Gpr.debug("VariantEffects: " + effects);
        }
        Assert.assertEquals(true, effects.size() >= 1);
        HashSet<EffectType> effs = new HashSet<EffectType>();
        HashSet<String> hgvscs = new HashSet<String>();
        HashSet<String> hgvsps = new HashSet<String>();
        HashSet<String> anns = new HashSet<String>();
        boolean impactOk = false;
        for (VariantEffect varEff : effects) {
            effs.addAll(varEff.getEffectTypes());
            HgvsDna hgvsc = new HgvsDna(varEff);
            String hgvsDna = hgvsc.toString();
            hgvscs.add(hgvsDna);
            HgvsProtein hgvsp = new HgvsProtein(varEff);
            String hgvsProt = hgvsp.toString();
            hgvsps.add(hgvsProt);
            impactOk |= varEff.getEffectImpact() == expectedImpact;
            VcfEffect vcfEffect = new VcfEffect(varEff, this.formatVersion);
            String annField = vcfEffect.toString();
            anns.add(annField);
            if (!this.verbose) continue;
            Gpr.debug("Effect: " + varEff.toStr() + "\n\tHGVS.c: " + hgvsDna + "\n\tHGVS.p: " + hgvsProt + "\n\tANN   : " + annField);
        }
        Assert.assertTrue("Effects do not match\n\tExpected : " + expectedEffs + "\n\tFound    : " + effs, effs.containsAll(expectedEffs));
        Assert.assertFalse("Effects should NOT be present: " + notExpectedEffs, effs.removeAll(notExpectedEffs));
        Assert.assertTrue("Effect impact '" + (Object)((Object)expectedImpact) + "' not found", impactOk);
        Assert.assertTrue("HGVS.c do not match\n\tExpected : " + expectedHgvsc + "\n\tFound    : " + hgvscs, hgvscs.containsAll(expectedHgvsc));
        Assert.assertTrue("HGVS.p do not match\n\tExpected : " + expectedHgvsp + "\n\tFound    : " + hgvsps, hgvsps.containsAll(expectedHgvsp));
        Assert.assertTrue("ANN fields do not match\n\tExpected : " + expectedAnns + "\n\tFound    : " + anns, anns.containsAll(expectedAnns));
    }

    public void init(boolean gene1NegativeStrand, boolean gene2NegativeStrand) {
        Exon[] exons;
        this.config = new Config("test");
        this.chr1Seq = "TGCTTGTCGATATTTGTATGAGGATTTGAGTACTACGCACTACTCAGTGCTGGGCAATCCCTTAGCTGTCGCGCCGCTTACCCTACTATTCAGGAGTAGGCCCTATCTCCACAGTGACTGTAGTACCAGCCATCTCTCTCGTTGCCGTCTGCGGTGCCGTCACACACGCTCCAGTCCCAGCTACGTTTCGCCAGGCTCAG";
        this.chr2Seq = "GCGATTGGTTGAATAAGCATAAGGTAGTTATCCGCCTGCACCTTGTTGAAAGATTGGACTTAATCCACCCCGTTAACAAAGGAATCGATCATGTTGCGCATATCGTCTAGGTTAATGGGATTTCACCGCTTACCCACTTAGCGGGCTGGAATGGGAACGGAGTGTCGACAGCACCTTATGGGGAGCTATATTCCCCCTAT";
        this.genome = new Genome("test");
        this.chr1 = new Chromosome(this.genome, 0, this.chr1Seq.length() - 1, "1");
        this.chr2 = new Chromosome(this.genome, 0, this.chr2Seq.length() - 1, "2");
        this.chr1.setSequence(this.chr1Seq);
        this.chr2.setSequence(this.chr2Seq);
        this.genome.add(this.chr1);
        this.genome.add(this.chr2);
        this.gene1 = new Gene(this.chr1, 10, 90, gene1NegativeStrand, "gene1", "gene1", BioType.protein_coding);
        this.gene2 = new Gene(this.chr2, 110, 190, gene2NegativeStrand, "gene2", "gene2", BioType.protein_coding);
        this.tr1 = new Transcript(this.gene1, this.gene1.getStart(), this.gene1.getEnd(), this.gene1.isStrandMinus(), "tr1");
        this.tr2 = new Transcript(this.gene2, this.gene2.getStart(), this.gene2.getEnd(), this.gene2.isStrandMinus(), "tr2");
        this.gene1.add(this.tr1);
        this.gene2.add(this.tr2);
        this.tr1.setProteinCoding(true);
        this.tr2.setProteinCoding(true);
        Exon e11 = new Exon(this.tr1, 10, 30, this.tr1.isStrandMinus(), "exon1", 0);
        Exon e12 = new Exon(this.tr1, 40, 90, this.tr1.isStrandMinus(), "exon2", 0);
        Exon e21 = new Exon(this.tr2, 110, 125, this.tr2.isStrandMinus(), "exon3", 0);
        Exon e22 = new Exon(this.tr2, 150, 190, this.tr2.isStrandMinus(), "exon4", 0);
        for (Exon e : exons = new Exon[]{e11, e12, e21, e22}) {
            String seq2 = e.getChromosome().getSequence().substring(e.getStart(), e.getEnd() + 1);
            if (e.isStrandMinus()) {
                seq2 = GprSeq.reverseWc(seq2);
            }
            e.setSequence(seq2);
            Transcript tr = (Transcript)e.getParent();
            tr.add(e);
            Cds cds = new Cds(tr, e.getStart(), e.getEnd(), e.isStrandMinus(), "");
            tr.add(cds);
        }
        this.tr1.rankExons();
        this.tr2.rankExons();
        if (this.verbose) {
            System.out.println("Transcripts:\n" + this.tr1 + "\n" + this.tr2);
        }
        this.snpEffectPredictor = new SnpEffectPredictor(this.genome);
        this.snpEffectPredictor.setUpDownStreamLength(0);
        this.snpEffectPredictor.add(this.gene1);
        this.snpEffectPredictor.add(this.gene2);
        this.snpEffectPredictor.buildForest();
        CytoBands cytoBands = this.genome.getCytoBands();
        cytoBands.add(new Marker(this.chr1, this.chr1.getStart(), 99, false, "p1"));
        cytoBands.add(new Marker(this.chr1, 100, this.chr1.getEnd(), false, "q1"));
        cytoBands.add(new Marker(this.chr2, this.chr2.getStart(), 99, false, "q2"));
        cytoBands.add(new Marker(this.chr2, 100, this.chr2.getEnd(), false, "p2"));
        cytoBands.build();
    }

    @Test
    public void test01_0() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:His6_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_0_nonFs() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 152, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:Gly7_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_1() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:Ile1_Met14)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_2() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:His6_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_3() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:Ile1_Met14)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_3_noFs() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 152, false, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:Ile1_Pro13)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_0() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:Val1_His6)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_1() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:Met14_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_1_nonFs() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 124, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr1_Ser7;tr2:Ter15_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_2() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:Val1_His6)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_2_nonFs() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 124, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:Val1_Ser5)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02_3() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, false);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Thr18_Ile24;tr2:Met14_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_0() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:His6_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_1() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:Ile1_Met14)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_1_nonFs() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 152, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:Ile1_Pro13)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_2() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:His6_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_2_nonFs() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 152, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:Gly7_Tyr19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03_3() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, false, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:Ile1_Met14)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_0() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:Val1_His6)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_0_nonFs() {
        Gpr.debug("Test");
        this.init(false, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 124, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:Val1_Ser5)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_1() {
        Gpr.debug("Test");
        this.init(false, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.21+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Tyr8_Phe24;tr2:Met14_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_2() {
        Gpr.debug("Test");
        this.init(true, false);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:Val1_His6)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_3() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 140, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:Met14_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04_3_nonFs() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 124, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"t(1;2)(p1;p2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;tr2:Ter15_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test05_1_one_gene() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 35, "N", "N", this.chr2, 50, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_HALF};
        EffectType[] notExpEffs = new EffectType[]{};
        String[] expHgvsc = new String[]{"t(1;2)(p1;q2)(c.51+5)"};
        String[] expHgvsp = new String[]{"t(1;2)(tr1:Glu1_Val17;)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test05_2_one_gene() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 135, "N", "N", this.chr2, 124, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_HALF};
        EffectType[] notExpEffs = new EffectType[]{};
        String[] expHgvsc = new String[]{"t(1;2)(q1;p2)(c.42-10)"};
        String[] expHgvsp = new String[]{"t(1;2)(;tr2:Ter15_Asn19)"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test06_no_gene() {
        Gpr.debug("Test");
        this.init(true, true);
        VariantBnd variant = new VariantBnd(this.chr1, 135, "N", "N", this.chr2, 50, true, true);
        EffectType[] expEffs = new EffectType[]{EffectType.FEATURE_FUSION};
        EffectType[] notExpEffs = new EffectType[]{};
        String[] expHgvsc = new String[]{"t(1;2)(q1;q2)(n.136)"};
        String[] expHgvsp = new String[]{""};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.LOW;
        this.checkEffects(variant, expEffs, notExpEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }
}

