/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Variant;
import org.snpeff.stats.ChrPosStats;
import org.snpeff.stats.CountByType;
import org.snpeff.stats.IntStats;
import org.snpeff.stats.SamplingStats;

public class VariantStats
implements SamplingStats<Variant> {
    public static final String CHANGE_SEPARATOR = "\t";
    static final char[] bases = new char[]{'A', 'C', 'G', 'T'};
    Genome genome;
    IntStats indelLen;
    HashMap<String, ChrPosStats> chrPosStatsbyName;
    long countVariants = 0L;
    long countNonVariants;
    long countNonEmptyId;
    CountByType countByChangeType;
    CountByType baseChangesCount;

    public VariantStats(Genome genome) {
        this.genome = genome;
        this.indelLen = new IntStats();
        this.chrPosStatsbyName = new HashMap();
        this.countByChangeType = new CountByType();
        this.baseChangesCount = new CountByType();
    }

    private String changeKey(String oldItem, String newItem) {
        return oldItem + CHANGE_SEPARATOR + newItem;
    }

    void chromoStats(Variant variant) {
        Chromosome chr;
        String chrName = variant.getChromosomeName();
        ChrPosStats chrPosStats = this.chrPosStatsbyName.get(chrName);
        if (chrPosStats == null && (chr = this.genome.getChromosome(chrName)) != null) {
            chrPosStats = new ChrPosStats(chrName, chr.size());
            this.chrPosStatsbyName.put(chrName, chrPosStats);
        }
        if (chrPosStats != null) {
            chrPosStats.sample(variant.getStart());
        }
    }

    public char[] getBases() {
        return bases;
    }

    public String getBasesChangesColor(String oldBase, String newBase) {
        return this.baseChangesCount.getColorHtml(this.changeKey(oldBase, newBase));
    }

    public long getBasesChangesCount(String oldBase, String newBase) {
        return this.baseChangesCount.get(this.changeKey(oldBase, newBase));
    }

    public Variant.VariantType[] getChangeType() {
        return Variant.VariantType.values();
    }

    public int getChangeTypeLength() {
        return Variant.VariantType.values().length;
    }

    public int getChromosomeLength(String chromoName) {
        Chromosome chr = this.genome.getChromosome(chromoName);
        if (chr != null) {
            return chr.size();
        }
        return 0;
    }

    public List<String> getChromosomeNamesEffective() {
        ArrayList<Chromosome> chrsEffective = new ArrayList<Chromosome>();
        for (String chrName : this.chrPosStatsbyName.keySet()) {
            chrsEffective.add(this.genome.getChromosome(chrName));
        }
        Collections.sort(chrsEffective);
        ArrayList<String> chrNames = new ArrayList<String>();
        for (Chromosome chr : chrsEffective) {
            chrNames.add(chr.getId());
        }
        return chrNames;
    }

    public ChrPosStats getChrPosStats(String chrName) {
        return this.chrPosStatsbyName.get(chrName);
    }

    public String getChrPosStatsChartUrl(String chrName) {
        return this.chrPosStatsbyName.get(chrName).toStringHistoPlot("Variants histogram: " + chrName, "Position", "Variants");
    }

    public long getCount() {
        return this.countVariants;
    }

    public CountByType getCountByChangeType() {
        return this.countByChangeType;
    }

    public int getCountByChromosome(String chromoName) {
        ChrPosStats chrStats = this.chrPosStatsbyName.get(chromoName);
        if (chrStats == null) {
            return 0;
        }
        return chrStats.getTotal();
    }

    public long getCountNonEmptyId() {
        return this.countNonEmptyId;
    }

    public long getCountNonVariants() {
        return this.countNonVariants;
    }

    public long getGenomeLen() {
        return this.genome.length();
    }

    public long getGenomeLenEffective() {
        long len = 0L;
        for (String chrName : this.chrPosStatsbyName.keySet()) {
            Chromosome ch = this.genome.getChromosome(chrName);
            len += (long)ch.size();
        }
        return len;
    }

    public IntStats getIndelLen() {
        return this.indelLen;
    }

    public String getIndelLenHistoUrl() {
        return this.indelLen.toStringPlot("Insertion deletion length histogram", "Length", true);
    }

    public double getKnownRatio() {
        double tot = this.countVariants;
        double known = this.countNonEmptyId;
        return tot > 0.0 ? known / tot : 0.0;
    }

    public long getRateOfChange() {
        return this.countVariants > 0L ? this.getGenomeLenEffective() / this.countVariants : 0L;
    }

    public int getRateOfChangeByChromosome(String chromoName) {
        int rate = 0;
        int len = this.getChromosomeLength(chromoName);
        int count2 = this.getCountByChromosome(chromoName);
        if (count2 > 0) {
            rate = len / count2;
        }
        return rate;
    }

    @Override
    public boolean hasData() {
        return this.countVariants != 0L;
    }

    void indelSample(Variant variant) {
        int len = (variant.isDel() ? -1 : 1) * (variant.getAlt().length() - 1);
        this.indelLen.sample(len);
    }

    @Override
    public void sample(Variant variant) {
        if (!variant.isVariant()) {
            ++this.countNonVariants;
            return;
        }
        ++this.countVariants;
        if (variant.getId() != null && !variant.getId().isEmpty()) {
            ++this.countNonEmptyId;
        }
        String variantType = variant.getVariantType().toString();
        this.countByChangeType.inc(variantType);
        if (variant.isVariant()) {
            if (variant.isSnp()) {
                this.snpSample(variant);
            } else if (variant.isInDel()) {
                this.indelSample(variant);
            }
        }
        this.chromoStats(variant);
    }

    void snpSample(Variant variant) {
        this.baseChangesCount.inc(this.changeKey(variant.getReference(), variant.getAlt()));
    }
}

