/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.gwasCatalog;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.collections.MultivalueHashMap;
import org.snpeff.interval.Chromosome;
import org.snpsift.gwasCatalog.GwasCatalogEntry;
import org.snpsift.gwasCatalog.GwasCatalogFileIterator;

public class GwasCatalog
implements Iterable<GwasCatalogEntry> {
    MultivalueHashMap<String, GwasCatalogEntry> gwasEntryByChrPos = new MultivalueHashMap();
    MultivalueHashMap<String, GwasCatalogEntry> gwasEntryByRs = new MultivalueHashMap();

    public GwasCatalog(String fileName) {
        this.load(fileName);
    }

    public List<GwasCatalogEntry> get(String key) {
        return (List)this.gwasEntryByChrPos.get(key);
    }

    public List<GwasCatalogEntry> get(String chrName, int pos) {
        return this.get(this.key(chrName, pos));
    }

    public List<GwasCatalogEntry> getByRs(String rs) {
        return (List)this.gwasEntryByRs.get(rs);
    }

    @Override
    public Iterator<GwasCatalogEntry> iterator() {
        LinkedList list2 = new LinkedList();
        for (String key : this.gwasEntryByChrPos.keySet()) {
            list2.addAll((Collection)this.gwasEntryByChrPos.get(key));
        }
        return list2.iterator();
    }

    public String key(GwasCatalogEntry ge) {
        return Chromosome.simpleName(ge.chrId) + ":" + (ge.chrPos - 1);
    }

    public String key(String chrName, int pos) {
        return Chromosome.simpleName(chrName) + ":" + pos;
    }

    protected void load(String fileName) {
        GwasCatalogFileIterator gfile = new GwasCatalogFileIterator(fileName);
        for (GwasCatalogEntry ge : gfile) {
            String key = this.key(ge);
            this.gwasEntryByChrPos.add(key, ge);
            for (String rs : ge.snps.split(",")) {
                if (rs.isEmpty() || rs.equals("NR")) continue;
                this.gwasEntryByRs.add(rs, ge);
            }
        }
    }
}

