/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.collect.Preconditions;

public final class LineStyle {
    public static final LineStyle THICK_LINE = LineStyle.newLineStyle(5, 1, 0);
    public static final LineStyle MEDIUM_LINE = LineStyle.newLineStyle(3, 1, 0);
    public static final LineStyle THIN_LINE = LineStyle.newLineStyle(1, 1, 0);
    public static final LineStyle THICK_DOTTED_LINE = LineStyle.newLineStyle(5, 5, 3);
    public static final LineStyle MEDIUM_DOTTED_LINE = LineStyle.newLineStyle(3, 5, 3);
    public static final LineStyle THIN_DOTTED_LINE = LineStyle.newLineStyle(1, 5, 3);
    private final int lineThickness;
    private final int lengthOfLineSegment;
    private final int lengthOfBlankSegment;

    LineStyle(int lineThickness, int lengthOfLineSegment, int lengthOfBlankSegment) {
        this.lineThickness = lineThickness;
        this.lengthOfLineSegment = lengthOfLineSegment;
        this.lengthOfBlankSegment = lengthOfBlankSegment;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public int getLengthOfLineSegment() {
        return this.lengthOfLineSegment;
    }

    public int getLengthOfBlankSegment() {
        return this.lengthOfBlankSegment;
    }

    public static LineStyle newLineStyle(int lineThickness, int lengthOfLineSegment, int lengthOfBlankSegment) {
        Preconditions.checkArgument(lineThickness > 0, "line thickness must be > 0: %s", lineThickness);
        Preconditions.checkArgument(lengthOfLineSegment >= 0, "length of line segment must be >= 0: %s", lengthOfLineSegment);
        Preconditions.checkArgument(lengthOfBlankSegment >= 0, "length of blank segment must be > 0: %s", lengthOfBlankSegment);
        return new LineStyle(lineThickness, lengthOfLineSegment, lengthOfBlankSegment);
    }
}

