/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.collect;

import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lists {
    private Lists() {
        throw new AssertionError();
    }

    public static <E> List<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> List<E> newArrayList() {
        return new LinkedList();
    }

    public static <E> ImmutableList<E> of(E ... a) {
        return new ImmutableList<E>(Arrays.asList(a));
    }

    public static <E> ImmutableList<E> copyOf(List<? extends E> list2) {
        Preconditions.checkContentsNotNull(list2, "list cannnot be null");
        List<E> l = Lists.newLinkedList();
        for (E e : list2) {
            l.add(e);
        }
        return new ImmutableList<E>(list2);
    }
}

