/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionResolver;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

final class SimpleConfigList
extends AbstractConfigValue
implements ConfigList {
    private static final long serialVersionUID = 1L;
    private final List<AbstractConfigValue> value;
    private final boolean resolved;

    SimpleConfigList(ConfigOrigin configOrigin, List<AbstractConfigValue> list2) {
        this(configOrigin, list2, ResolveStatus.fromValues(list2));
    }

    SimpleConfigList(ConfigOrigin configOrigin, List<AbstractConfigValue> list2, ResolveStatus resolveStatus) {
        super(configOrigin);
        this.value = list2;
        this.resolved = resolveStatus == ResolveStatus.RESOLVED;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.LIST;
    }

    @Override
    public List<Object> unwrapped() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AbstractConfigValue abstractConfigValue : this.value) {
            arrayList.add(abstractConfigValue.unwrapped());
        }
        return arrayList;
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean(this.resolved);
    }

    private SimpleConfigList modify(AbstractConfigValue.Modifier modifier, ResolveStatus resolveStatus) {
        ArrayList<AbstractConfigValue> arrayList = null;
        int n = 0;
        for (AbstractConfigValue abstractConfigValue : this.value) {
            AbstractConfigValue abstractConfigValue2 = modifier.modifyChild(abstractConfigValue);
            if (arrayList == null && abstractConfigValue2 != abstractConfigValue) {
                arrayList = new ArrayList<AbstractConfigValue>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.value.get(i));
                }
            }
            if (arrayList != null && abstractConfigValue2 != null) {
                arrayList.add(abstractConfigValue2);
            }
            ++n;
        }
        if (arrayList != null) {
            return new SimpleConfigList(this.origin(), arrayList, resolveStatus);
        }
        return this;
    }

    @Override
    SimpleConfigList resolveSubstitutions(final SubstitutionResolver substitutionResolver, final int n, final ConfigResolveOptions configResolveOptions) {
        if (this.resolved) {
            return this;
        }
        return this.modify(new AbstractConfigValue.Modifier(){

            @Override
            public AbstractConfigValue modifyChild(AbstractConfigValue abstractConfigValue) {
                return substitutionResolver.resolve(abstractConfigValue, n, configResolveOptions);
            }
        }, ResolveStatus.RESOLVED);
    }

    @Override
    SimpleConfigList relativized(final Path path) {
        return this.modify(new AbstractConfigValue.Modifier(){

            @Override
            public AbstractConfigValue modifyChild(AbstractConfigValue abstractConfigValue) {
                return abstractConfigValue.relativized(path);
            }
        }, this.resolveStatus());
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof SimpleConfigList;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SimpleConfigList) {
            return this.canEqual(object) && ((Object)this.value).equals(((SimpleConfigList)object).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.value).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, boolean bl) {
        if (this.value.isEmpty()) {
            stringBuilder.append("[]");
        } else {
            stringBuilder.append("[");
            if (bl) {
                stringBuilder.append('\n');
            }
            for (AbstractConfigValue abstractConfigValue : this.value) {
                if (bl) {
                    SimpleConfigList.indent(stringBuilder, n + 1);
                    stringBuilder.append("# ");
                    stringBuilder.append(abstractConfigValue.origin().description());
                    stringBuilder.append("\n");
                    for (String string2 : abstractConfigValue.origin().comments()) {
                        SimpleConfigList.indent(stringBuilder, n + 1);
                        stringBuilder.append("# ");
                        stringBuilder.append(string2);
                        stringBuilder.append("\n");
                    }
                    SimpleConfigList.indent(stringBuilder, n + 1);
                }
                abstractConfigValue.render(stringBuilder, n + 1, bl);
                stringBuilder.append(",");
                if (!bl) continue;
                stringBuilder.append('\n');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            if (bl) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                stringBuilder.append('\n');
                SimpleConfigList.indent(stringBuilder, n);
            }
            stringBuilder.append("]");
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.value.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.value.containsAll(collection);
    }

    @Override
    public AbstractConfigValue get(int n) {
        return this.value.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.value.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public Iterator<ConfigValue> iterator() {
        final Iterator<AbstractConfigValue> iterator2 = this.value.iterator();
        return new Iterator<ConfigValue>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public ConfigValue next() {
                return (ConfigValue)iterator2.next();
            }

            @Override
            public void remove() {
                throw SimpleConfigList.weAreImmutable("iterator().remove");
            }
        };
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.value.lastIndexOf(object);
    }

    private static ListIterator<ConfigValue> wrapListIterator(final ListIterator<AbstractConfigValue> listIterator) {
        return new ListIterator<ConfigValue>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasNext();
            }

            @Override
            public ConfigValue next() {
                return (ConfigValue)listIterator.next();
            }

            @Override
            public void remove() {
                throw SimpleConfigList.weAreImmutable("listIterator().remove");
            }

            @Override
            public void add(ConfigValue configValue) {
                throw SimpleConfigList.weAreImmutable("listIterator().add");
            }

            @Override
            public boolean hasPrevious() {
                return listIterator.hasPrevious();
            }

            @Override
            public int nextIndex() {
                return listIterator.nextIndex();
            }

            @Override
            public ConfigValue previous() {
                return (ConfigValue)listIterator.previous();
            }

            @Override
            public int previousIndex() {
                return listIterator.previousIndex();
            }

            @Override
            public void set(ConfigValue configValue) {
                throw SimpleConfigList.weAreImmutable("listIterator().set");
            }
        };
    }

    @Override
    public ListIterator<ConfigValue> listIterator() {
        return SimpleConfigList.wrapListIterator(this.value.listIterator());
    }

    @Override
    public ListIterator<ConfigValue> listIterator(int n) {
        return SimpleConfigList.wrapListIterator(this.value.listIterator(n));
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public List<ConfigValue> subList(int n, int n2) {
        ArrayList<ConfigValue> arrayList = new ArrayList<ConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.value.subList(n, n2)) {
            arrayList.add(abstractConfigValue);
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.value.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.value.toArray(TArray);
    }

    private static UnsupportedOperationException weAreImmutable(String string2) {
        return new UnsupportedOperationException("ConfigList is immutable, you can't call List.'" + string2 + "'");
    }

    @Override
    public boolean add(ConfigValue configValue) {
        throw SimpleConfigList.weAreImmutable("add");
    }

    @Override
    public void add(int n, ConfigValue configValue) {
        throw SimpleConfigList.weAreImmutable("add");
    }

    @Override
    public boolean addAll(Collection<? extends ConfigValue> collection) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public boolean addAll(int n, Collection<? extends ConfigValue> collection) {
        throw SimpleConfigList.weAreImmutable("addAll");
    }

    @Override
    public void clear() {
        throw SimpleConfigList.weAreImmutable("clear");
    }

    @Override
    public boolean remove(Object object) {
        throw SimpleConfigList.weAreImmutable("remove");
    }

    @Override
    public ConfigValue remove(int n) {
        throw SimpleConfigList.weAreImmutable("remove");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw SimpleConfigList.weAreImmutable("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw SimpleConfigList.weAreImmutable("retainAll");
    }

    @Override
    public ConfigValue set(int n, ConfigValue configValue) {
        throw SimpleConfigList.weAreImmutable("set");
    }

    @Override
    protected SimpleConfigList newCopy(boolean bl, ConfigOrigin configOrigin) {
        return new SimpleConfigList(configOrigin, this.value);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SimpleConfigList(this.origin(), new LinkedList<AbstractConfigValue>(this.value), this.resolveStatus());
    }
}

