/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigOrigin;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class SimpleConfigObject
extends AbstractConfigObject {
    private static final long serialVersionUID = 1L;
    private final Map<String, AbstractConfigValue> value;
    private final boolean resolved;
    private final boolean ignoresFallbacks;
    private static final String EMPTY_NAME = "empty config";
    private static final SimpleConfigObject emptyInstance = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple("empty config"));

    SimpleConfigObject(ConfigOrigin configOrigin, Map<String, AbstractConfigValue> map2, ResolveStatus resolveStatus, boolean bl) {
        super(configOrigin);
        if (map2 == null) {
            throw new ConfigException.BugOrBroken("creating config object with null map");
        }
        this.value = map2;
        this.resolved = resolveStatus == ResolveStatus.RESOLVED;
        this.ignoresFallbacks = bl;
    }

    SimpleConfigObject(ConfigOrigin configOrigin, Map<String, AbstractConfigValue> map2) {
        this(configOrigin, map2, ResolveStatus.fromValues(map2.values()), false);
    }

    @Override
    public SimpleConfigObject withOnlyKey(String string2) {
        return this.withOnlyPath(Path.newKey(string2));
    }

    @Override
    public SimpleConfigObject withoutKey(String string2) {
        return this.withoutPath(Path.newKey(string2));
    }

    @Override
    protected SimpleConfigObject withOnlyPathOrNull(Path path) {
        String string2 = path.first();
        Path path2 = path.remainder();
        AbstractConfigValue abstractConfigValue = this.value.get(string2);
        if (path2 != null) {
            abstractConfigValue = abstractConfigValue != null && abstractConfigValue instanceof AbstractConfigObject ? ((AbstractConfigObject)abstractConfigValue).withOnlyPathOrNull(path2) : null;
        }
        if (abstractConfigValue == null) {
            return null;
        }
        return new SimpleConfigObject(this.origin(), Collections.singletonMap(string2, abstractConfigValue), this.resolveStatus(), this.ignoresFallbacks);
    }

    @Override
    SimpleConfigObject withOnlyPath(Path path) {
        SimpleConfigObject simpleConfigObject = this.withOnlyPathOrNull(path);
        if (simpleConfigObject == null) {
            return new SimpleConfigObject(this.origin(), Collections.<String, AbstractConfigValue>emptyMap(), this.resolveStatus(), this.ignoresFallbacks);
        }
        return simpleConfigObject;
    }

    @Override
    SimpleConfigObject withoutPath(Path path) {
        String string2 = path.first();
        Path path2 = path.remainder();
        AbstractConfigValue abstractConfigValue = this.value.get(string2);
        if (abstractConfigValue != null && path2 != null && abstractConfigValue instanceof AbstractConfigObject) {
            abstractConfigValue = ((AbstractConfigObject)abstractConfigValue).withoutPath(path2);
            HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>(this.value);
            hashMap.put(string2, abstractConfigValue);
            return new SimpleConfigObject(this.origin(), hashMap, this.resolveStatus(), this.ignoresFallbacks);
        }
        if (path2 != null || abstractConfigValue == null) {
            return this;
        }
        HashMap<String, AbstractConfigValue> hashMap = new HashMap<String, AbstractConfigValue>(this.value.size() - 1);
        for (Map.Entry<String, AbstractConfigValue> entry : this.value.entrySet()) {
            if (entry.getKey().equals(string2)) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return new SimpleConfigObject(this.origin(), hashMap, this.resolveStatus(), this.ignoresFallbacks);
    }

    @Override
    protected AbstractConfigValue peek(String string2) {
        return this.value.get(string2);
    }

    @Override
    protected SimpleConfigObject newCopy(ResolveStatus resolveStatus, boolean bl, ConfigOrigin configOrigin) {
        return new SimpleConfigObject(configOrigin, this.value, resolveStatus, bl);
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean(this.resolved);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    public Map<String, Object> unwrapped() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, AbstractConfigValue> entry : this.value.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().unwrapped());
        }
        return hashMap;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.value.containsKey(object);
    }

    @Override
    public Set<String> keySet() {
        return this.value.keySet();
    }

    @Override
    public boolean containsValue(Object object) {
        return this.value.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        HashSet<Map.Entry<String, ConfigValue>> hashSet = new HashSet<Map.Entry<String, ConfigValue>>();
        for (Map.Entry<String, AbstractConfigValue> entry : this.value.entrySet()) {
            hashSet.add(new AbstractMap.SimpleImmutableEntry<String, AbstractConfigValue>(entry.getKey(), entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public Collection<ConfigValue> values() {
        return new HashSet<ConfigValue>(this.value.values());
    }

    static final SimpleConfigObject empty() {
        return emptyInstance;
    }

    static final SimpleConfigObject empty(ConfigOrigin configOrigin) {
        if (configOrigin == null) {
            return SimpleConfigObject.empty();
        }
        return new SimpleConfigObject(configOrigin, Collections.<String, AbstractConfigValue>emptyMap());
    }

    static final SimpleConfigObject emptyMissing(ConfigOrigin configOrigin) {
        return new SimpleConfigObject(SimpleConfigOrigin.newSimple(configOrigin.description() + " (not found)"), Collections.<String, AbstractConfigValue>emptyMap());
    }
}

