/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TLongCollection;
import gnu.trove.function.TObjectFunction;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TLongHash;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongObjectHashMap<V>
extends TLongHash
implements TLongObjectMap<V>,
Externalizable {
    static final long serialVersionUID = 1L;
    private final TLongObjectProcedure<V> PUT_ALL_PROC = new TLongObjectProcedure<V>(){

        @Override
        public boolean execute(long key, V value2) {
            TLongObjectHashMap.this.put(key, value2);
            return true;
        }
    };
    protected transient V[] _values;
    protected long no_entry_key;

    public TLongObjectHashMap() {
    }

    public TLongObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_key = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = Constants.DEFAULT_LONG_NO_ENTRY_VALUE;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor, long noEntryKey) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = noEntryKey;
    }

    public TLongObjectHashMap(TLongObjectMap<? extends V> map2) {
        this(map2.size(), 0.5f, map2.getNoEntryKey());
        this.putAll(map2);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        V[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldKeys[i];
            int index2 = this.insertKey(o);
            this._values[index2] = oldVals[i];
        }
    }

    @Override
    public long getNoEntryKey() {
        return this.no_entry_key;
    }

    @Override
    public boolean containsKey(long key) {
        return this.contains(key);
    }

    @Override
    public boolean containsValue(Object val) {
        byte[] states = this._states;
        V[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || null != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(long key) {
        int index2 = this.index(key);
        return index2 < 0 ? null : (V)this._values[index2];
    }

    @Override
    public V put(long key, V value2) {
        int index2 = this.insertKey(key);
        return this.doPut(value2, index2);
    }

    @Override
    public V putIfAbsent(long key, V value2) {
        int index2 = this.insertKey(key);
        if (index2 < 0) {
            return this._values[-index2 - 1];
        }
        return this.doPut(value2, index2);
    }

    private V doPut(V value2, int index2) {
        V previous = null;
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public V remove(long key) {
        V prev = null;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = null;
        super.removeAt(index2);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map2) {
        Set<Map.Entry<Long, V>> set = map2.entrySet();
        for (Map.Entry<Long, V> entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TLongObjectMap<? extends V> map2) {
        map2.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, this.no_entry_key);
        Arrays.fill(this._states, 0, this._states.length, (byte)0);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public TLongSet keySet() {
        return new KeyView();
    }

    @Override
    public long[] keys() {
        long[] keys = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    @Override
    public long[] keys(long[] dest) {
        if (dest.length < this._size) {
            dest = new long[this._size];
        }
        long[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            dest[j++] = k[i];
        }
        return dest;
    }

    @Override
    public Collection<V> valueCollection() {
        return new ValueView();
    }

    @Override
    public V[] values() {
        Object[] vals = new Object[this.size()];
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    @Override
    public V[] values(V[] dest) {
        if (dest.length < this._size) {
            dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), this._size);
        }
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            dest[j++] = v[i];
        }
        return dest;
    }

    @Override
    public TLongObjectIterator<V> iterator() {
        return new TLongObjectHashIterator(this);
    }

    @Override
    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure<? super V> procedure) {
        byte[] states = this._states;
        V[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TLongObjectProcedure<? super V> procedure) {
        byte[] states = this._states;
        long[] keys = this._set;
        V[] values2 = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TLongObjectProcedure<? super V> procedure) {
        boolean modified = false;
        byte[] states = this._states;
        long[] keys = this._set;
        V[] values2 = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public void transformValues(TObjectFunction<V, V> function) {
        byte[] states = this._states;
        V[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values2[i] = function.execute(values2[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TLongObjectMap)) {
            return false;
        }
        TLongObjectMap that = (TLongObjectMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        try {
            TLongObjectIterator<V> iter2 = this.iterator();
            while (iter2.hasNext()) {
                iter2.advance();
                long key = iter2.key();
                V value2 = iter2.value();
                if (!(value2 == null ? that.get(key) != null || !that.containsKey(key) : !value2.equals(that.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        V[] values2 = this._values;
        byte[] states = this._states;
        int i = values2.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            hashcode += HashFunctions.hash(this._set[i]) ^ (values2[i] == null ? 0 : values2[i].hashCode());
        }
        return hashcode;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeLong(this.no_entry_key);
        out.writeInt(this._size);
        int i = this._states.length;
        while (i-- > 0) {
            if (this._states[i] != 1) continue;
            out.writeLong(this._set[i]);
            out.writeObject(this._values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readLong();
        int size2 = in.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            long key = in.readLong();
            Object val = in.readObject();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TLongObjectProcedure<V>(){
            private boolean first = true;

            @Override
            public boolean execute(long key, Object value2) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(",");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value2);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TLongObjectHashIterator<V>
    extends THashPrimitiveIterator
    implements TLongObjectIterator<V> {
        private final TLongObjectHashMap<V> _map;

        public TLongObjectHashIterator(TLongObjectHashMap<V> map2) {
            super(map2);
            this._map = map2;
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public long key() {
            return this._map._set[this._index];
        }

        @Override
        public V value() {
            return this._map._values[this._index];
        }

        @Override
        public V setValue(V val) {
            V old = this.value();
            this._map._values[this._index] = val;
            return old;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapBackedView<E>
    extends AbstractSet<E>
    implements Set<E>,
    Iterable<E> {
        private MapBackedView() {
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object key) {
            return this.containsElement(key);
        }

        @Override
        public boolean remove(Object o) {
            return this.removeElement(o);
        }

        @Override
        public void clear() {
            TLongObjectHashMap.this.clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return TLongObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] result2 = new Object[this.size()];
            Iterator<E> e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result2[i] = e.next();
                ++i;
            }
            return result2;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size2 = this.size();
            if (a.length < size2) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
            }
            Iterator<E> it = this.iterator();
            T[] result2 = a;
            for (int i = 0; i < size2; ++i) {
                result2[i] = it.next();
            }
            if (a.length > size2) {
                a[size2] = null;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return TLongObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean changed = false;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueView
    extends MapBackedView<V> {
        protected ValueView() {
        }

        @Override
        public Iterator<V> iterator() {
            return new TLongObjectValueHashIterator(TLongObjectHashMap.this){

                @Override
                protected V objectAtIndex(int index2) {
                    return TLongObjectHashMap.this._values[index2];
                }
            };
        }

        @Override
        public boolean containsElement(V value2) {
            return TLongObjectHashMap.this.containsValue(value2);
        }

        @Override
        public boolean removeElement(V value2) {
            V[] values2 = TLongObjectHashMap.this._values;
            byte[] states = TLongObjectHashMap.this._states;
            int i = values2.length;
            while (i-- > 0) {
                if (states[i] != 1 || value2 != values2[i] && (null == values2[i] || !values2[i].equals(value2))) continue;
                TLongObjectHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TLongObjectValueHashIterator
        extends THashPrimitiveIterator
        implements Iterator<V> {
            protected final TLongObjectHashMap _map;

            public TLongObjectValueHashIterator(TLongObjectHashMap map2) {
                super(map2);
                this._map = map2;
            }

            protected V objectAtIndex(int index2) {
                byte[] states = TLongObjectHashMap.this._states;
                Object value2 = this._map._values[index2];
                if (states[index2] != 1) {
                    return null;
                }
                return value2;
            }

            @Override
            public V next() {
                this.moveToNextIndex();
                return this._map._values[this._index];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyView
    implements TLongSet {
        KeyView() {
        }

        @Override
        public long getNoEntryValue() {
            return TLongObjectHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TLongObjectHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return TLongObjectHashMap.this._size == 0;
        }

        @Override
        public boolean contains(long entry) {
            return TLongObjectHashMap.this.containsKey(entry);
        }

        @Override
        public TLongIterator iterator() {
            return new TLongHashIterator(TLongObjectHashMap.this);
        }

        @Override
        public long[] toArray() {
            return TLongObjectHashMap.this.keys();
        }

        @Override
        public long[] toArray(long[] dest) {
            return TLongObjectHashMap.this.keys(dest);
        }

        @Override
        public boolean add(long entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(long entry) {
            return null != TLongObjectHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (TLongObjectHashMap.this.containsKey((Long)element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TLongCollection collection) {
            if (collection == this) {
                return true;
            }
            TLongIterator iter2 = collection.iterator();
            while (iter2.hasNext()) {
                if (TLongObjectHashMap.this.containsKey(iter2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(long[] array) {
            for (long element : array) {
                if (TLongObjectHashMap.this.containsKey(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Long> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TLongCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TLongIterator iter2 = this.iterator();
            while (iter2.hasNext()) {
                if (collection.contains(iter2.next())) continue;
                iter2.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TLongCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TLongIterator iter2 = this.iterator();
            while (iter2.hasNext()) {
                if (collection.contains(iter2.next())) continue;
                iter2.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(long[] array) {
            boolean changed = false;
            Arrays.sort(array);
            long[] set = TLongObjectHashMap.this._set;
            byte[] states = TLongObjectHashMap.this._states;
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
                TLongObjectHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                long c;
                if (!(element instanceof Long) || !this.remove(c = ((Long)element).longValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TLongCollection collection) {
            if (collection == this) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TLongIterator iter2 = collection.iterator();
            while (iter2.hasNext()) {
                long element = iter2.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(long[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TLongObjectHashMap.this.clear();
        }

        @Override
        public boolean forEach(TLongProcedure procedure) {
            return TLongObjectHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TLongSet)) {
                return false;
            }
            TLongSet that = (TLongSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TLongObjectHashMap.this._states.length;
            while (i-- > 0) {
                if (TLongObjectHashMap.this._states[i] != 1 || that.contains(TLongObjectHashMap.this._set[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TLongObjectHashMap.this._states.length;
            while (i-- > 0) {
                if (TLongObjectHashMap.this._states[i] != 1) continue;
                hashcode += HashFunctions.hash(TLongObjectHashMap.this._set[i]);
            }
            return hashcode;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("{");
            boolean first = true;
            int i = TLongObjectHashMap.this._states.length;
            while (i-- > 0) {
                if (TLongObjectHashMap.this._states[i] != 1) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(TLongObjectHashMap.this._set[i]);
            }
            return buf.toString();
        }

        class TLongHashIterator
        extends THashPrimitiveIterator
        implements TLongIterator {
            private final TLongHash _hash;

            public TLongHashIterator(TLongHash hash2) {
                super(hash2);
                this._hash = hash2;
            }

            public long next() {
                this.moveToNextIndex();
                return this._hash._set[this._index];
            }
        }
    }
}

