/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import org.testng.Assert;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord firstEnd, SAMRecord secondEnd) {
        Assert.assertEquals((String)firstEnd.getReadName(), (String)secondEnd.getReadName());
        Assert.assertTrue((boolean)firstEnd.getFirstOfPairFlag());
        Assert.assertTrue((boolean)secondEnd.getSecondOfPairFlag());
        Assert.assertFalse((boolean)secondEnd.getFirstOfPairFlag());
        Assert.assertFalse((boolean)firstEnd.getSecondOfPairFlag());
        if (!firstEnd.getReadUnmappedFlag() && !secondEnd.getReadUnmappedFlag()) {
            Assert.assertNotSame((Object)firstEnd.getReadNegativeStrandFlag(), (Object)secondEnd.getReadNegativeStrandFlag());
        }
    }

    public void assertReadValid(SAMRecord read2) {
        Assert.assertEquals((int)read2.getReadBases().length, (int)read2.getBaseQualities().length);
        if (read2.getReferenceName().equals("*")) {
            Assert.assertEquals((int)read2.getAlignmentStart(), (int)0);
            Assert.assertTrue((boolean)read2.getReadUnmappedFlag());
        } else {
            Assert.assertNotSame((Object)read2.getAlignmentStart(), (Object)0);
        }
        if (read2.getReadUnmappedFlag()) {
            Assert.assertEquals((int)read2.getMappingQuality(), (int)0);
            Assert.assertEquals((int)read2.getCigar().getCigarElements().size(), (int)0);
        } else {
            Assert.assertNotSame(read2.getCigar().getCigarElements(), (Object)0);
        }
        if (read2.getReadPairedFlag()) {
            if (read2.getMateReferenceName().equals("*")) {
                Assert.assertEquals((int)read2.getMateAlignmentStart(), (int)0);
                Assert.assertTrue((boolean)read2.getMateUnmappedFlag());
            } else {
                Assert.assertNotSame((Object)read2.getMateAlignmentStart(), (Object)0);
            }
            if (read2.getReadUnmappedFlag() || read2.getMateUnmappedFlag() || !read2.getReferenceName().equals(read2.getMateReferenceName())) {
                Assert.assertEquals((int)read2.getInferredInsertSize(), (int)0);
            } else {
                Assert.assertNotSame((Object)read2.getInferredInsertSize(), (Object)0);
            }
            if (!read2.getReadUnmappedFlag() && !read2.getMateUnmappedFlag()) {
                Assert.assertNotSame((Object)read2.getReadNegativeStrandFlag(), (Object)read2.getMateNegativeStrandFlag(), (String)read2.getReadName());
            }
        } else {
            Assert.assertEquals((int)read2.getInferredInsertSize(), (int)0);
        }
    }
}

