/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ConcurrentSoftHashMap;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.OverflowException;
import org.apfloat.ShutdownMap;
import org.apfloat.spi.Util;

public class ApfloatMath {
    private static final Map<Integer, Apfloat> SHUTDOWN_MAP = new ShutdownMap<Integer, Apfloat>();
    private static ConcurrentMap<Integer, Integer> radixPiKeys = new ConcurrentHashMap<Integer, Integer>();
    private static Map<Integer, Apfloat> radixPi = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, PiCalculator> radixPiCalculator = new Hashtable<Integer, PiCalculator>();
    private static Map<Integer, Apfloat> radixPiT = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiQ = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiP = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiInverseRoot = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Long> radixPiTerms = new Hashtable<Integer, Long>();
    private static ConcurrentMap<Integer, Integer> radixLogKeys = new ConcurrentHashMap<Integer, Integer>();
    private static Map<Integer, Apfloat> radixLog = new ConcurrentHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixLogPi = new ConcurrentHashMap<Integer, Apfloat>();

    private ApfloatMath() {
    }

    public static Apfloat pow(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x2.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        }
        if (n < 0L) {
            x2 = ApfloatMath.inverseRoot(x2, 1L);
            n = -n;
        }
        long precision = x2.precision();
        x2 = ApfloatHelper.extendPrecision(x2);
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>>= 1;
        }
        Apfloat r = x2;
        while ((n >>>= 1) > 0L) {
            x2 = x2.multiply(x2);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(x2);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return r.precision(precision);
    }

    public static Apfloat sqrt(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.root(x2, 2L);
    }

    public static Apfloat cbrt(Apfloat x2) throws ApfloatRuntimeException {
        return ApfloatMath.root(x2, 3L);
    }

    public static Apfloat root(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            throw new ArithmeticException("Zeroth root");
        }
        if (x2.signum() == 0) {
            return Apfloat.ZERO;
        }
        if (n == 1L) {
            return x2;
        }
        if (n == Long.MIN_VALUE) {
            return ApfloatMath.sqrt(ApfloatMath.inverseRoot(x2, n / -2L));
        }
        if (n < 0L) {
            return ApfloatMath.inverseRoot(x2, -n);
        }
        if (n == 2L) {
            return x2.multiply(ApfloatMath.inverseRoot(x2, 2L));
        }
        if (n == 3L) {
            Apfloat y = x2.multiply(x2);
            return x2.multiply(ApfloatMath.inverseRoot(y, 3L));
        }
        Apfloat y = ApfloatMath.inverseRoot(x2, n);
        return ApfloatMath.inverseRoot(y, 1L);
    }

    public static Apfloat inverseRoot(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(x2, n, x2.precision());
    }

    public static Apfloat inverseRoot(Apfloat x2, long n, long targetPrecision) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(x2, n, targetPrecision, null);
    }

    public static Apfloat inverseRoot(Apfloat x2, long n, long targetPrecision, Apfloat initialGuess) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(x2, n, targetPrecision, initialGuess, initialGuess == null ? 0L : initialGuess.precision());
    }

    public static Apfloat inverseRoot(Apfloat x2, long n, long targetPrecision, Apfloat initialGuess, long initialPrecision) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        long precision;
        Apfloat result2;
        if (x2.signum() == 0) {
            throw new ArithmeticException("Inverse root of zero");
        }
        if (n == 0L) {
            throw new ArithmeticException("Inverse zeroth root");
        }
        if ((n & 1L) == 0L && x2.signum() < 0) {
            throw new ArithmeticException("Even root of negative number; result would be complex");
        }
        if (targetPrecision <= 0L) {
            throw new IllegalArgumentException("Target precision " + targetPrecision + " is not positive");
        }
        if (x2.equals(Apfloat.ONE)) {
            return x2.precision(targetPrecision);
        }
        if (targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate inverse root to infinite precision");
        }
        if (n == Long.MIN_VALUE) {
            Apfloat y = ApfloatMath.inverseRoot(x2, n / -2L);
            return ApfloatMath.inverseRoot(y, 2L);
        }
        if (n < 0L) {
            Apfloat y = ApfloatMath.inverseRoot(x2, -n);
            return ApfloatMath.inverseRoot(y, 1L);
        }
        long doublePrecision = ApfloatHelper.getDoublePrecision(x2.radix());
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat divisor = new Apfloat(n, Long.MAX_VALUE, x2.radix());
        if (initialGuess == null || initialPrecision < doublePrecision) {
            long scaleQuot = x2.scale() / n;
            long scaleRem = x2.scale() - scaleQuot * n;
            result2 = x2.precision(doublePrecision);
            result2 = ApfloatMath.scale(result2, -result2.scale());
            precision = doublePrecision;
            result2 = new Apfloat((double)result2.signum() * Math.pow(Math.abs(result2.doubleValue()), -1.0 / (double)n) * Math.pow(x2.radix(), (double)(-scaleRem) / (double)n), precision, x2.radix());
            result2 = ApfloatMath.scale(result2, -scaleQuot);
        } else {
            result2 = initialGuess;
            precision = initialPrecision;
        }
        int iterations = 0;
        for (long maxPrec = precision; maxPrec < targetPrecision; maxPrec <<= 1) {
            ++iterations;
        }
        int precisingIteration = iterations;
        long minPrec = precision;
        while (precisingIteration > 0 && minPrec - 20L << precisingIteration < targetPrecision) {
            --precisingIteration;
            minPrec <<= 1;
        }
        x2 = ApfloatHelper.extendPrecision(x2);
        while (iterations-- > 0) {
            result2 = result2.precision(Math.min(precision *= 2L, targetPrecision));
            Apfloat t2 = ApfloatMath.pow(result2, n);
            t2 = ApfloatMath.lastIterationExtendPrecision(iterations, precisingIteration, t2);
            t2 = one.subtract(x2.multiply(t2));
            if (iterations < precisingIteration) {
                t2 = t2.precision(precision / 2L);
            }
            result2 = ApfloatMath.lastIterationExtendPrecision(iterations, precisingIteration, result2);
            result2 = result2.add(result2.multiply(t2).divide(divisor));
            if (iterations != precisingIteration) continue;
            t2 = ApfloatMath.pow(result2, n);
            t2 = ApfloatMath.lastIterationExtendPrecision(iterations, -1, t2);
            result2 = ApfloatMath.lastIterationExtendPrecision(iterations, -1, result2);
            result2 = result2.add(result2.multiply(one.subtract(x2.multiply(t2))).divide(divisor));
        }
        return result2.precision(targetPrecision);
    }

    public static Apint floor(Apfloat x2) throws ApfloatRuntimeException {
        return x2.floor();
    }

    public static Apint ceil(Apfloat x2) throws ApfloatRuntimeException {
        return x2.ceil();
    }

    public static Apint truncate(Apfloat x2) throws ApfloatRuntimeException {
        return x2.truncate();
    }

    @Deprecated
    public static Apfloat negate(Apfloat x2) throws ApfloatRuntimeException {
        return x2.negate();
    }

    public static Apfloat abs(Apfloat x2) throws ApfloatRuntimeException {
        if (x2.signum() >= 0) {
            return x2;
        }
        return x2.negate();
    }

    public static Apfloat copySign(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        if (y.signum() == 0) {
            return y;
        }
        if (x2.signum() != y.signum()) {
            return x2.negate();
        }
        return x2;
    }

    public static Apfloat scale(Apfloat x2, long scale) throws ApfloatRuntimeException {
        Apfloat result2;
        if (scale == 0L || x2.signum() == 0) {
            return x2;
        }
        Apfloat radix = new Apfloat(x2.radix(), Long.MAX_VALUE, x2.radix());
        if ((Math.abs(scale) & 0xC000000000000000L) != 0L) {
            Apfloat scaler1 = ApfloatMath.pow(radix, Math.abs(scale) >>> 1);
            Apfloat scaler2 = (scale & 1L) == 0L ? scaler1 : scaler1.multiply(radix);
            result2 = scale >= 0L ? x2.multiply(scaler1).multiply(scaler2) : x2.divide(scaler1).divide(scaler2);
        } else if (x2.radix() <= 14) {
            Apfloat scaler = new Apfloat("1e" + scale, Long.MAX_VALUE, x2.radix());
            result2 = x2.multiply(scaler);
        } else {
            Apfloat scaler = ApfloatMath.pow(radix, Math.abs(scale));
            result2 = scale >= 0L ? x2.multiply(scaler) : x2.divide(scaler);
        }
        return result2;
    }

    public static Apfloat[] modf(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat[] result2;
        result2 = new Apfloat[]{ApfloatMath.floor(x2), x2.subtract(result2[0])};
        return result2;
    }

    public static Apfloat fmod(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        Apfloat b;
        if (y.signum() == 0) {
            return y;
        }
        if (x2.signum() == 0) {
            return x2;
        }
        Apfloat a = ApfloatMath.abs(x2);
        if (a.compareTo(b = ApfloatMath.abs(y)) < 0) {
            return x2;
        }
        if (x2.precision() <= x2.scale() - y.scale()) {
            return Apfloat.ZERO;
        }
        long precision = x2.scale() - y.scale() + 20L;
        Apfloat tx = x2.precision(precision);
        Apfloat ty = y.precision(precision);
        Apfloat t2 = tx.divide(ty).truncate();
        precision = Math.min(Util.ifFinite(y.precision(), y.precision() + x2.scale() - y.scale()), x2.precision());
        tx = x2.precision(precision);
        ty = y.precision(precision);
        a = ApfloatMath.abs(tx).subtract(ApfloatMath.abs(t2.multiply(ty)));
        if (a.compareTo(b = ApfloatMath.abs(ty)) >= 0) {
            a = a.subtract(b);
        } else if (a.signum() < 0) {
            a = a.add(b);
        }
        t2 = ApfloatMath.copySign(a, x2);
        return t2;
    }

    public static Apfloat multiplyAdd(Apfloat a, Apfloat b, Apfloat c, Apfloat d) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAddOrSubtract(a, b, c, d, false);
    }

    public static Apfloat multiplySubtract(Apfloat a, Apfloat b, Apfloat c, Apfloat d) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAddOrSubtract(a, b, c, d, true);
    }

    private static Apfloat multiplyAddOrSubtract(Apfloat a, Apfloat b, Apfloat c, Apfloat d, boolean subtract) throws ApfloatRuntimeException {
        Apfloat cd;
        Apfloat ab;
        long[] precisions = ApfloatHelper.getMatchingPrecisions(a, b, c, d);
        if (precisions[0] == 0L) {
            ab = Apfloat.ZERO;
        } else {
            a = a.precision(precisions[0]);
            b = b.precision(precisions[0]);
            ab = a.multiply(b);
        }
        if (precisions[1] == 0L) {
            cd = Apfloat.ZERO;
        } else {
            c = c.precision(precisions[1]);
            d = d.precision(precisions[1]);
            cd = c.multiply(d);
        }
        Apfloat result2 = subtract ? ab.subtract(cd) : ab.add(cd);
        return result2.signum() == 0 ? result2 : result2.precision(precisions[2]);
    }

    public static Apfloat agm(Apfloat a, Apfloat b) throws ApfloatRuntimeException {
        Apfloat t2;
        if (a.signum() == 0 || b.signum() == 0) {
            return Apfloat.ZERO;
        }
        long workingPrecision = Math.min(a.precision(), b.precision());
        long targetPrecision = Math.max(a.precision(), b.precision());
        if (workingPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate agm to infinite precision");
        }
        workingPrecision = ApfloatHelper.extendPrecision(workingPrecision);
        a = ApfloatHelper.ensurePrecision(a, workingPrecision);
        b = ApfloatHelper.ensurePrecision(b, workingPrecision);
        long precision = 0L;
        long halfWorkingPrecision = (workingPrecision + 1L) / 2L;
        long CONVERGING = 1000L;
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, a.radix());
        while (precision < 1000L && precision < halfWorkingPrecision) {
            t2 = a.add(b).divide(two);
            b = ApfloatMath.sqrt(a.multiply(b));
            a = t2;
            a = ApfloatHelper.ensurePrecision(a, workingPrecision);
            b = ApfloatHelper.ensurePrecision(b, workingPrecision);
            precision = a.equalDigits(b);
        }
        while (precision <= halfWorkingPrecision) {
            t2 = a.add(b).divide(two);
            b = ApfloatMath.sqrt(a.multiply(b));
            a = t2;
            a = ApfloatHelper.ensurePrecision(a, workingPrecision);
            b = ApfloatHelper.ensurePrecision(b, workingPrecision);
            precision *= 2L;
        }
        return a.add(b).divide(two).precision(targetPrecision);
    }

    public static Apfloat pi(long precision) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int radix = ctx.getDefaultRadix();
        return ApfloatMath.pi(precision, radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Apfloat pi(long precision, int radix) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        Apfloat pi;
        Integer radixKey;
        if (precision <= 0L) {
            throw new IllegalArgumentException("Precision " + precision + " is not positive");
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate pi to infinite precision");
        }
        Integer n = radixKey = ApfloatMath.getRadixPiKey(new Integer(radix));
        synchronized (n) {
            pi = radixPi.get(radixKey);
            pi = pi == null || pi.precision() < precision ? ApfloatMath.calculatePi(precision, radixKey) : pi.precision(precision);
        }
        return pi;
    }

    private static Integer getRadixPiKey(Integer radix) {
        Integer radixKey = radixPiKeys.putIfAbsent(radix, radix);
        if (radixKey == null) {
            radixKey = radix;
        }
        return radixKey;
    }

    private static Apfloat calculatePi(long precision, Integer radixKey) throws ApfloatRuntimeException {
        int radix = radixKey;
        PiCalculator piCalculator = radixPiCalculator.get(radixKey);
        if (piCalculator == null) {
            piCalculator = new PiCalculator(radix);
            radixPiCalculator.put(radixKey, piCalculator);
        }
        ApfloatHolder RT = new ApfloatHolder();
        ApfloatHolder RQ = new ApfloatHolder();
        ApfloatHolder RP = new ApfloatHolder();
        long neededTerms = (long)((double)precision * Math.log(radix) / 32.65445004177);
        long workingPrecision = ApfloatHelper.extendPrecision(precision);
        Long terms = radixPiTerms.get(radixKey);
        Apfloat LT = radixPiT.get(radixKey);
        Apfloat LQ = radixPiQ.get(radixKey);
        Apfloat LP = radixPiP.get(radixKey);
        Apfloat inverseRoot = radixPiInverseRoot.get(radixKey);
        if (terms != null && LT != null && LQ != null && LP != null && inverseRoot != null) {
            long currentTerms = terms;
            if (currentTerms != neededTerms + 1L) {
                piCalculator.r(currentTerms, neededTerms + 1L, RT, RQ, RP);
                LT = RQ.getApfloat().multiply(LT).add(LP.multiply(RT.getApfloat()));
                LQ = LQ.multiply(RQ.getApfloat());
                LP = LP.multiply(RP.getApfloat());
            }
            inverseRoot = ApfloatMath.inverseRoot(new Apfloat(640320L, workingPrecision, radix), 2L, workingPrecision, inverseRoot);
        } else {
            piCalculator.r(0L, neededTerms + 1L, RT, RQ, RP);
            LT = RT.getApfloat();
            LQ = RQ.getApfloat();
            LP = RP.getApfloat();
            inverseRoot = ApfloatMath.inverseRoot(new Apfloat(640320L, workingPrecision, radix), 2L);
        }
        Apfloat pi = ApfloatMath.inverseRoot(inverseRoot.multiply(LT), 1L).multiply(new Apfloat(53360L, Long.MAX_VALUE, radix)).multiply(LQ);
        inverseRoot = inverseRoot.precision(precision);
        pi = pi.precision(precision);
        radixPiT.put(radixKey, LT);
        radixPiQ.put(radixKey, LQ);
        radixPiP.put(radixKey, LP);
        radixPiInverseRoot.put(radixKey, inverseRoot);
        radixPiTerms.put(radixKey, neededTerms + 1L);
        radixPi.put(radixKey, pi);
        return pi;
    }

    public static Apfloat log(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.log(x2, true);
    }

    public static Apfloat log(Apfloat x2, Apfloat b) throws ArithmeticException, ApfloatRuntimeException {
        long targetPrecision = Math.min(x2.precision(), b.precision());
        x2 = x2.precision(targetPrecision);
        b = b.precision(targetPrecision);
        return ApfloatMath.log(x2, false).divide(ApfloatMath.log(b, false));
    }

    private static Apfloat log(Apfloat x2, boolean multiplyByPi) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat radixPower;
        if (x2.signum() <= 0) {
            throw new ArithmeticException("Logarithm of " + (x2.signum() == 0 ? "zero" : "negative number; result would be complex"));
        }
        if (x2.equals(Apfloat.ONE)) {
            return Apfloat.ZERO;
        }
        long targetPrecision = x2.precision();
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        long finalPrecision = Util.ifFinite(targetPrecision, targetPrecision - one.equalDigits(x2));
        long originalScale = x2.scale();
        x2 = ApfloatMath.scale(x2, -originalScale);
        if (originalScale == 0L) {
            radixPower = Apfloat.ZERO;
        } else {
            Apfloat logRadix = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(targetPrecision, x2.radix(), multiplyByPi));
            radixPower = new Apfloat(originalScale, Long.MAX_VALUE, x2.radix()).multiply(logRadix);
        }
        return ApfloatHelper.extendPrecision(ApfloatMath.rawLog(x2, multiplyByPi)).add(radixPower).precision(finalPrecision);
    }

    private static Apfloat rawLog(Apfloat x2, boolean multiplyByPi) throws ApfloatRuntimeException {
        assert (x2.signum() > 0);
        long targetPrecision = x2.precision();
        if (targetPrecision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate logarithm to infinite precision");
        }
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        int EXTRA_PRECISION = 25;
        long workingPrecision = ApfloatHelper.extendPrecision(targetPrecision);
        long n = targetPrecision / 2L + 25L;
        x2 = ApfloatHelper.extendPrecision(x2, 25L);
        Apfloat e = one.precision(workingPrecision);
        e = ApfloatMath.scale(e, -n);
        x2 = ApfloatMath.scale(x2, -n);
        Apfloat agme = ApfloatHelper.extendPrecision(ApfloatMath.agm(one, e));
        Apfloat agmex = ApfloatHelper.extendPrecision(ApfloatMath.agm(one, x2));
        Apfloat log2 = agmex.subtract(agme).precision(workingPrecision);
        if (multiplyByPi) {
            Apfloat pi = ApfloatHelper.extendPrecision(ApfloatMath.pi(targetPrecision, x2.radix()));
            log2 = pi.multiply(log2);
        }
        log2 = log2.divide(new Apfloat(2L, Long.MAX_VALUE, x2.radix()).multiply(agme).multiply(agmex));
        return log2.precision(targetPrecision);
    }

    private static Integer getRadixLogKey(Integer radix) {
        Integer radixKey = radixLogKeys.putIfAbsent(radix, radix);
        if (radixKey == null) {
            radixKey = radix;
        }
        return radixKey;
    }

    public static Apfloat logRadix(long precision, int radix) throws ApfloatRuntimeException {
        return ApfloatMath.logRadix(precision, radix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Apfloat logRadix(long precision, int radix, boolean multiplyByPi) throws ApfloatRuntimeException {
        Apfloat logRadix;
        Integer radixKey;
        Integer n = radixKey = ApfloatMath.getRadixLogKey(new Integer(radix));
        synchronized (n) {
            Map<Integer, Apfloat> cache = multiplyByPi ? radixLogPi : radixLog;
            logRadix = cache.get(radixKey);
            if (logRadix == null || logRadix.precision() < precision) {
                if (multiplyByPi) {
                    logRadix = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(precision, radix, false));
                    Apfloat pi = ApfloatHelper.extendPrecision(ApfloatMath.pi(precision, radix));
                    logRadix = logRadix.multiply(pi).precision(precision);
                } else {
                    Apfloat f2 = new Apfloat("0.1", precision, radix);
                    logRadix = ApfloatMath.rawLog(f2, multiplyByPi).negate();
                }
                cache.put(radixKey, logRadix);
            } else {
                logRadix = logRadix.precision(precision);
            }
        }
        return logRadix;
    }

    public static Apfloat exp(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat result2;
        long precision;
        int radix = x2.radix();
        if (x2.signum() == 0) {
            return new Apfloat(1L, Long.MAX_VALUE, radix);
        }
        long targetPrecision = x2.precision();
        long doublePrecision = ApfloatHelper.getDoublePrecision(radix);
        if ((targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + Math.max(1L - x2.scale(), 0L))) == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate exponent to infinite precision");
        }
        if (x2.compareTo(new Apfloat(9.223372036854776E18 * Math.log(radix), doublePrecision, radix)) >= 0) {
            throw new OverflowException("Overflow");
        }
        if (x2.scale() <= -4611686018427387884L) {
            return new Apfloat(1L, Long.MAX_VALUE, radix).add(x2).precision(Long.MAX_VALUE);
        }
        if (x2.scale() < -doublePrecision / 2L) {
            precision = -2L * x2.scale();
            result2 = new Apfloat(1L, precision, radix).add(x2);
        } else {
            double doubleValue = x2.doubleValue() / Math.log(radix);
            double integerPart = Math.floor(doubleValue);
            double fractionalPart = doubleValue - integerPart;
            result2 = new Apfloat(Math.pow(radix, fractionalPart), doublePrecision, radix);
            result2 = ApfloatMath.scale(result2, (long)integerPart);
            int integerPartDigits = integerPart > 0.0 ? (int)Math.floor(Math.log(integerPart + 0.5) / Math.log(radix)) : 0;
            precision = Math.max(1L, doublePrecision - (long)integerPartDigits);
        }
        int iterations = 0;
        for (long maxPrec = precision; maxPrec < targetPrecision; maxPrec <<= 1) {
            ++iterations;
        }
        int precisingIteration = iterations;
        long minPrec = precision;
        while (precisingIteration > 0 && minPrec - 20L << precisingIteration < targetPrecision) {
            --precisingIteration;
            minPrec <<= 1;
        }
        if (iterations > 0) {
            ApfloatMath.logRadix(targetPrecision, radix);
        }
        x2 = ApfloatHelper.extendPrecision(x2);
        while (iterations-- > 0) {
            result2 = result2.precision(Math.min(precision *= 2L, targetPrecision));
            Apfloat t2 = ApfloatMath.log(result2);
            t2 = ApfloatMath.lastIterationExtendPrecision(iterations, precisingIteration, t2);
            t2 = x2.subtract(t2);
            if (iterations < precisingIteration) {
                t2 = t2.precision(precision / 2L);
            }
            result2 = ApfloatMath.lastIterationExtendPrecision(iterations, precisingIteration, result2);
            result2 = result2.add(result2.multiply(t2));
            if (iterations != precisingIteration) continue;
            t2 = ApfloatMath.log(result2);
            t2 = ApfloatMath.lastIterationExtendPrecision(iterations, -1, t2);
            result2 = ApfloatMath.lastIterationExtendPrecision(iterations, -1, result2);
            result2 = result2.add(result2.multiply(x2.subtract(t2)));
        }
        return result2.precision(targetPrecision);
    }

    public static Apfloat pow(Apfloat x2, Apfloat y) throws ArithmeticException, ApfloatRuntimeException {
        long targetPrecision = Math.min(x2.precision(), y.precision());
        Apfloat result2 = ApfloatHelper.checkPow(x2, y, targetPrecision);
        if (result2 != null) {
            return result2;
        }
        ApfloatMath.logRadix(targetPrecision, x2.radix());
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        targetPrecision = Util.ifFinite(targetPrecision, targetPrecision + one.equalDigits(x2));
        x2 = x2.precision(Math.min(x2.precision(), targetPrecision));
        result2 = ApfloatMath.log(x2);
        long intermediatePrecision = Math.min(y.precision(), result2.precision());
        result2 = ApfloatHelper.extendPrecision(result2);
        result2 = ApfloatHelper.extendPrecision(y).multiply(result2);
        result2 = ApfloatMath.exp(result2.precision(intermediatePrecision));
        return result2;
    }

    public static Apfloat acosh(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        return ApfloatMath.log(x2.add(ApfloatMath.sqrt(x2.multiply(x2).subtract(one))));
    }

    public static Apfloat asinh(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        if (x2.signum() >= 0) {
            return ApfloatMath.log(ApfloatMath.sqrt(x2.multiply(x2).add(one)).add(x2));
        }
        return ApfloatMath.log(ApfloatMath.sqrt(x2.multiply(x2).add(one)).subtract(x2)).negate();
    }

    public static Apfloat atanh(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
        return ApfloatMath.log(one.add(x2).divide(one.subtract(x2))).divide(two);
    }

    public static Apfloat cosh(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat y = ApfloatMath.exp(x2);
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
        return y.add(one.divide(y)).divide(two);
    }

    public static Apfloat sinh(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat y = ApfloatMath.exp(x2);
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
        return y.subtract(one.divide(y)).divide(two);
    }

    public static Apfloat tanh(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
        Apfloat y = ApfloatMath.exp(two.multiply(ApfloatMath.abs(x2)));
        y = y.subtract(one).divide(y.add(one));
        return x2.signum() < 0 ? y.negate() : y;
    }

    public static Apfloat acos(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        return ApcomplexMath.log(x2.add(i.multiply(ApfloatMath.sqrt(one.subtract(x2.multiply(x2)))))).imag();
    }

    public static Apfloat asin(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        return ApcomplexMath.log(ApfloatMath.sqrt(one.subtract(x2.multiply(x2))).subtract(i.multiply(x2))).imag().negate();
    }

    public static Apfloat atan(Apfloat x2) throws ApfloatRuntimeException {
        Apfloat one = new Apfloat(1L, Long.MAX_VALUE, x2.radix());
        Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
        Apcomplex i = new Apcomplex(Apfloat.ZERO, one);
        return ApcomplexMath.log(i.subtract(x2).divide(i.add(x2))).imag().divide(two);
    }

    public static Apfloat atan2(Apfloat x2, Apfloat y) throws ArithmeticException, ApfloatRuntimeException {
        if (y.signum() == 0) {
            if (x2.signum() == 0) {
                throw new ArithmeticException("Angle of (0, 0)");
            }
            Apfloat pi = ApfloatMath.pi(x2.precision(), x2.radix());
            Apfloat two = new Apfloat(2L, Long.MAX_VALUE, x2.radix());
            return new Apfloat(x2.signum(), Long.MAX_VALUE, x2.radix()).multiply(pi).divide(two);
        }
        if (x2.signum() == 0) {
            if (y.signum() > 0) {
                return Apfloat.ZERO;
            }
            return ApfloatMath.pi(y.precision(), y.radix());
        }
        if (Math.min(x2.precision(), y.precision()) == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate atan2 to infinite precision");
        }
        long maxScale = Math.max(x2.scale(), y.scale());
        x2 = ApfloatMath.scale(x2, -maxScale);
        y = ApfloatMath.scale(y, -maxScale);
        return ApcomplexMath.log(new Apcomplex(y, x2)).imag();
    }

    public static Apfloat cos(Apfloat x2) throws ApfloatRuntimeException {
        return ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, x2)).real();
    }

    public static Apfloat sin(Apfloat x2) throws ApfloatRuntimeException {
        return ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, x2)).imag();
    }

    public static Apfloat tan(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex w = ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, x2));
        return w.imag().divide(w.real());
    }

    public static Apfloat product(Apfloat ... x2) throws ApfloatRuntimeException {
        if (x2.length == 0) {
            return Apfloat.ONE;
        }
        long maxPrec = Long.MAX_VALUE;
        for (int i = 0; i < x2.length; ++i) {
            if (x2[i].signum() == 0) {
                return Apfloat.ZERO;
            }
            maxPrec = Math.min(maxPrec, x2[i].precision());
        }
        Apfloat[] tmp = new Apfloat[x2.length];
        long extraPrec = (long)Math.sqrt(x2.length);
        long destPrec = ApfloatHelper.extendPrecision(maxPrec, extraPrec);
        for (int i = 0; i < x2.length; ++i) {
            tmp[i] = x2[i].precision(destPrec);
        }
        x2 = tmp;
        PriorityQueue<Apfloat> heap = new PriorityQueue<Apfloat>(x2.length, new Comparator<Apfloat>(){

            @Override
            public int compare(Apfloat x2, Apfloat y) {
                long ySize;
                long xSize = x2.size();
                return xSize < (ySize = y.size()) ? -1 : (xSize > ySize ? 1 : 0);
            }
        });
        heap.addAll(Arrays.asList(x2));
        while (heap.size() > 1) {
            Apfloat a = (Apfloat)heap.remove();
            Apfloat b = (Apfloat)heap.remove();
            Apfloat c = a.multiply(b);
            heap.add(c);
        }
        return ((Apfloat)heap.remove()).precision(maxPrec);
    }

    public static Apfloat sum(Apfloat ... x2) throws ApfloatRuntimeException {
        if (x2.length == 0) {
            return Apfloat.ZERO;
        }
        long maxScale = -9223372036854775807L;
        long maxPrec = Long.MAX_VALUE;
        for (int i = 0; i < x2.length; ++i) {
            long oldScale = maxScale;
            long oldPrec = maxPrec;
            long newScale = x2[i].scale();
            long newPrec = x2[i].precision();
            maxScale = Math.max(oldScale, newScale);
            long oldScaleDiff = maxScale - oldScale < 0L ? Long.MAX_VALUE : maxScale - oldScale;
            long newScaleDiff = maxScale - newScale < 0L ? Long.MAX_VALUE : maxScale - newScale;
            maxPrec = Math.min(Util.ifFinite(oldPrec, oldPrec + oldScaleDiff), Util.ifFinite(newPrec, newPrec + newScaleDiff));
        }
        Apfloat[] tmp = new Apfloat[x2.length];
        for (int i = 0; i < x2.length; ++i) {
            long scale = x2[i].scale();
            long scaleDiff = maxScale - scale < 0L ? Long.MAX_VALUE : maxScale - scale;
            long destPrec = maxPrec - scaleDiff <= 0L ? 0L : Util.ifFinite(maxPrec, maxPrec - scaleDiff);
            tmp[i] = destPrec > 0L ? x2[i].precision(destPrec) : Apfloat.ZERO;
        }
        x2 = tmp;
        Arrays.sort(x2, new Comparator<Apfloat>(){

            @Override
            public int compare(Apfloat x2, Apfloat y) {
                long yScale;
                long xScale = x2.scale();
                return xScale < (yScale = y.scale()) ? -1 : (xScale > yScale ? 1 : 0);
            }
        });
        Apfloat s = Apfloat.ZERO;
        for (int i = 0; i < x2.length; ++i) {
            s = s.add(x2[i]);
        }
        return s;
    }

    private static Apfloat lastIterationExtendPrecision(int iterations, int precisingIteration, Apfloat x2) throws ApfloatRuntimeException {
        return iterations == 0 && precisingIteration != 0 ? ApfloatHelper.extendPrecision(x2) : x2;
    }

    static Apfloat factorial(long n, long precision) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int radix = ctx.getDefaultRadix();
        return ApfloatMath.factorial(n, precision, radix);
    }

    static Apfloat factorial(long n, long precision, int radix) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        Apfloat oddProduct;
        if (n < 0L) {
            throw new ArithmeticException("Factorial of negative number");
        }
        if (n < 2L) {
            return new Apfloat(1L, precision, radix);
        }
        long targetPrecision = precision;
        precision = ApfloatHelper.extendPrecision(precision);
        Apfloat factorialProduct = oddProduct = new Apfloat(1L, precision, radix);
        long exponentOfTwo = 0L;
        for (int i = 62 - Long.numberOfLeadingZeros(n); i >= 0; --i) {
            long m = n >>> i;
            long k = m >>> 1;
            exponentOfTwo += k;
            oddProduct = oddProduct.multiply(ApfloatMath.oddProduct(k + 1L, m, precision, radix));
            factorialProduct = factorialProduct.multiply(oddProduct);
        }
        return factorialProduct.multiply(ApfloatMath.pow(new Apfloat(2L, precision, radix), exponentOfTwo)).precision(targetPrecision);
    }

    private static Apfloat oddProduct(long n, long m, long precision, int radix) throws ApfloatRuntimeException {
        if ((n |= 1L) > (m = m - 1L | 1L)) {
            return new Apfloat(1L, precision, radix);
        }
        if (n == m) {
            return new Apfloat(n, precision, radix);
        }
        long k = n + m >>> 1;
        return ApfloatMath.oddProduct(n, k, precision, radix).multiply(ApfloatMath.oddProduct(k + 1L, m, precision, radix));
    }

    static void cleanUp() {
        radixPi = SHUTDOWN_MAP;
        radixPiT = SHUTDOWN_MAP;
        radixPiQ = SHUTDOWN_MAP;
        radixPiP = SHUTDOWN_MAP;
        radixPiInverseRoot = SHUTDOWN_MAP;
        radixLog = SHUTDOWN_MAP;
        radixLogPi = SHUTDOWN_MAP;
    }

    private static class PiCalculator {
        private final Apfloat A;
        private final Apfloat B;
        private final Apfloat J;
        private final Apfloat ONE;
        private final Apfloat TWO;
        private final Apfloat FIVE;
        private final Apfloat SIX;
        private int radix;

        public PiCalculator(int radix) throws ApfloatRuntimeException {
            this.A = new Apfloat(13591409L, Long.MAX_VALUE, radix);
            this.B = new Apfloat(545140134L, Long.MAX_VALUE, radix);
            this.J = new Apfloat(10939058860032000L, Long.MAX_VALUE, radix);
            this.ONE = new Apfloat(1L, Long.MAX_VALUE, radix);
            this.TWO = new Apfloat(2L, Long.MAX_VALUE, radix);
            this.FIVE = new Apfloat(5L, Long.MAX_VALUE, radix);
            this.SIX = new Apfloat(6L, Long.MAX_VALUE, radix);
            this.radix = radix;
        }

        private Apfloat a(long n) throws ApfloatRuntimeException {
            Apfloat s = new Apfloat(n, Long.MAX_VALUE, this.radix);
            Apfloat v = this.A.add(this.B.multiply(s));
            v = (n & 1L) == 0L ? v : v.negate();
            return v;
        }

        private Apfloat p(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f2 = new Apfloat(n, Long.MAX_VALUE, this.radix);
                Apfloat sixf = this.SIX.multiply(f2);
                v = sixf.subtract(this.ONE).multiply(this.TWO.multiply(f2).subtract(this.ONE)).multiply(sixf.subtract(this.FIVE));
            }
            return v;
        }

        private Apfloat q(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f2 = new Apfloat(n, Long.MAX_VALUE, this.radix);
                v = this.J.multiply(f2).multiply(f2).multiply(f2);
            }
            return v;
        }

        public void r(long n1, long n2, ApfloatHolder T, ApfloatHolder Q, ApfloatHolder P) throws ApfloatRuntimeException {
            int length = (int)Math.min(n2 - n1, Integer.MAX_VALUE);
            switch (length) {
                case 0: {
                    assert (n1 != n2);
                    break;
                }
                case 1: {
                    Apfloat p0 = this.p(n1);
                    T.setApfloat(this.a(n1).multiply(p0));
                    Q.setApfloat(this.q(n1));
                    P.setApfloat(p0);
                    break;
                }
                case 2: {
                    Apfloat p0 = this.p(n1);
                    Apfloat p01 = p0.multiply(this.p(n1 + 1L));
                    Apfloat q1 = this.q(n1 + 1L);
                    T.setApfloat(q1.multiply(this.a(n1)).multiply(p0).add(this.a(n1 + 1L).multiply(p01)));
                    Q.setApfloat(this.q(n1).multiply(q1));
                    P.setApfloat(p01);
                    break;
                }
                case 3: {
                    Apfloat p0 = this.p(n1);
                    Apfloat p01 = p0.multiply(this.p(n1 + 1L));
                    Apfloat p012 = p01.multiply(this.p(n1 + 2L));
                    Apfloat q2 = this.q(n1 + 2L);
                    Apfloat q12 = this.q(n1 + 1L).multiply(q2);
                    T.setApfloat(q12.multiply(this.a(n1)).multiply(p0).add(q2.multiply(this.a(n1 + 1L)).multiply(p01)).add(this.a(n1 + 2L).multiply(p012)));
                    Q.setApfloat(this.q(n1).multiply(q12));
                    P.setApfloat(p012);
                    break;
                }
                case 4: {
                    Apfloat p0 = this.p(n1);
                    Apfloat p01 = p0.multiply(this.p(n1 + 1L));
                    Apfloat p012 = p01.multiply(this.p(n1 + 2L));
                    Apfloat p0123 = p012.multiply(this.p(n1 + 3L));
                    Apfloat q3 = this.q(n1 + 3L);
                    Apfloat q23 = this.q(n1 + 2L).multiply(q3);
                    Apfloat q123 = this.q(n1 + 1L).multiply(q23);
                    T.setApfloat(q123.multiply(this.a(n1)).multiply(p0).add(q23.multiply(this.a(n1 + 1L)).multiply(p01)).add(q3.multiply(this.a(n1 + 2L)).multiply(p012)).add(this.a(n1 + 3L).multiply(p0123)));
                    Q.setApfloat(this.q(n1).multiply(q123));
                    P.setApfloat(p0123);
                    break;
                }
                default: {
                    long nMiddle = (n1 + n2) / 2L;
                    ApfloatHolder LT = new ApfloatHolder();
                    ApfloatHolder LQ = new ApfloatHolder();
                    ApfloatHolder LP = new ApfloatHolder();
                    this.r(n1, nMiddle, LT, LQ, LP);
                    this.r(nMiddle, n2, T, Q, P);
                    T.setApfloat(Q.getApfloat().multiply(LT.getApfloat()).add(LP.getApfloat().multiply(T.getApfloat())));
                    Q.setApfloat(LQ.getApfloat().multiply(Q.getApfloat()));
                    P.setApfloat(LP.getApfloat().multiply(P.getApfloat()));
                }
            }
        }
    }

    private static class ApfloatHolder {
        private Apfloat apfloat;

        public ApfloatHolder() {
            this(null);
        }

        public ApfloatHolder(Apfloat apfloat) {
            this.apfloat = apfloat;
        }

        public Apfloat getApfloat() {
            return this.apfloat;
        }

        public void setApfloat(Apfloat apfloat) {
            this.apfloat = apfloat;
        }
    }
}

