/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.UnknownPdbAminoAcidException;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;

public class StructureTools {
    public static final String caAtomName = " CA ";
    public static final String nAtomName = "N";
    public static final String oAtomName = "O";
    public static final String cbAtomName = "CB";
    public static final String[] backboneAtomNames = new String[]{"N", " CA ", "C", "O", "CB"};
    public static final Character UNKNOWN_GROUP_LABEL = new Character('x');
    private static Map<String, Integer> nucleotides30;
    private static Map<String, Integer> nucleotides23;
    private static final Map<String, Character> aminoAcids;
    private static final Set<Element> hBondDonorAcceptors;
    public static Logger logger;
    public static final Pattern pdbNumRangeRegex;

    public static final int getNrAtoms(Structure s) {
        int nrAtoms = 0;
        GroupIterator iter2 = new GroupIterator(s);
        while (iter2.hasNext()) {
            Group g = (Group)iter2.next();
            nrAtoms += g.size();
        }
        return nrAtoms;
    }

    public static final int getNrGroups(Structure s) {
        int nrGroups = 0;
        List<Chain> chains = s.getChains(0);
        for (Chain c : chains) {
            nrGroups += c.getAtomLength();
        }
        return nrGroups;
    }

    public static final Atom[] getAtomArray(Structure s, String[] atomNames) {
        List<Chain> chains = s.getModel(0);
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        StructureTools.extractCAatoms(atomNames, chains, atoms);
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAtomArrayAllModels(Structure s, String[] atomNames) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (int i = 0; i < s.nrModels(); ++i) {
            List<Chain> chains = s.getModel(i);
            StructureTools.extractCAatoms(atomNames, chains, atoms);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAllAtomArray(Structure s) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        AtomIterator iter2 = new AtomIterator(s);
        while (iter2.hasNext()) {
            Atom a = iter2.next();
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    private static void extractCAatoms(String[] atomNames, List<Chain> chains, List<Atom> atoms) {
        for (Chain c : chains) {
            for (Group g : c.getAtomGroups()) {
                ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
                boolean thisGroupAllAtoms = true;
                for (int i = 0; i < atomNames.length; ++i) {
                    String atomName = atomNames[i];
                    try {
                        Atom a = g.getAtom(atomName);
                        thisGroupAtoms.add(a);
                        continue;
                    }
                    catch (StructureException e) {
                        thisGroupAllAtoms = false;
                        break;
                    }
                }
                if (!thisGroupAllAtoms) continue;
                for (Atom a : thisGroupAtoms) {
                    atoms.add(a);
                }
            }
        }
    }

    public static final Atom[] getAtomArray(Chain c, String[] atomNames) {
        List<Group> groups = c.getAtomGroups();
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Group g : groups) {
            ArrayList<Atom> thisGroupAtoms = new ArrayList<Atom>();
            boolean thisGroupAllAtoms = true;
            for (int i = 0; i < atomNames.length; ++i) {
                String atomName = atomNames[i];
                try {
                    Atom a = g.getAtom(atomName);
                    thisGroupAtoms.add(a);
                    continue;
                }
                catch (StructureException e) {
                    thisGroupAllAtoms = false;
                    break;
                }
            }
            if (!thisGroupAllAtoms) continue;
            for (Atom a : thisGroupAtoms) {
                atoms.add(a);
            }
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    public static final Atom[] getAtomCAArray(Chain c) {
        String[] atomNames = new String[]{caAtomName};
        return StructureTools.getAtomArray(c, atomNames);
    }

    public static final Atom[] cloneCAArray(Atom[] ca) throws StructureException {
        Atom[] newCA = new Atom[ca.length];
        ArrayList<Chain> model = new ArrayList<Chain>();
        int apos = -1;
        for (Atom a : ca) {
            ++apos;
            Group parentG = a.getGroup();
            Chain parentC = parentG.getChain();
            Chain newChain = null;
            for (Chain c : model) {
                if (!c.getChainID().equals(parentC.getChainID())) continue;
                newChain = c;
                break;
            }
            if (newChain == null) {
                newChain = new ChainImpl();
                newChain.setChainID(parentC.getChainID());
                model.add(newChain);
            }
            Group parentN = (Group)parentG.clone();
            newCA[apos] = parentN.getAtom(caAtomName);
            newChain.addGroup(parentN);
        }
        return newCA;
    }

    public static Group[] cloneGroups(Atom[] ca) {
        Group[] newGroup = new Group[ca.length];
        ArrayList<ChainImpl> model = new ArrayList<ChainImpl>();
        int apos = -1;
        for (Atom a : ca) {
            Group ng;
            ++apos;
            Group parentG = a.getGroup();
            Chain parentC = parentG.getChain();
            Chain newChain = null;
            for (Chain chain2 : model) {
                if (!chain2.getChainID().equals(parentC.getChainID())) continue;
                newChain = chain2;
                break;
            }
            if (newChain == null) {
                newChain = new ChainImpl();
                newChain.setChainID(parentC.getChainID());
                model.add((ChainImpl)newChain);
            }
            newGroup[apos] = ng = (Group)parentG.clone();
            newChain.addGroup(ng);
        }
        return newGroup;
    }

    public static Atom[] duplicateCA2(Atom[] ca2) throws StructureException {
        Chain orig;
        Group g;
        Atom[] ca2clone = new Atom[ca2.length * 2];
        int pos = 0;
        ChainImpl c = null;
        String prevChainId = "";
        for (Atom a : ca2) {
            g = (Group)a.getGroup().clone();
            if (c == null) {
                c = new ChainImpl();
                orig = a.getGroup().getChain();
                c.setChainID(orig.getChainID());
            } else {
                orig = a.getGroup().getChain();
                if (!orig.getChainID().equals(prevChainId)) {
                    c = new ChainImpl();
                    c.setChainID(orig.getChainID());
                }
            }
            c.addGroup(g);
            ca2clone[pos] = g.getAtom(caAtomName);
            ++pos;
        }
        c = null;
        prevChainId = "";
        for (Atom a : ca2) {
            g = (Group)a.getGroup().clone();
            if (c == null) {
                c = new ChainImpl();
                orig = a.getGroup().getChain();
                c.setChainID(orig.getChainID());
            } else {
                orig = a.getGroup().getChain();
                if (!orig.getChainID().equals(prevChainId)) {
                    c = new ChainImpl();
                    c.setChainID(orig.getChainID());
                }
            }
            c.addGroup(g);
            ca2clone[pos] = g.getAtom(caAtomName);
            ++pos;
        }
        return ca2clone;
    }

    public static Atom[] getAtomCAArray(Structure s) {
        String[] atomNames = new String[]{caAtomName};
        return StructureTools.getAtomArray(s, atomNames);
    }

    public static Atom[] getBackboneAtomArray(Structure s) {
        String[] atomNames = backboneAtomNames;
        return StructureTools.getAtomArray(s, atomNames);
    }

    public static final Character convert_3code_1code(String code3) throws UnknownPdbAminoAcidException {
        Character code1 = null;
        code1 = aminoAcids.get(code3);
        if (code1 == null) {
            throw new UnknownPdbAminoAcidException(code3 + " not a standard amino acid");
        }
        return code1;
    }

    public static final Character get1LetterCode(String groupCode3) {
        Character aminoCode1 = null;
        try {
            aminoCode1 = StructureTools.convert_3code_1code(groupCode3);
        }
        catch (UnknownPdbAminoAcidException e) {
            aminoCode1 = StructureTools.isNucleotide(groupCode3) ? null : UNKNOWN_GROUP_LABEL;
        }
        return aminoCode1;
    }

    public static final boolean isNucleotide(String groupCode3) {
        String code = groupCode3.trim();
        if (nucleotides30.containsKey(code)) {
            return true;
        }
        return nucleotides23.containsKey(code);
    }

    public static final Structure getReducedStructure(Structure s, String chainId) throws StructureException {
        StructureImpl newS = new StructureImpl();
        newS.setHeader(s.getHeader());
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(s.getName());
        newS.setSSBonds(s.getSSBonds());
        newS.setDBRefs(s.getDBRefs());
        newS.setSites(s.getSites());
        newS.setNmr(s.isNmr());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.setCompounds(s.getCompounds());
        newS.setConnections(s.getConnections());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        if (chainId != null) {
            chainId = chainId.trim();
        }
        if (chainId == null || chainId.equals("")) {
            List<Chain> model0 = s.getModel(0);
            for (Chain c : model0) {
                newS.addChain(c);
            }
            return newS;
        }
        Chain c = null;
        try {
            c = s.getChainByPDB(chainId);
        }
        catch (StructureException e) {
            System.err.println(e.getMessage() + " trying upper case Chain id...");
            c = s.getChainByPDB(chainId.toUpperCase());
        }
        if (c != null) {
            newS.addChain(c);
            for (Compound comp : s.getCompounds()) {
                if (!comp.getChainId().contains(c.getChainID())) continue;
                newS.getPDBHeader().setDescription("Chain " + c.getChainID() + " of " + s.getPDBCode() + " " + comp.getMolName());
            }
        }
        return newS;
    }

    public static final Structure getReducedStructure(Structure s, int chainNr) throws StructureException {
        StructureImpl newS = new StructureImpl();
        newS.setHeader(s.getHeader());
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(s.getName());
        newS.setSSBonds(s.getSSBonds());
        newS.setDBRefs(s.getDBRefs());
        newS.setSites(s.getSites());
        newS.setNmr(s.isNmr());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.setCompounds(s.getCompounds());
        newS.setConnections(s.getConnections());
        newS.setSSBonds(s.getSSBonds());
        newS.setSites(s.getSites());
        newS.setCrystallographicInfo(s.getCrystallographicInfo());
        newS.getPDBHeader().setDescription("subset of " + s.getPDBCode() + " " + s.getPDBHeader().getDescription());
        if (chainNr < 0) {
            List<Chain> model0 = s.getModel(0);
            for (Chain c : model0) {
                newS.addChain(c);
            }
            return newS;
        }
        Chain c = null;
        c = s.getChain(0, chainNr);
        newS.addChain(c);
        return newS;
    }

    public static final Structure getSubRanges(Structure s, String ranges) throws StructureException {
        Structure struc = StructureTools.getReducedStructure(s, null);
        if (ranges == null || ranges.equals("")) {
            throw new IllegalArgumentException("ranges can't be null or empty");
        }
        if ((ranges = ranges.trim()).startsWith("(")) {
            ranges = ranges.substring(1);
        }
        if (ranges.endsWith(")")) {
            ranges = ranges.substring(0, ranges.length() - 1);
        }
        if (ranges.equals("-")) {
            return s;
        }
        StructureImpl newS = new StructureImpl();
        newS.setHeader(s.getHeader());
        newS.setPDBCode(s.getPDBCode());
        newS.setPDBHeader(s.getPDBHeader());
        newS.setName(s.getName());
        newS.setDBRefs(s.getDBRefs());
        newS.setNmr(s.isNmr());
        newS.setBiologicalAssembly(s.isBiologicalAssembly());
        newS.getPDBHeader().setDescription("sub-range " + ranges + " of " + newS.getPDBCode() + " " + s.getPDBHeader().getDescription());
        newS.setCrystallographicInfo(s.getCrystallographicInfo());
        String[] rangS = ranges.split(",");
        StringWriter name = new StringWriter();
        name.append(s.getName());
        boolean firstRange = true;
        String prevChainId = null;
        for (String r : rangS) {
            Group[] groups;
            Matcher matcher = pdbNumRangeRegex.matcher(r);
            if (!matcher.matches()) {
                throw new StructureException("wrong range specification, should be provided as chainID_pdbResnum1-pdbRensum2: " + ranges);
            }
            String chainId = matcher.group(1);
            Chain chain2 = chainId.equals("_") && struc.size() == 1 ? struc.getChain(0) : struc.getChainByPDB(chainId);
            String pdbresnumStart = matcher.group(2);
            String pdbresnumEnd = matcher.group(3);
            if (!firstRange) {
                name.append(",");
            } else {
                name.append(".");
            }
            if (pdbresnumStart != null && pdbresnumEnd != null) {
                if (pdbresnumStart.charAt(0) == '+') {
                    pdbresnumStart = pdbresnumStart.substring(1);
                }
                if (pdbresnumEnd.charAt(0) == '+') {
                    pdbresnumEnd = pdbresnumEnd.substring(1);
                }
                groups = chain2.getGroupsByPDB(pdbresnumStart, pdbresnumEnd);
                name.append(chainId + "_" + pdbresnumStart + "-" + pdbresnumEnd);
            } else {
                groups = chain2.getAtomGroups().toArray(new Group[chain2.getAtomGroups().size()]);
                name.append(chainId);
            }
            firstRange = true;
            Chain c = null;
            if (prevChainId == null) {
                c = new ChainImpl();
                c.setChainID(chain2.getChainID());
                newS.addChain(c);
            } else if (prevChainId.equals(chain2.getChainID())) {
                c = newS.getChainByPDB(prevChainId);
            } else {
                try {
                    c = newS.getChainByPDB(chain2.getChainID());
                }
                catch (StructureException e) {
                    c = new ChainImpl();
                    c.setChainID(chain2.getChainID());
                    newS.addChain(c);
                }
            }
            for (Group g : groups) {
                c.addGroup(g);
            }
            prevChainId = c.getChainID();
        }
        newS.setName(name.toString());
        return newS;
    }

    public static final String convertAtomsToSeq(Atom[] atoms) {
        StringBuffer buf = new StringBuffer();
        Object prevGroup = null;
        for (Atom a : atoms) {
            Group g = a.getGroup();
            if (prevGroup != null && prevGroup.equals(g)) continue;
            String code3 = g.getPDBName();
            try {
                buf.append(StructureTools.convert_3code_1code(code3));
            }
            catch (UnknownPdbAminoAcidException e) {
                buf.append('X');
            }
            prevGroup = g;
        }
        return buf.toString();
    }

    public static final ResidueNumber getPDBResidueNumber(Group g) {
        return g.getResidueNumber();
    }

    public static final Group getGroupByPDBResidueNumber(Structure struc, ResidueNumber pdbResNum) throws StructureException {
        if (struc == null || pdbResNum == null) {
            throw new IllegalArgumentException("Null argument(s).");
        }
        Chain chain2 = struc.findChain(pdbResNum.getChainId());
        return chain2.getGroupByPDB(pdbResNum);
    }

    public static Map<Group, Double> getGroupDistancesWithinShell(Structure structure, Atom centroid, Set<ResidueNumber> excludeResidues, double radius, boolean includeWater, boolean useAverageDistance) {
        radius *= radius;
        HashMap<Group, Double> distances = new HashMap<Group, Double>();
        HashMap<Group, Integer> atomCounts = new HashMap<Group, Integer>();
        for (Chain chain2 : structure.getChains()) {
            block3: for (Group chainGroup : chain2.getAtomGroups()) {
                if (!includeWater && chainGroup.getPDBName().equals("HOH")) continue;
                for (ResidueNumber rn : excludeResidues) {
                    if (!rn.equals(chainGroup.getResidueNumber())) continue;
                    continue block3;
                }
                for (Atom testAtom : chainGroup.getAtoms()) {
                    try {
                        double dist = Calc.getDistanceFast(centroid, testAtom);
                        if (!(dist <= radius)) continue;
                        if (!distances.containsKey(chainGroup)) {
                            distances.put(chainGroup, Double.POSITIVE_INFINITY);
                        }
                        if (useAverageDistance) {
                            distances.put(chainGroup, (Double)distances.get(chainGroup) + Math.sqrt(dist));
                            if (!atomCounts.containsKey(chainGroup)) {
                                atomCounts.put(chainGroup, 0);
                            }
                            atomCounts.put(chainGroup, (Integer)atomCounts.get(chainGroup) + 1);
                            continue;
                        }
                        if (!(dist < (Double)distances.get(chainGroup))) continue;
                        distances.put(chainGroup, dist);
                    }
                    catch (StructureException ex) {
                        Logger.getLogger(StructureTools.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        if (useAverageDistance) {
            for (Map.Entry entry : distances.entrySet()) {
                int count2 = (Integer)atomCounts.get(entry.getKey());
                distances.put((Group)entry.getKey(), (Double)entry.getValue() / (double)count2);
            }
        } else {
            for (Map.Entry entry : distances.entrySet()) {
                distances.put((Group)entry.getKey(), Math.sqrt((Double)entry.getValue()));
            }
        }
        return distances;
    }

    public static Set<Group> getGroupsWithinShell(Structure structure, Atom atom, Set<ResidueNumber> excludeResidues, double distance, boolean includeWater) {
        distance *= distance;
        LinkedHashSet<Group> returnSet = new LinkedHashSet<Group>();
        for (Chain chain2 : structure.getChains()) {
            block3: for (Group chainGroup : chain2.getAtomGroups()) {
                if (!includeWater && chainGroup.getPDBName().equals("HOH")) continue;
                for (ResidueNumber rn : excludeResidues) {
                    if (!rn.equals(chainGroup.getResidueNumber())) continue;
                    continue block3;
                }
                for (Atom atomB : chainGroup.getAtoms()) {
                    try {
                        double dist = Calc.getDistanceFast(atom, atomB);
                        if (!(dist <= distance)) continue;
                        returnSet.add(chainGroup);
                        continue block3;
                    }
                    catch (StructureException ex) {
                        Logger.getLogger(StructureTools.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return returnSet;
    }

    public static List<Group> getGroupsWithinShell(Structure structure, Group group, double distance, boolean includeWater) {
        ArrayList<Group> returnList = new ArrayList<Group>();
        HashSet<ResidueNumber> excludeGroups = new HashSet<ResidueNumber>();
        excludeGroups.add(group.getResidueNumber());
        for (Atom atom : group.getAtoms()) {
            Set<Group> set = StructureTools.getGroupsWithinShell(structure, atom, excludeGroups, distance, includeWater);
            returnList.addAll(set);
        }
        return returnList;
    }

    public static Structure removeModels(Structure s) {
        if (!s.isNmr()) {
            return s;
        }
        StructureImpl n = new StructureImpl();
        n.setNmr(true);
        n.setPDBCode(s.getPDBCode());
        n.setName(s.getName());
        n.setHeader(s.getHeader());
        n.setPDBHeader(s.getPDBHeader());
        n.setDBRefs(s.getDBRefs());
        n.setConnections(s.getConnections());
        n.setSites(s.getSites());
        n.setCrystallographicInfo(s.getCrystallographicInfo());
        n.setChains(s.getModel(0));
        return n;
    }

    public static List<Group> filterLigands(List<Group> allGroups) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group g : allGroups) {
            ChemComp cc = g.getChemComp();
            if (ResidueType.lPeptideLinking.equals(cc.getResidueType()) || PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType()) || g.isWater()) continue;
            groups.add(g);
        }
        return groups;
    }

    public static Structure getStructure(String name) throws IOException, StructureException {
        return StructureTools.getStructure(name, null, null);
    }

    public static Structure getStructure(String name, PDBFileParser parser, AtomCache cache) throws IOException, StructureException {
        File f2 = new File(name);
        if (f2.exists()) {
            if (parser == null) {
                parser = new PDBFileParser();
            }
            FileInputStream inStream = new FileInputStream(f2);
            return parser.parsePDBFile(inStream);
        }
        if (cache == null) {
            cache = new AtomCache();
        }
        return cache.getStructure(name);
    }

    static {
        logger = Logger.getLogger("org.biojava.bio.structure");
        pdbNumRangeRegex = Pattern.compile("^\\s*(\\w)(?:(?::|_|:$|_$|$)(?:([-+]?[0-9]+[A-Za-z]?)\\s*-\\s*([-+]?[0-9]+[A-Za-z]?))?+)?\\s*");
        nucleotides30 = new HashMap<String, Integer>();
        nucleotides30.put("DA", 1);
        nucleotides30.put("DC", 1);
        nucleotides30.put("DG", 1);
        nucleotides30.put("DT", 1);
        nucleotides30.put("DI", 1);
        nucleotides30.put("A", 1);
        nucleotides30.put("G", 1);
        nucleotides30.put("C", 1);
        nucleotides30.put("U", 1);
        nucleotides30.put("I", 1);
        nucleotides30.put("TAF", 1);
        nucleotides30.put("TC1", 1);
        nucleotides30.put("TFE", 1);
        nucleotides30.put("TFO", 1);
        nucleotides30.put("TGP", 1);
        nucleotides30.put("THX", 1);
        nucleotides30.put("TLC", 1);
        nucleotides30.put("TLN", 1);
        nucleotides30.put("TP1", 1);
        nucleotides30.put("TPC", 1);
        nucleotides30.put("TPN", 1);
        nucleotides23 = new HashMap<String, Integer>();
        String[] names = new String[]{"C", "G", "A", "T", "U", "I", "+C", "+G", "+A", "+T", "+U", "+I"};
        for (int i = 0; i < names.length; ++i) {
            String n = names[i];
            nucleotides23.put(n, 1);
        }
        aminoAcids = new HashMap<String, Character>();
        aminoAcids.put("GLY", new Character('G'));
        aminoAcids.put("ALA", new Character('A'));
        aminoAcids.put("VAL", new Character('V'));
        aminoAcids.put("LEU", new Character('L'));
        aminoAcids.put("ILE", new Character('I'));
        aminoAcids.put("PHE", new Character('F'));
        aminoAcids.put("TYR", new Character('Y'));
        aminoAcids.put("TRP", new Character('W'));
        aminoAcids.put("PRO", new Character('P'));
        aminoAcids.put("HIS", new Character('H'));
        aminoAcids.put("LYS", new Character('K'));
        aminoAcids.put("ARG", new Character('R'));
        aminoAcids.put("SER", new Character('S'));
        aminoAcids.put("THR", new Character('T'));
        aminoAcids.put("GLU", new Character('E'));
        aminoAcids.put("GLN", new Character('Q'));
        aminoAcids.put("ASP", new Character('D'));
        aminoAcids.put("ASN", new Character('N'));
        aminoAcids.put("CYS", new Character('C'));
        aminoAcids.put("MET", new Character('M'));
        aminoAcids.put("MSE", new Character('M'));
        aminoAcids.put("CSE", new Character('U'));
        aminoAcids.put("SEC", new Character('U'));
        aminoAcids.put("PYH", new Character('O'));
        aminoAcids.put("PYL", new Character('O'));
        hBondDonorAcceptors = new HashSet<Element>();
        hBondDonorAcceptors.add(Element.N);
        hBondDonorAcceptors.add(Element.O);
        hBondDonorAcceptors.add(Element.S);
    }
}

