/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.StructureAlignmentFactory;
import org.biojava.bio.structure.align.ce.CeCPMain;
import org.biojava.bio.structure.align.ce.CeMain;
import org.biojava.bio.structure.align.client.CountProgressListener;
import org.biojava.bio.structure.align.client.FarmJobParameters;
import org.biojava.bio.structure.align.client.JFatCatClient;
import org.biojava.bio.structure.align.client.JobKillException;
import org.biojava.bio.structure.align.client.PdbPair;
import org.biojava.bio.structure.align.events.AlignmentProgressListener;
import org.biojava.bio.structure.align.fatcat.FatCatFlexible;
import org.biojava.bio.structure.align.fatcat.FatCatRigid;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AFPChainScorer;
import org.biojava.bio.structure.align.util.AlignmentTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.align.util.ResourceManager;
import org.biojava.bio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.bio.structure.align.xml.PdbPairsMessage;
import org.biojava.bio.structure.domain.RemotePDPProvider;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.scop.RemoteScopInstallation;
import org.biojava.bio.structure.scop.ScopFactory;
import org.biojava3.core.util.FlatFileCache;
import org.biojava3.core.util.PrettyXMLWriter;

public class FarmJobRunnable
implements Runnable {
    private static final String JFATCAT_NAME = "jfatcat.name";
    private static final String JFATCAT_VERSION = "jfatcat.version";
    private static ResourceManager resourceManager = ResourceManager.getResourceManager("jfatcat");
    private static DateFormat dateFormat = new SimpleDateFormat("MMMM dd, yyyy h:mm a", Locale.US);
    FarmJobParameters params;
    String prevName1;
    Atom[] ca1;
    long startTime;
    long maxTime;
    int maxNrAlignments;
    int alignmentsCalculated;
    boolean waitForAlignments;
    private static final String randomUsername = FarmJobRunnable.getRandomUsername();
    boolean terminated = false;
    List<AlignmentProgressListener> progressListeners;
    CountProgressListener counter;
    String userName = null;
    protected AtomCache cache;
    boolean verbose = false;
    String version = null;
    private static final String alignURL = "/align/";

    public FarmJobRunnable(FarmJobParameters params) {
        this.params = params;
        this.verbose = false;
        this.cache = new AtomCache(params.getPdbFilePath(), params.isPdbDirSplit());
        if (params.getServer() != null && !params.getServer().equals("")) {
            RemotePDPProvider pdpprovider = new RemotePDPProvider();
            String serverURL = params.getServer();
            if (!serverURL.endsWith("/")) {
                serverURL = serverURL + "/";
            }
            if (serverURL.endsWith(alignURL)) {
                serverURL = serverURL.substring(0, serverURL.length() - alignURL.length());
            }
            pdpprovider.setServer(serverURL + "/domains/");
            this.cache.setPdpprovider(pdpprovider);
            RemoteScopInstallation scop = new RemoteScopInstallation();
            scop.setServer(serverURL + "/domains/");
            ScopFactory.setScopDatabase(scop);
        }
        FileParsingParameters fparams = this.cache.getFileParsingParams();
        fparams.setUpdateRemediatedFiles(params.isUpdateRemediatedFiles());
        this.maxNrAlignments = params.getNrAlignments();
        this.progressListeners = null;
        this.userName = params.getUsername() == null ? randomUsername : params.getUsername();
        this.counter = new CountProgressListener();
        this.addAlignmentProgressListener(this.counter);
        this.waitForAlignments = true;
        if (params.isVerbose()) {
            this.verbose = true;
        }
    }

    public void addAlignmentProgressListener(AlignmentProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<AlignmentProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void clearListeners() {
        if (this.progressListeners == null) {
            return;
        }
        this.progressListeners.clear();
        this.progressListeners = null;
    }

    protected static String getRandomUsername() {
        String name = "";
        try {
            InetAddress i = InetAddress.getLocalHost();
            name = name + i.getHostAddress();
            name = name + "_";
        }
        catch (Exception exception) {
            // empty catch block
        }
        name = name + UUID.randomUUID();
        return name;
    }

    public static void log(String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Date date = new Date();
        buf.append(dateFormat.format(date));
        buf.append("] ");
        buf.append(message);
        System.out.println(buf.toString());
    }

    @Override
    public void run() {
        String appVersion = resourceManager.getString(JFATCAT_VERSION);
        String appName = resourceManager.getString(JFATCAT_NAME);
        FarmJobRunnable.log(appName + " version:" + appVersion);
        this.startTime = System.currentTimeMillis();
        long maxSec = this.params.getTime();
        this.maxTime = maxSec < 5L ? Long.MAX_VALUE : this.startTime + (long)(this.params.getTime() * 1000);
        this.terminated = false;
        this.alignmentsCalculated = 0;
        this.maxNrAlignments = this.params.getNrAlignments();
        if (this.maxNrAlignments < 0) {
            this.maxNrAlignments = Integer.MAX_VALUE;
        }
        FarmJobRunnable.log("running job for max: " + this.maxNrAlignments + " alignments");
        while (!this.terminated) {
            long tdiff;
            PdbPairsMessage msg = this.getAlignmentPairsFromServer();
            if (msg == null) {
                System.err.println("Got null instead of alignment pairs from server.");
                this.randomSleep();
                continue;
            }
            SortedSet<PdbPair> alignmentPairs = msg.getPairs();
            FarmJobRunnable.log(this.userName + ": Server responded with " + alignmentPairs.size() + " pairs.");
            ArrayList<String> results = new ArrayList<String>();
            String algorithmName = msg.getMethod();
            if (this.version == null) {
                this.setVersion(algorithmName);
            }
            for (PdbPair pair2 : alignmentPairs) {
                if (this.terminated) break;
                long now = System.currentTimeMillis();
                if (now >= this.maxTime) {
                    this.terminated = true;
                    break;
                }
                if (this.alignmentsCalculated >= this.maxNrAlignments) {
                    this.terminated = true;
                    break;
                }
                String name1 = pair2.getName1();
                String name2 = pair2.getName2();
                if (this.progressListeners != null) {
                    this.notifyStartAlignment(name1, name2);
                }
                try {
                    String resultXML = this.alignPair(name1, name2, algorithmName);
                    if (this.progressListeners != null) {
                        this.notifyEndAlignment();
                    }
                    results.add(resultXML);
                }
                catch (Exception e) {
                    System.err.println("Problem aligning " + name1 + " " + name2);
                    e.printStackTrace();
                    FarmJobRunnable.log("Error: " + e.getMessage() + " while aligning " + name1 + " vs. " + name2);
                    System.err.println(e.getMessage());
                    StringWriter sw = new StringWriter();
                    PrintWriter writer = new PrintWriter(sw);
                    PrettyXMLWriter xml = new PrettyXMLWriter(writer);
                    try {
                        xml.openTag("AFPChain");
                        xml.attribute("name1", name1);
                        xml.attribute("name2", name2);
                        xml.attribute("error", e.getMessage());
                        xml.closeTag("AFPChain");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    if (this.progressListeners != null) {
                        this.notifyEndAlignment();
                    }
                    results.add(sw.toString());
                }
                ++this.alignmentsCalculated;
            }
            this.sendResultsToServer(results);
            long end = System.currentTimeMillis();
            if (end >= this.maxTime) {
                System.out.println("OK end of job: reached maxTime.");
                this.terminated = true;
            }
            if (this.alignmentsCalculated >= this.maxNrAlignments) {
                System.out.println("OK end of job: reached maxNrAlignments");
                this.terminated = true;
            }
            if ((tdiff = end - this.startTime) == 0L) continue;
            FarmJobRunnable.log(this.userName + String.format(": job has run for :  %.2f", (double)tdiff / 1000.0 / 60.0) + " min.");
            FarmJobRunnable.log(this.userName + ": total nr of alignments calculated: " + this.alignmentsCalculated);
            if (this.alignmentsCalculated <= 0) continue;
            FarmJobRunnable.log(this.userName + String.format(": average time / alignment: %.2f", (double)(tdiff / (long)this.alignmentsCalculated) / 1000.0) + " sec.");
        }
        FarmJobRunnable.log(this.userName + ": jFATCAT job result: " + this.counter.toString());
        this.clearListeners();
        this.cache.notifyShutdown();
    }

    private void setVersion(String algorithmName) {
        try {
            StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm(algorithmName);
            this.version = algorithm.getVersion();
        }
        catch (StructureException e) {
            e.printStackTrace();
            this.version = resourceManager.getString(JFATCAT_VERSION);
        }
    }

    private void notifyStartAlignment(String name1, String name2) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.alignmentStarted(name1, name2);
            }
        }
    }

    private void notifyEndAlignment() {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.alignmentEnded();
            }
        }
    }

    private void notifyRequestingAlignments(int nrAlignments) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.requestingAlignmentsFromServer(nrAlignments);
            }
        }
    }

    private void notifySubmittingAlignments(int nrAlignments, String message) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.sentResultsToServer(nrAlignments, message);
            }
        }
    }

    public String alignPair(String name1, String name2) throws StructureException, IOException {
        return this.alignPair(name1, name2, FatCatRigid.algorithmName);
    }

    public String alignPair(String name1, String name2, String algorithmName) throws StructureException, IOException {
        StructureAlignment algorithm = this.getAlgorithm(algorithmName);
        if (this.verbose) {
            FarmJobRunnable.log("aligning " + name1 + " vs. " + name2);
        }
        long startTime = System.currentTimeMillis();
        if (this.prevName1 == null) {
            this.initMaster(name1);
        }
        if (!this.prevName1.equals(name1)) {
            this.initMaster(name1);
        }
        Atom[] ca2 = this.cache.getAtoms(name2);
        AFPChain afpChain = algorithm.align(this.ca1, ca2);
        afpChain.setName1(name1);
        afpChain.setName2(name2);
        try {
            double tmScore = AFPChainScorer.getTMScore(afpChain, this.ca1, ca2);
            afpChain.setTMScore(tmScore);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ca1 size:" + this.ca1.length + " ca2 length: " + ca2.length + " " + afpChain.getName1() + " " + afpChain.getName2());
        }
        long endTime = System.currentTimeMillis();
        long calcTime = endTime - startTime;
        if (this.verbose) {
            boolean isCP = !AlignmentTools.isSequentialAlignment(afpChain, false);
            String msg = "finished alignment: " + name1 + " vs. " + name2 + " in " + (double)calcTime / 1000.0 + " sec.";
            msg = msg + " algo: " + algorithmName + " v:" + this.version + " " + afpChain;
            if (isCP) {
                msg = msg + "HAS A CIRCULAR PERMUTATION!!!";
            }
            FarmJobRunnable.log(msg);
        }
        if (this.verbose) {
            this.printMemory();
        }
        afpChain.setCalculationTime(calcTime);
        String xml = AFPChainXMLConverter.toXML(afpChain, this.ca1, ca2);
        return xml;
    }

    private void printMemory() {
        int size2 = 0x100000;
        long heapSize = Runtime.getRuntime().totalMemory() / (long)size2;
        long heapMaxSize = Runtime.getRuntime().maxMemory() / (long)size2;
        long heapFreeSize = Runtime.getRuntime().freeMemory() / (long)size2;
        StringBuffer msg = new StringBuffer();
        msg.append("  total: ").append(heapSize).append(" M");
        msg.append(" max: ").append(heapMaxSize).append(" M");
        msg.append(" free: ").append(heapFreeSize).append(" M");
        System.out.println(msg.toString());
    }

    private StructureAlignment getAlgorithm(String algorithmName) {
        StructureAlignment algorithm = null;
        if (algorithmName == null) {
            algorithm = new FatCatRigid();
        } else if (algorithmName.equalsIgnoreCase(FatCatRigid.algorithmName)) {
            algorithm = new FatCatRigid();
        } else if (algorithmName.equalsIgnoreCase("jCE")) {
            algorithm = new CeMain();
        } else if (algorithmName.equalsIgnoreCase("jCE Circular Permutation")) {
            algorithm = new CeCPMain();
        } else if (algorithmName.equalsIgnoreCase(FatCatFlexible.algorithmName)) {
            algorithm = new FatCatFlexible();
        } else {
            try {
                algorithm = StructureAlignmentFactory.getAlgorithm(algorithmName);
            }
            catch (StructureException ex) {
                ex.printStackTrace();
            }
        }
        if (algorithm == null) {
            algorithm = new FatCatRigid();
        }
        return algorithm;
    }

    private void initMaster(String name1) throws IOException, StructureException {
        this.ca1 = this.cache.getAtoms(name1);
        this.prevName1 = name1;
    }

    protected PdbPairsMessage getAlignmentPairsFromServer() {
        String url = this.params.getServer();
        int nrPairs = this.params.getStepSize();
        if (this.maxNrAlignments < nrPairs) {
            nrPairs = this.maxNrAlignments;
        }
        SortedSet<Object> allPairs = new TreeSet();
        PdbPairsMessage msg = null;
        try {
            if (this.progressListeners != null) {
                this.notifyRequestingAlignments(nrPairs);
            }
            if (!this.waitForAlignments) {
                msg = JFatCatClient.getPdbPairs(url, nrPairs, this.userName);
                allPairs = msg.getPairs();
            } else {
                while (allPairs.size() == 0) {
                    msg = JFatCatClient.getPdbPairs(url, nrPairs, this.userName);
                    allPairs = msg.getPairs();
                    if (allPairs.size() != 0) continue;
                    this.randomSleep();
                }
            }
        }
        catch (JobKillException k) {
            this.terminate();
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.println("Error while requesting alignment pairs: " + e.getMessage());
            this.randomSleep();
        }
        return msg;
    }

    private void randomSleep() {
        try {
            int delay2 = JFatCatClient.getRandomSleepTime();
            System.err.println("sleeping " + delay2 / 1000 + " sec.");
            Thread.sleep(delay2);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void sendResultsToServer(List<String> results) {
        String serverLocation = this.params.getServer();
        if (results.size() < 1) {
            return;
        }
        String fullXml = "<alignments>";
        for (String xml : results) {
            fullXml = fullXml + xml;
        }
        fullXml = fullXml + "</alignments>";
        String msg = "";
        try {
            msg = JFatCatClient.sendMultiAFPChainToServer(serverLocation, fullXml, this.userName, this.version);
        }
        catch (JobKillException e) {
            FarmJobRunnable.log(this.userName + " Got Job Kill message from server, terminating...");
            e.printStackTrace();
            this.terminate();
        }
        if (this.progressListeners != null) {
            this.notifySubmittingAlignments(results.size(), msg);
        }
        FarmJobRunnable.log(this.userName + ": Sent " + results.size() + " results to server. job status:" + this.counter.toString());
        FarmJobRunnable.log(this.userName + ": fileCache size:" + FlatFileCache.getInstance().size());
    }

    public synchronized void terminate() {
        this.terminated = true;
    }

    public boolean isWaitForAlignments() {
        return this.waitForAlignments;
    }

    public void setWaitForAlignments(boolean waitForAlignments) {
        this.waitForAlignments = waitForAlignments;
    }
}

