/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.client;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Matcher;
import org.biojava.bio.structure.align.util.AtomCache;

public class StructureName
implements Comparable<StructureName>,
Serializable {
    private static final long serialVersionUID = 4021229518711762954L;
    protected String name;
    protected String pdbId;
    protected String chainId;
    String cathPattern = "[0-9][a-z0-9][a-z0-9][a-z0-9].[0-9][0-9]";
    Source mySource = null;

    public StructureName(String name) {
        if (name.length() < 4) {
            throw new IllegalArgumentException("This is not a valid StructureName:" + name);
        }
        this.name = name;
        this.pdbId = this.parsePdbId();
        this.chainId = this.parseChainId();
    }

    public String getPdbId() {
        return this.pdbId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String chainID;
        StringWriter s = new StringWriter();
        s.append(this.name);
        s.append(" PDB ID: ");
        s.append(this.getPdbId());
        if (this.isScopName()) {
            s.append(" is a SCOP name");
        }
        if ((chainID = this.getChainId()) != null) {
            s.append(" has chain ID: ");
            s.append(chainID);
        }
        if (this.isPDPDomain()) {
            s.append(" is a PDP domain");
        }
        return s.toString();
    }

    public boolean isScopName() {
        return this.name.startsWith("d") && this.name.length() > 6;
    }

    public boolean hasChainID() {
        return this.chainId != null;
    }

    public boolean isPDPDomain() {
        return this.name.startsWith("PDP:");
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureName other = (StructureName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(StructureName o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o.getPdbId() == null) {
            return -1;
        }
        if (this.getPdbId() == null) {
            return 1;
        }
        if (!o.getPdbId().equals(this.getPdbId())) {
            return this.getPdbId().compareTo(o.getPdbId());
        }
        return this.getName().compareTo(o.getName());
    }

    private String parsePdbId() {
        if (this.isScopName()) {
            this.mySource = Source.SCOP;
            return this.name.substring(1, 5).toUpperCase();
        }
        if (this.name.startsWith("PDP:")) {
            this.mySource = Source.PDP;
            return this.name.substring(4, 8).toUpperCase();
        }
        if (this.isCathID()) {
            this.mySource = Source.CATH;
            return this.name.substring(0, 4);
        }
        this.mySource = Source.PDB;
        return this.name.substring(0, 4).toUpperCase();
    }

    private String parseChainId() {
        if (this.name.length() == 6) {
            if (this.name.substring(4, 5).equals(".")) {
                return this.name.substring(5, 6);
            }
        } else {
            if (this.isCathID()) {
                return this.name.substring(4, 5);
            }
            if (this.name.startsWith("d")) {
                Matcher scopMatch = AtomCache.scopIDregex.matcher(this.name);
                if (scopMatch.matches()) {
                    String chainID = scopMatch.group(2);
                    return chainID.toUpperCase();
                }
            } else if (this.name.startsWith("PDP:")) {
                String chainID = this.name.substring(8, 9);
                return chainID;
            }
        }
        return null;
    }

    public boolean isCathID() {
        if (this.name.length() != 7) {
            return false;
        }
        return this.name.matches(this.cathPattern);
    }

    private static enum Source {
        PDB,
        SCOP,
        PDP,
        CATH;

    }
}

