/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.pairwise;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.jama.Matrix;

public class FragmentPair {
    int length;
    int pos1;
    int pos2;
    int contacts;
    int cluster;
    double rms;
    int used;
    int covered;
    Matrix rot;
    Atom trans;
    Atom unitv;
    Atom center1;
    Atom center2;

    public FragmentPair(int length, int p1, int p2) {
        this.length = length;
        this.pos1 = p1;
        this.pos2 = p2;
        this.contacts = 0;
        this.cluster = 0;
        this.rms = 0.0;
        this.used = 0;
        this.covered = 0;
        this.unitv = new AtomImpl();
        this.unitv.setX(0.0);
        this.unitv.setY(0.0);
        this.unitv.setZ(1.0);
        this.rot = null;
        this.trans = new AtomImpl();
        this.center1 = new AtomImpl();
        this.center2 = new AtomImpl();
    }

    public Object clone() {
        FragmentPair n = new FragmentPair(this.length, this.pos1, this.pos2);
        if (this.center1 != null) {
            n.setCenter1((Atom)this.center1.clone());
        }
        if (this.center2 != null) {
            n.setCenter2((Atom)this.center2.clone());
        }
        n.setCluster(this.cluster);
        n.setContacts(this.contacts);
        n.setCovered(this.covered);
        n.setRms(this.rms);
        n.setLength(this.length);
        n.setRot((Matrix)this.rot.clone());
        n.setUnitv((Atom)this.unitv.clone());
        return n;
    }

    public int getCluster() {
        return this.cluster;
    }

    public void setCluster(int cluster) {
        this.cluster = cluster;
    }

    public int getContacts() {
        return this.contacts;
    }

    public void setContacts(int contacts) {
        this.contacts = contacts;
    }

    public int getCovered() {
        return this.covered;
    }

    public void setCovered(int covered) {
        this.covered = covered;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPos1() {
        return this.pos1;
    }

    public void setPos1(int pos1) {
        this.pos1 = pos1;
    }

    public int getPos2() {
        return this.pos2;
    }

    public void setPos2(int pos2) {
        this.pos2 = pos2;
    }

    public double getRms() {
        return this.rms;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public Matrix getRot() {
        return this.rot;
    }

    public void setRot(Matrix rot) {
        this.rot = rot;
    }

    public Atom getTrans() {
        return this.trans;
    }

    public void setTrans(Atom trans) {
        this.trans = trans;
    }

    public Atom getUnitv() {
        return this.unitv;
    }

    public void setUnitv(Atom unitv) {
        this.unitv = unitv;
    }

    public int getUsed() {
        return this.used;
    }

    public void setUsed(int used) {
        this.used = used;
    }

    public Atom getCenter1() {
        return this.center1;
    }

    public void setCenter1(Atom center1) {
        this.center1 = center1;
    }

    public Atom getCenter2() {
        return this.center2;
    }

    public void setCenter2(Atom center2) {
        this.center2 = center2;
    }

    public String toString() {
        return String.format("Fragment (%d,%d) len %d", this.pos1, this.pos2, this.length);
    }
}

