/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.align.util.UserConfiguration;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava3.core.util.InputStreamProvider;

public class MMCIFFileReader
implements StructureIOFile {
    String path;
    List<String> extensions = new ArrayList<String>();
    boolean autoFetch;
    boolean pdbDirectorySplit;
    public static final String lineSplit = System.getProperty("file.separator");
    FileParsingParameters params;
    SimpleMMcifConsumer consumer;

    public static void main(String[] args) {
        MMCIFFileReader reader = new MMCIFFileReader();
        FileParsingParameters params = new FileParsingParameters();
        reader.setFileParsingParameters(params);
        try {
            Structure struc = reader.getStructureById("1m4x");
            System.out.println(struc);
            System.out.println(struc.toPDB());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MMCIFFileReader() {
        this.extensions.add(".cif");
        this.extensions.add(".mmcif");
        this.extensions.add(".cif.gz");
        this.extensions.add(".mmcif.gz");
        UserConfiguration config = new UserConfiguration();
        this.path = config.getPdbFilePath();
        this.autoFetch = config.getAutoFetch();
        this.pdbDirectorySplit = config.isSplit();
        this.params = new FileParsingParameters();
    }

    @Override
    public void addExtension(String ext) {
        this.extensions.add(ext);
    }

    @Override
    public void clearExtensions() {
        this.extensions.clear();
    }

    @Override
    public Structure getStructure(String filename) throws IOException {
        File f2 = new File(filename);
        return this.getStructure(f2);
    }

    @Override
    public Structure getStructure(File filename) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        return this.parseFromInputStream(inStream);
    }

    private Structure parseFromInputStream(InputStream inStream) throws IOException {
        SimpleMMcifParser parser = new SimpleMMcifParser();
        this.consumer = new SimpleMMcifConsumer();
        this.consumer.setFileParsingParameters(this.params);
        parser.addMMcifConsumer(this.consumer);
        parser.parse(new BufferedReader(new InputStreamReader(inStream)));
        Structure cifStructure = this.consumer.getStructure();
        return cifStructure;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException {
        InputStream inStream = this.getInputStream(pdbId);
        return this.parseFromInputStream(inStream);
    }

    private InputStream getInputStream(String pdbId) throws IOException {
        String ppath;
        String fpath;
        if (pdbId.length() < 4) {
            throw new IOException("the provided ID does not look like a PDB ID : " + pdbId);
        }
        InputStream inputStream = null;
        String pdbFile = null;
        File f2 = null;
        if (this.pdbDirectorySplit) {
            String middle = pdbId.substring(1, 3).toLowerCase();
            fpath = this.path + lineSplit + middle + lineSplit + pdbId;
            ppath = this.path + lineSplit + middle + lineSplit + "pdb" + pdbId;
        } else {
            fpath = this.path + lineSplit + pdbId;
            ppath = this.path + lineSplit + "pdb" + pdbId;
        }
        String[] paths = new String[]{fpath, ppath};
        block0: for (int p = 0; p < paths.length; ++p) {
            String testpath = paths[p];
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = this.extensions.get(i);
                f2 = new File(testpath + ex);
                if (f2.exists()) {
                    long lastModified;
                    pdbFile = testpath + ex;
                    if (this.params.isUpdateRemediatedFiles() && (lastModified = f2.lastModified()) < PDBFileReader.lastRemediationDate) {
                        System.out.println("replacing file " + pdbFile + " with latest remediated file from PDB.");
                        pdbFile = null;
                        return null;
                    }
                    InputStreamProvider isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(pdbFile);
                    continue block0;
                }
                if (pdbFile != null) continue block0;
            }
        }
        if (pdbFile == null) {
            if (this.autoFetch) {
                return this.downloadAndGetInputStream(pdbId);
            }
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    private InputStream downloadAndGetInputStream(String pdbId) throws IOException {
        File tmp = this.downloadPDB(pdbId);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            return prov.getInputStream(tmp);
        }
        throw new IOException("could not find PDB " + pdbId + " in file system and also could not download");
    }

    public File downloadPDB(String pdbId) {
        File tempFile;
        if (this.path == null || this.path.equals("")) {
            System.err.println("you did not set the path in PDBFileReader, don;t know where to write the downloaded file to");
            System.err.println("assuming default location is local directory.");
            this.path = ".";
        }
        if (this.pdbDirectorySplit) {
            String middle = pdbId.substring(1, 3).toLowerCase();
            String dir = this.path + lineSplit + middle;
            File directoryCheck = new File(dir);
            if (!directoryCheck.exists()) {
                directoryCheck.mkdir();
            }
            tempFile = new File(dir + lineSplit + pdbId.toLowerCase() + ".cif.gz");
        } else {
            tempFile = new File(this.path + lineSplit + pdbId.toLowerCase() + ".cif.gz");
        }
        String ftp = String.format("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/mmCIF/%s.cif.gz", pdbId.toLowerCase());
        System.out.println("Fetching " + ftp);
        try {
            String line;
            URL url = new URL(ftp);
            InputStream conn = url.openStream();
            System.out.println("writing to " + tempFile);
            FileOutputStream outPut = new FileOutputStream(tempFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(new GZIPInputStream(conn)));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tempFile;
    }

    @Override
    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    @Override
    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    @Override
    public boolean isPdbDirectorySplit() {
        return this.pdbDirectorySplit;
    }

    @Override
    public void setPdbDirectorySplit(boolean pdbDirectorySplit) {
        this.pdbDirectorySplit = pdbDirectorySplit;
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    public SimpleMMcifConsumer getMMcifConsumer() {
        return this.consumer;
    }

    public void setMMCifConsumer(SimpleMMcifConsumer consumer) {
        this.consumer = consumer;
    }
}

