/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.align.util.HTTPConnectionTools;
import org.biojava.bio.structure.io.mmcif.AllChemCompProvider;
import org.biojava.bio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.bio.structure.io.mmcif.ChemCompProvider;
import org.biojava.bio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava3.core.util.InputStreamProvider;

public class DownloadChemCompProvider
implements ChemCompProvider {
    static String path;
    private static final String FILE_SEPARATOR;
    static final String NEWLINE;
    public static String CHEM_COMP_CACHE_DIRECTORY;
    private static String serverLocation;
    static AtomicBoolean loading;
    static final List<String> protectedIDs;
    boolean downloadAll = false;

    public void checkDoFirstInstall() {
        String filename;
        File f2;
        if (!this.downloadAll) {
            return;
        }
        if (path == null) {
            path = System.getProperty("PDB_CACHE_DIR");
        }
        if (path == null || path.equals("")) {
            path = System.getProperty("PDB_DIR");
        }
        if (!(f2 = new File(filename = path + CHEM_COMP_CACHE_DIRECTORY + FILE_SEPARATOR + "components.cif.gz")).exists()) {
            this.downloadAllDefinitions();
        } else {
            FilenameFilter filter2;
            String directoryName = path + CHEM_COMP_CACHE_DIRECTORY + FILE_SEPARATOR;
            File dir = new File(directoryName);
            String[] files = dir.list(filter2 = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String file) {
                    return file.endsWith(".cif.gz");
                }
            });
            if (files.length < 500) {
                this.split();
            }
        }
    }

    private void split() {
        System.out.println("Installing individual chem comp files ...");
        if (path == null) {
            path = System.getProperty("java.io.tmpdir");
        }
        String filename = path + CHEM_COMP_CACHE_DIRECTORY + FILE_SEPARATOR + "components.cif.gz";
        int counter = 0;
        InputStreamProvider prov = new InputStreamProvider();
        try {
            InputStream inStream = prov.getInputStream(filename);
            BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
            String line = null;
            line = buf.readLine();
            StringWriter writer = new StringWriter();
            String currentID = null;
            while (line != null) {
                if (line.startsWith("data_")) {
                    if (currentID != null) {
                        this.writeID(writer, currentID);
                        ++counter;
                    }
                    currentID = line.substring(5);
                    writer = new StringWriter();
                }
                writer.append(line);
                writer.append(NEWLINE);
                line = buf.readLine();
            }
            this.writeID(writer, currentID);
            ++counter;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("created " + counter + " chemical component files.");
    }

    private void writeID(StringWriter writer, String currentID) throws IOException {
        String localName = DownloadChemCompProvider.getLocalFileName(currentID);
        FileOutputStream outPut = new FileOutputStream(localName);
        GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
        PrintWriter pw = new PrintWriter(gzOutPut);
        pw.print(writer.toString());
        writer.close();
        pw.flush();
        pw.close();
        outPut.close();
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        DownloadChemCompProvider.checkPath();
        recordName = recordName.toUpperCase().trim();
        if (recordName.equals("?")) {
            return null;
        }
        try {
            if (!DownloadChemCompProvider.fileExists(recordName)) {
                this.checkDoFirstInstall();
            }
            if (!DownloadChemCompProvider.fileExists(recordName)) {
                DownloadChemCompProvider.downloadChemCompRecord(recordName);
            }
            String filename = DownloadChemCompProvider.getLocalFileName(recordName);
            InputStreamProvider isp = new InputStreamProvider();
            InputStream inStream = isp.getInputStream(filename);
            SimpleMMcifParser parser = new SimpleMMcifParser();
            ChemCompConsumer consumer = new ChemCompConsumer();
            parser.addMMcifConsumer(consumer);
            parser.parse(new BufferedReader(new InputStreamReader(inStream)));
            ChemicalComponentDictionary dict = consumer.getDictionary();
            ChemComp chemComp = dict.getChemComp(recordName);
            return chemComp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void checkPath() {
        if (path == null || path.equals("") || path.equals("null")) {
            String syspath = System.getProperty("PDB_DIR");
            if (syspath != null && !syspath.equals("") && !syspath.equals("null")) {
                path = syspath;
                return;
            }
            String property = "java.io.tmpdir";
            String tempdir = System.getProperty(property);
            if (!tempdir.endsWith(FILE_SEPARATOR)) {
                tempdir = tempdir + FILE_SEPARATOR;
            }
            System.err.println("you did not set the path in PDBFileReader, don't know where to write the downloaded file to");
            System.err.println("assuming default location is temp directory: " + tempdir);
            path = tempdir;
        }
    }

    public static String getLocalFileName(String recordName) {
        String dir;
        File f2;
        if (protectedIDs.contains(recordName)) {
            recordName = "_" + recordName;
        }
        if (!(f2 = new File(dir = path + CHEM_COMP_CACHE_DIRECTORY + FILE_SEPARATOR)).exists()) {
            System.out.println("creating directory " + f2);
            f2.mkdir();
        }
        String fileName = path + CHEM_COMP_CACHE_DIRECTORY + FILE_SEPARATOR + recordName + ".cif.gz";
        return fileName;
    }

    private static boolean fileExists(String recordName) {
        String fileName = DownloadChemCompProvider.getLocalFileName(recordName);
        File f2 = new File(fileName);
        return f2.exists();
    }

    private static void downloadChemCompRecord(String recordName) {
        String path = System.getProperty("PDB_DIR");
        DownloadChemCompProvider.setPath(path);
        String localName = DownloadChemCompProvider.getLocalFileName(recordName);
        String u = serverLocation + recordName + ".cif";
        try {
            String line;
            URL url = new URL(u);
            HttpURLConnection uconn = HTTPConnectionTools.openHttpURLConnection(url);
            InputStream conn = uconn.getInputStream();
            FileOutputStream outPut = new FileOutputStream(localName);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setPath(String p) {
        if (p == null) {
            return;
        }
        path = p;
        if (!path.endsWith(FILE_SEPARATOR)) {
            path = path + FILE_SEPARATOR;
        }
        System.setProperty("PDB_CACHE_DIR", path);
    }

    private void downloadAllDefinitions() {
        if (loading.get()) {
            System.out.println("Waiting for other thread to install chemical components...");
        }
        if (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Another thread installed the chemical components.");
            return;
        }
        loading.set(true);
        long timeS = System.currentTimeMillis();
        System.out.println("Performing first installation of chemical components.");
        System.out.println("Downloading components.cif.gz ...");
        AllChemCompProvider.checkPath();
        try {
            AllChemCompProvider.downloadFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.split();
        long timeE = System.currentTimeMillis();
        System.out.println("time to install chem comp dictionary: " + (timeE - timeS) / 1000L + " sec.");
        loading.set(false);
    }

    public boolean isDownloadAll() {
        return this.downloadAll;
    }

    public void setDownloadAll(boolean downloadAll) {
        this.downloadAll = downloadAll;
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        NEWLINE = System.getProperty("line.separator");
        CHEM_COMP_CACHE_DIRECTORY = "chemcomp";
        serverLocation = "http://www.rcsb.org/pdb/files/ligand/";
        loading = new AtomicBoolean(false);
        protectedIDs = new ArrayList<String>();
        protectedIDs.add("CON");
        protectedIDs.add("PRN");
        protectedIDs.add("AUX");
        protectedIDs.add("NUL");
    }
}

