/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.edits;

import java.util.ArrayList;
import org.biojava3.core.sequence.BasicSequence;
import org.biojava3.core.sequence.storage.JoiningSequenceReader;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public interface Edit<C extends Compound> {
    public Sequence<C> edit(Sequence<C> var1);

    public static class Substitute<C extends Compound>
    extends AbstractEdit<C> {
        public Substitute(String sequence2, int position) {
            super(position);
            this.setStringSequence(sequence2);
        }

        public Substitute(Sequence<C> sequence2, int position) {
            super(position);
            this.setSequence(sequence2);
        }

        public int getEnd(Sequence<C> sequence2) {
            if (this.getEnd() == -1) {
                int start = this.getStart();
                int length = this.getTargetSequence(sequence2).getLength();
                return start + length - 1;
            }
            return this.getEnd();
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            int start = this.getStart();
            if (start == 1) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(1, start - 1);
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            int end = this.getEnd(editingSequence);
            if (end > editingSequence.getLength()) {
                throw new IndexOutOfBoundsException(end + " is greater than the max index of " + "the editing sequence (" + editingSequence.getLength());
            }
            if (end == editingSequence.getLength()) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(end + 1, editingSequence.getLength());
        }
    }

    public static class Insert<C extends Compound>
    extends AbstractEdit<C> {
        private final boolean singlePosition;

        public Insert(String sequence2, int position) {
            super(position, position);
            this.singlePosition = true;
            this.setStringSequence(sequence2);
        }

        public Insert(Sequence<C> sequence2, int position) {
            super(position, position);
            this.singlePosition = true;
            this.setSequence(sequence2);
        }

        public Insert(String sequence2, int start, int stop2) {
            super(start, stop2);
            this.singlePosition = false;
            this.setStringSequence(sequence2);
        }

        public Insert(Sequence<C> sequence2, int start, int stop2) {
            super(start, stop2);
            this.singlePosition = false;
            this.setSequence(sequence2);
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            if (this.singlePosition) {
                if (this.getStart() == 1) {
                    return this.getEmptySequence(editingSequence);
                }
                if (this.getEnd() == editingSequence.getLength()) {
                    return editingSequence;
                }
                throw new IllegalStateException("Given one position to insert at but this is not the start or end of the Sequence; cannot support this");
            }
            return editingSequence.getSubSequence(1, this.getStart());
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            if (this.singlePosition) {
                if (this.getStart() == 1) {
                    return editingSequence;
                }
                if (this.getEnd() == editingSequence.getLength()) {
                    return this.getEmptySequence(editingSequence);
                }
                throw new IllegalStateException("Given one position to insert at but this is not the start or end of the Sequence; cannot support this");
            }
            return editingSequence.getSubSequence(this.getEnd(), editingSequence.getLength());
        }
    }

    public static class Delete<C extends Compound>
    extends AbstractEdit<C> {
        public Delete(int position) {
            this(position, position);
        }

        public Delete(int start, int end) {
            super(start, end);
            this.setStringSequence("");
        }

        protected int getRealStart() {
            return this.getStart() - 1;
        }

        protected int getRealEnd() {
            return this.getEnd() + 1;
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            int start = this.getRealStart();
            if (start == 0) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(1, start);
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            int end = this.getRealEnd();
            if (end > editingSequence.getLength()) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(end, editingSequence.getLength());
        }
    }

    public static abstract class AbstractEdit<C extends Compound>
    implements Edit<C> {
        private int start = -1;
        private int end = -1;
        private String stringSequence;
        private Sequence<C> sequence;

        protected abstract Sequence<C> getFivePrime(Sequence<C> var1);

        protected abstract Sequence<C> getThreePrime(Sequence<C> var1);

        @Override
        public Sequence<C> edit(Sequence<C> editingSequence) {
            Sequence<C> targetSequence = this.getTargetSequence(editingSequence);
            ArrayList sequences = new ArrayList();
            sequences.add(this.getFivePrime(editingSequence));
            sequences.add(targetSequence);
            sequences.add(this.getThreePrime(editingSequence));
            return new JoiningSequenceReader(sequences);
        }

        public AbstractEdit(int start) {
            this.start = start;
        }

        public AbstractEdit(int start, int end) {
            this.start = start;
            this.end = end;
        }

        protected void setStringSequence(String stringSequence) {
            this.stringSequence = stringSequence;
        }

        protected void setSequence(Sequence<C> sequence2) {
            this.sequence = sequence2;
        }

        public Sequence<C> getTargetSequence(Sequence<C> editingSequence) {
            if (this.sequence == null && this.stringSequence != null) {
                this.sequence = new BasicSequence<C>(this.stringSequence, editingSequence.getCompoundSet());
            }
            return this.sequence;
        }

        protected Sequence<C> getEmptySequence(Sequence<C> editingSequence) {
            return new BasicSequence<C>("", editingSequence.getCompoundSet());
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

