/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.location;

import org.biojava3.core.sequence.location.SimplePoint;
import org.biojava3.core.sequence.location.template.Point;
import org.biojava3.core.util.Equals;
import org.biojava3.core.util.Hashcoder;

public class FuzzyPoint
extends SimplePoint {
    public static final Point.Resolver<FuzzyPoint> MIN_RESOLVER = new Point.Resolver<FuzzyPoint>(){

        @Override
        public int resolve(FuzzyPoint point) {
            return point.getMin();
        }
    };
    public static final Point.Resolver<FuzzyPoint> MAX_RESOLVER = new Point.Resolver<FuzzyPoint>(){

        @Override
        public int resolve(FuzzyPoint point) {
            return point.getMax();
        }
    };
    public static final Point.Resolver<FuzzyPoint> MEAN_RESOLVER = new Point.Resolver<FuzzyPoint>(){

        @Override
        public int resolve(FuzzyPoint point) {
            return (point.getMin() + point.getMax()) / 2;
        }
    };
    private final int min;
    private final int max;
    private final Point.Resolver<FuzzyPoint> resolver;

    public FuzzyPoint(int minPoint, int maxPoint) {
        this(minPoint, maxPoint, MEAN_RESOLVER, false, false);
    }

    public FuzzyPoint(int minPoint, int maxPoint, Point.Resolver<FuzzyPoint> resolver) {
        this(minPoint, maxPoint, resolver, false, false);
    }

    public FuzzyPoint(int minPoint, int maxPoint, Point.Resolver<FuzzyPoint> resolver, boolean unknown, boolean uncertain) {
        this.min = minPoint;
        this.max = maxPoint;
        this.resolver = resolver;
        this.setUncertain(uncertain);
        this.setUnknown(unknown);
        this.setPosition(-1);
    }

    @Override
    public Integer getPosition() {
        if (super.getPosition() == -1) {
            super.setPosition(this.getResolver().resolve(this));
        }
        return super.getPosition();
    }

    protected Integer getMax() {
        return this.max;
    }

    protected Integer getMin() {
        return this.min;
    }

    protected Point.Resolver<FuzzyPoint> getResolver() {
        return this.resolver;
    }

    @Override
    public Point reverse(int length) {
        int revMin = this.reverse(this.getMin(), length);
        int revMax = this.reverse(this.getMax(), length);
        return new FuzzyPoint(revMin, revMax, this.getResolver(), this.isUnknown(), this.isUncertain());
    }

    @Override
    public Point offset(int distance) {
        int offMin = this.getMin() + distance;
        int offMax = this.getMax() + distance;
        return new FuzzyPoint(offMin, offMax, this.getResolver(), this.isUnknown(), this.isUncertain());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals2 = false;
        if (Equals.classEqual(this, obj)) {
            FuzzyPoint p = (FuzzyPoint)obj;
            equals2 = Equals.equal(this.getMin(), p.getMin()) && Equals.equal(this.getMax(), p.getMax()) && Equals.equal(this.isUnknown(), p.isUnknown()) && Equals.equal(this.isUncertain(), p.isUncertain());
        }
        return equals2;
    }

    @Override
    public int hashCode() {
        int r = 9;
        r = Hashcoder.hash(r, this.getMin());
        r = Hashcoder.hash(r, this.getMax());
        r = Hashcoder.hash(r, this.isUncertain());
        r = Hashcoder.hash(r, this.isUnknown());
        return r;
    }

    @Override
    public int compareTo(Point point) {
        if (FuzzyPoint.class.isAssignableFrom(point.getClass())) {
            FuzzyPoint fuzzy = (FuzzyPoint)point;
            int minComparison = this.getMin().compareTo(fuzzy.getMin());
            if (minComparison != 0) {
                return minComparison;
            }
            return this.getMax().compareTo(fuzzy.getMax());
        }
        return super.compareTo(point);
    }
}

