/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneOntology;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.geneOntology.GoTerms;

public class GoTerm
implements Comparable<GoTerm>,
Iterable<String>,
Serializable {
    public static boolean debug = false;
    private static final long serialVersionUID = 1L;
    GoTerms goTerms;
    String nameSpace;
    String acc;
    String description;
    int level;
    int maxRank;
    int rankedSymbols;
    long rankSum;
    HashSet<GoTerm> childs;
    HashSet<GoTerm> parents;
    HashSet<String> symbolIdSet;
    HashSet<String> interestingSymbolIdSet;

    public GoTerm(List<GoTerm> goTermList, GoTerms goTerms) {
        this.goTerms = goTerms;
        this.level = -1;
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.rankedSymbols = Integer.MIN_VALUE;
        this.interestingSymbolIdSet = new HashSet();
        this.symbolIdSet = new HashSet();
        this.childs = new HashSet();
        this.parents = new HashSet();
        String accAll = "";
        this.nameSpace = null;
        for (GoTerm goTerm : goTermList) {
            this.interestingSymbolIdSet.addAll(goTerm.interestingSymbolIdSet);
            this.symbolIdSet.addAll(goTerm.symbolIdSet);
            accAll = accAll + goTerm.getAcc() + " ";
            if (this.nameSpace != null) continue;
            this.nameSpace = goTerm.nameSpace;
        }
        this.acc = accAll;
        this.description = accAll;
    }

    public GoTerm(String acc, GoTerms goTerms, String nameSpace, String description) {
        this.goTerms = goTerms;
        this.acc = acc;
        this.nameSpace = nameSpace;
        this.description = description;
        this.level = -1;
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.rankedSymbols = Integer.MIN_VALUE;
        this.interestingSymbolIdSet = new HashSet();
        this.symbolIdSet = new HashSet();
        this.childs = new HashSet();
        this.parents = new HashSet();
    }

    public void addChild(GoTerm childGoTerm) {
        this.childs.add(childGoTerm);
        childGoTerm.addParent(this);
    }

    public void addInterestingSymbolId(String symbolId) {
        if (!this.symbolIdSet.contains(symbolId)) {
            throw new RuntimeException("Symbol '" + symbolId + "' cannod be added as 'interesting' to goTerm '" + this + "' (it does not belong to the set)");
        }
        this.interestingSymbolIdSet.add(symbolId);
    }

    private void addParent(GoTerm goTerm) {
        this.parents.add(goTerm);
    }

    public void addSymbolId(String symbolId) {
        this.symbolIdSet.add(symbolId);
    }

    public void addSymbolsFromChilds(GoTerm goTerm) {
        for (String symbolId : this.symbolIdSet) {
            goTerm.addSymbolId(symbolId);
        }
        for (String symbolId : this.interestingSymbolIdSet) {
            goTerm.addInterestingSymbolId(symbolId);
        }
        for (GoTerm child : this.childs) {
            child.addSymbolsFromChilds(goTerm);
        }
    }

    @Override
    public int compareTo(GoTerm goTerm) {
        return this.acc.compareTo(goTerm.acc);
    }

    public String getAcc() {
        return this.acc;
    }

    public HashSet<GoTerm> getChilds() {
        return this.childs;
    }

    public String getDescription() {
        return this.description;
    }

    public GoTerm getFirstChild() {
        return this.childs.iterator().next();
    }

    public GoTerm getFirstParent() {
        return this.parents.iterator().next();
    }

    public GoTerms getGoTerms() {
        return this.goTerms;
    }

    public HashSet<String> getInterestingSymbolIdSet() {
        return this.interestingSymbolIdSet;
    }

    public int getInterestingSymbolIdsSize() {
        return this.interestingSymbolIdSet.size();
    }

    public int getLevel() {
        if (this.level < 0) {
            this.level = 0;
            for (GoTerm parent : this.parents) {
                this.level = Math.max(this.level, parent.getLevel() + 1);
            }
        }
        return this.level;
    }

    public int getMaxRank() {
        return this.maxRank;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public HashSet<GoTerm> getParents() {
        return this.parents;
    }

    public int getRankedSymbols() {
        return this.rankedSymbols;
    }

    public Set<String> getSymbolIdSet() {
        return this.symbolIdSet;
    }

    public int getTotalCount() {
        return this.symbolIdSet.size();
    }

    public void intersection(GoTerm goTerm) {
        if (this.symbolIdSet != null) {
            this.symbolIdSet.retainAll(goTerm.symbolIdSet);
        }
        if (this.interestingSymbolIdSet != null) {
            this.interestingSymbolIdSet.retainAll(goTerm.interestingSymbolIdSet);
        }
    }

    public boolean isLeave() {
        return this.childs == null || this.childs.size() <= 0;
    }

    @Override
    public Iterator<String> iterator() {
        return this.symbolIdSet.iterator();
    }

    void resetInterestingSymbolIdSet() {
        if (this.interestingSymbolIdSet.size() > 0) {
            this.interestingSymbolIdSet = new HashSet();
        }
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.rankedSymbols = Integer.MIN_VALUE;
    }

    public GoTerm rootNode() {
        if (this.parents == null || this.parents.isEmpty()) {
            return this;
        }
        return this.parents.iterator().next().rootNode();
    }

    public void setAcc(String go) {
        this.acc = go;
    }

    public void setChilds(HashSet<GoTerm> childs) {
        this.childs = childs;
    }

    public void setGenesSet(HashSet<String> genesSet) {
        this.symbolIdSet = genesSet;
    }

    public void setGoTerms(GoTerms goTerms) {
        this.goTerms = goTerms;
    }

    public void setInterestingSymbolIdSet(HashSet<String> interestingSymbolIdSet) {
        this.interestingSymbolIdSet = interestingSymbolIdSet;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setMaxRank(int maxRank) {
        this.maxRank = maxRank;
    }

    public void setMinus(GoTerm goTerm) {
        if (this.symbolIdSet != null) {
            this.symbolIdSet.removeAll(goTerm.symbolIdSet);
        }
        if (this.interestingSymbolIdSet != null) {
            this.interestingSymbolIdSet.removeAll(goTerm.interestingSymbolIdSet);
        }
    }

    public void setNameSpace(String goTermType) {
        this.nameSpace = goTermType;
    }

    public void setParents(HashSet<GoTerm> parents) {
        this.parents = parents;
    }

    public void setRankedSymbols(int rankedSymbols) {
        this.rankedSymbols = rankedSymbols;
    }

    public void setRankSum(int rankSum) {
        this.rankSum = rankSum;
    }

    public void setSescription(String description) {
        this.description = description;
    }

    public void setSymbolIdSet(HashSet<String> symbolIdSet) {
        this.symbolIdSet = symbolIdSet;
    }

    public String toString() {
        return this.acc;
    }

    public String toStringAll() {
        return this.toStringAll(true);
    }

    public String toStringAll(boolean showSymbols) {
        StringBuffer ig = new StringBuffer();
        StringBuffer ids = new StringBuffer();
        LinkedList<String> is = new LinkedList<String>(this.interestingSymbolIdSet);
        Collections.sort(is);
        for (String string2 : is) {
            ig.append(string2 + " ");
        }
        LinkedList<String> ss = new LinkedList<String>(this.symbolIdSet);
        Collections.sort(ss);
        for (String id : ss) {
            if (this.interestingSymbolIdSet.contains(id)) continue;
            ids.append(id + " ");
        }
        LinkedList<GoTerm> linkedList = new LinkedList<GoTerm>(this.childs);
        Collections.sort(linkedList);
        LinkedList<GoTerm> sparents = new LinkedList<GoTerm>(this.parents);
        Collections.sort(sparents);
        String out = this.acc + "\tlev:" + this.level + "\tinteresting:" + this.getInterestingSymbolIdsSize() + "\ttotal:" + this.getTotalCount();
        out = out + "\t" + this.nameSpace + "\t" + this.description;
        if (showSymbols) {
            out = out + "\t[ " + ig + "]\t" + ids;
        }
        out = out + "\tChilds: " + linkedList + "\tParents: " + sparents;
        return out;
    }

    public void union(GoTerm goTerm) {
        if (this.symbolIdSet != null) {
            this.symbolIdSet.addAll(goTerm.symbolIdSet);
        }
        if (this.interestingSymbolIdSet != null) {
            this.interestingSymbolIdSet.addAll(goTerm.interestingSymbolIdSet);
        }
    }
}

