/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.SpliceSite;
import org.snpeff.snpEffect.EffectType;

public class SpliceSiteAcceptor
extends SpliceSite {
    private static final long serialVersionUID = -7416687954435361328L;

    public SpliceSiteAcceptor() {
        this.type = EffectType.SPLICE_SITE_ACCEPTOR;
    }

    public SpliceSiteAcceptor(Intron parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.SPLICE_SITE_ACCEPTOR;
    }

    @Override
    public boolean intersectsCoreSpliceSite(Marker marker) {
        int coreStart;
        int coreEnd;
        if (this.size() <= 2) {
            return true;
        }
        if (!this.getChromosomeName().equals(marker.getChromosomeName())) {
            return false;
        }
        if (this.isStrandPlus()) {
            coreEnd = this.end;
            coreStart = coreEnd - 2 + 1;
        } else {
            coreStart = this.start;
            coreEnd = coreStart + 2 - 1;
        }
        return marker.intersects(coreStart, coreEnd);
    }
}

