/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;

public class TestCasesStructuralInv
extends TestCasesBase {
    EffFormatVersion formatVersion = EffFormatVersion.FORMAT_ANN;

    Set<String> arrayToSet(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array != null) {
            for (String h : array) {
                set.add(h);
            }
        }
        return set;
    }

    protected void checkEffects(Variant variant, EffectType[] expEffs, String[] expHgvsp, String[] expHgvsc, VariantEffect.EffectImpact expectedImpact, String[] expAnns) {
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, expAnns, null);
    }

    protected void checkEffects(Variant variant, EffectType[] expEffs, String[] expHgvsp, String[] expHgvsc, VariantEffect.EffectImpact expectedImpact, String[] expAnns, Gene[] genesToAdd) {
        HashSet<EffectType> expectedEffs = new HashSet<EffectType>();
        if (expEffs != null) {
            for (EffectType et : expEffs) {
                expectedEffs.add(et);
            }
        }
        Set<String> expectedHgvsp = this.arrayToSet(expHgvsp);
        Set<String> expectedHgvsc = this.arrayToSet(expHgvsc);
        Set<String> expectedAnns = this.arrayToSet(expAnns);
        this.initSnpEffPredictor(genesToAdd);
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
            for (Gene g : this.genome.getGenes()) {
                Gpr.debug("\tGene: " + g.toStr());
                for (Transcript tr : g) {
                    Gpr.debug(tr + "\n\n" + tr.toStringAsciiArt(true));
                }
            }
        }
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        if (this.verbose) {
            Gpr.debug("VariantEffects: " + effects);
        }
        Assert.assertEquals(true, effects.size() >= 1);
        HashSet<EffectType> effs = new HashSet<EffectType>();
        HashSet<String> hgvscs = new HashSet<String>();
        HashSet<String> hgvsps = new HashSet<String>();
        HashSet<String> anns = new HashSet<String>();
        boolean impactOk = false;
        for (VariantEffect varEff : effects) {
            effs.addAll(varEff.getEffectTypes());
            HgvsDna hgvsc = new HgvsDna(varEff);
            String hgvsDna = hgvsc.toString();
            hgvscs.add(hgvsDna);
            HgvsProtein hgvsp = new HgvsProtein(varEff);
            String hgvsProt = hgvsp.toString();
            hgvsps.add(hgvsProt);
            impactOk |= varEff.getEffectImpact() == expectedImpact;
            VcfEffect vcfEffect = new VcfEffect(varEff, this.formatVersion);
            String annField = vcfEffect.toString();
            anns.add(annField);
            if (!this.verbose) continue;
            Gpr.debug("Effect: " + varEff.toStr() + "\n\tHGVS.c: " + hgvsDna + "\n\tHGVS.p: " + hgvsProt + "\n\tANN   : " + annField);
        }
        Assert.assertTrue("Effects do not match\n\tExpected : " + expectedEffs + "\n\tFound    : " + effs, effs.containsAll(expectedEffs));
        Assert.assertTrue("Effect impact '" + (Object)((Object)expectedImpact) + "' not found", impactOk);
        Assert.assertTrue("HGVS.c do not match\n\tExpected : " + expectedHgvsc + "\n\tFound    : " + hgvscs, hgvscs.containsAll(expectedHgvsc));
        Assert.assertTrue("HGVS.p do not match\n\tExpected : " + expectedHgvsp + "\n\tFound    : " + hgvsps, hgvsps.containsAll(expectedHgvsp));
        Assert.assertTrue("ANN fields do not match\n\tExpected : " + expectedAnns + "\n\tFound    : " + anns, anns.containsAll(expectedAnns));
    }

    @Override
    protected void init() {
        this.randSeed = 20151205;
        this.genomeName = "testCase";
        this.addUtrs = false;
        this.onlyPlusStrand = true;
        this.onlyMinusStrand = false;
        this.numGenes = 2;
        this.maxGeneLen = 1000;
        this.maxTranscripts = 1;
        this.maxExons = 5;
        this.minExons = 2;
        this.shiftHgvs = false;
        this.initRand();
    }

    @Test
    public void test01_invGene() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 950, 1250, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_INVERSION};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODERATE;
        this.checkEffects(variant, expEffs, null, null, expectedImpact, null);
    }

    @Test
    public void test01_invTr() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 950, 1200, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.TRANSCRIPT_INVERSION};
        String[] expHgvsc = new String[]{"c.-7_*43inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODERATE;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1100, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_INVERSION};
        String[] expHgvsc = new String[]{"c.33-5_45+43inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1160, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_INVERSION};
        String[] expHgvsc = new String[]{"c.33-5_*3inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1050, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_INVERSION_PARTIAL};
        String[] expHgvsc = new String[]{"c.33-5_38inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test05() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 1150, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_INVERSION_PARTIAL};
        String[] expHgvsc = new String[]{"c.38_48inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test06() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 2160, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_INVERSION};
        String[] expHgvsc = new String[]{"n.1051_2161inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODERATE;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test07() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1100, 2075, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"n.1101_2076inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        String[] expAnns = new String[]{"|bidirectional_gene_fusion|HIGH|geneName1&geneName2|geneId1&geneId2|gene_variant|geneId1|||n.1101_2076inv||||||"};
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, expAnns);
    }

    @Test
    public void test08() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 2120, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"n.1051_2121inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        String[] expAnns = new String[]{"|bidirectional_gene_fusion|HIGH|geneName1&geneName2|geneId1&geneId2|gene_variant|geneId1|||n.1051_2121inv||||||"};
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, expAnns);
    }

    @Test
    public void test09() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 991, 1020, "");
        variant.setVariantType(Variant.VariantType.INV);
        EffectType[] expEffs = new EffectType[]{EffectType.INTRON};
        String[] expHgvsc = new String[]{"c.32+3_33-25inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODIFIER;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test10() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 2120, "");
        variant.setVariantType(Variant.VariantType.INV);
        boolean strandMinus = false;
        Gene gene = new Gene(this.chromosome, 2000, 2200, strandMinus, "geneId3", "geneName3", BioType.protein_coding);
        Transcript tr = new Transcript(gene, 2000, 2200, strandMinus, "tr3");
        Exon ex = new Exon(tr, 2000, 2200, strandMinus, "ex1_tr3", 1);
        String seq2 = this.chromoSequence.substring(ex.getStart(), ex.getEnd() - 1);
        ex.setSequence(strandMinus ? GprSeq.reverseWc(seq2) : seq2);
        tr.add(ex);
        gene.add(tr);
        Gene[] genesToAdd = new Gene[]{gene};
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_FUSION_REVERESE};
        String[] expHgvsc = new String[]{"n.1051_2121inv"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        String[] expAnns = new String[]{"|bidirectional_gene_fusion|HIGH|geneName1&geneName2|geneId1&geneId2|gene_variant|geneId1|||n.1051_2121inv||||||", "|bidirectional_gene_fusion|HIGH|geneName1&geneName3|geneId1&geneId3|gene_variant|geneId1|||n.1051_2121inv||||||"};
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, expAnns, genesToAdd);
    }
}

