/*
xmms-ctl - controls XMMS via the commandline

Copyright (C) 2015 - Marco "eukara" Hladik

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. 

E-Mail: eukos@oldtimes-software.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <xmms/xmmsctrl.h>

static int xmms_session = 0;

int check_parameter (char *parm, int com_argc, char* com_argv[])
{
	int i;

	for (i=1 ; i<com_argc ; i++)
	{
		if (!com_argv[i])
			continue;
		if (!strcmp (parm,com_argv[i]))
			return i;
	}
	return 0;
}

int main(int argc, char *argv[])
{
	int xmms_track_set;
	int xmms_volume_set;
	int i;

	if(check_parameter("-quit", argc, argv))
	{
		xmms_remote_quit(xmms_session);
		return 0;
	}
	if(check_parameter("-play", argc, argv))
		xmms_remote_play(xmms_session);
	if(check_parameter("-pause", argc, argv))
		xmms_remote_pause(xmms_session);
	if(check_parameter("-stop", argc, argv))
		xmms_remote_stop(xmms_session);
	if(check_parameter("-eject", argc, argv))
		xmms_remote_eject(xmms_session);
	if(check_parameter("-track-next", argc, argv))
		xmms_remote_playlist_next(xmms_session);
	if(check_parameter("-track-previous", argc, argv))
		xmms_remote_playlist_prev(xmms_session);
	if(check_parameter("-get-title", argc, argv))
		printf("%s\n", xmms_remote_get_playlist_title(xmms_session, xmms_remote_get_playlist_pos(xmms_session)));
	if(xmms_track_set = check_parameter("-get-track", argc, argv)){
		printf("%i\n", xmms_remote_get_playlist_pos(xmms_session)); return xmms_remote_get_playlist_pos(xmms_session);}
	if(check_parameter("-get-repeat", argc, argv)){
		printf("%i\n", (int)xmms_remote_is_repeat(xmms_session)); return (int)xmms_remote_is_repeat(xmms_session);}
	if(check_parameter("-set-repeat", argc, argv))
		xmms_remote_toggle_repeat(xmms_session);
	if(check_parameter("-get-shuffle", argc, argv)){
		printf("%i\n", (int)xmms_remote_is_shuffle(xmms_session)); return (int)xmms_remote_is_shuffle(xmms_session);}
	if(check_parameter("-set-shuffle", argc, argv))
		xmms_remote_toggle_shuffle(xmms_session);
	if(check_parameter("-get-advance", argc, argv)){
		printf("%i\n", (int)xmms_remote_is_advance(xmms_session)); return (int)xmms_remote_is_advance(xmms_session);}
	if(check_parameter("-set-advance", argc, argv))
		xmms_remote_toggle_advance(xmms_session);
	if(check_parameter("-get-playlist", argc, argv))
		for(i = 0; i < xmms_remote_get_playlist_length(xmms_session); i++)
			printf("%s\n", xmms_remote_get_playlist_title(xmms_session, i));
	if(xmms_track_set = check_parameter("-set-track", argc, argv))
		xmms_remote_set_playlist_pos(xmms_session, atoi(argv[xmms_track_set + 1]));
	if(check_parameter("-get-volume", argc, argv))
		printf("%i\n", xmms_remote_get_main_volume(xmms_session));
	if(xmms_volume_set = check_parameter("-set-volume", argc, argv))
		xmms_remote_set_main_volume(xmms_session, atoi(argv[xmms_track_set + 1]));
		
	if(!(argc>1))
		printf("########\nXMMS-CTL\n########\n\nHELP:\n-quit = kills XMMS\n-play = plays the current song\n-pause = pauses the current song\n-stop = stops the current song\n-eject = ejects the disk drive\n-track-next = select the next track\n-track-previous = select the previous track\n-get-title = get the author - title of the current song\n-get-track = get the tracknumber of the current playlist\n-get-repeat = returns the repeat mode\n-set-repeat = toggle the repeat mode\n-get-shuffle = returns the shuffle mode\n-set-shuffle = toggles the shuffle mode\n-get-advance = returns the advance mode\n-set-advance = toggles the advance mode\n-get-playlist = returns all songs in the playlist\n-set-track VALUE = sets track to VALUE in playlist\n-get-volume = returns the global volume\n-set-volume = sets the global volume (0-100)\n");

	return 0;
}
