/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.HTMLElementTerminatingTagNameSets;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;
    static final StartTag NOT_CACHED = (StartTag)Tag.NOT_CACHED;

    StartTag(Source source, int begin, int end, StartTagType startTagType, String name, Attributes attributes) {
        super(source, begin, end, name);
        this.attributes = attributes;
        this.startTagType = startTagType;
        if (attributes != null) {
            attributes.setStartTag(this);
        }
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    @Override
    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.getEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.logger.isErrorEnabled() && !this.element.equals(endTag.element)) {
                    this.source.logger.error(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuilder(200).append("End tag ").append(endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    @Override
    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes == null ? null : this.attributes.getValue(attributeName);
    }

    @Override
    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int maxErrorCount) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int maxEnd = this.end - this.startTagType.getClosingDelimiter().length();
        int attributesBegin = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(attributesBegin))) {
            if (++attributesBegin != maxEnd) continue;
            return null;
        }
        Attributes attributes = Attributes.construct(this.source, this.begin, attributesBegin, maxEnd, this.startTagType, this.name, maxErrorCount);
        if (attributes != null) {
            attributes.setStartTag(this);
        }
        return attributes;
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    @Override
    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean toXHTML) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        if (toXHTML && this.startTagType == StartTagType.NORMAL) {
            sb.append(this.name);
        } else {
            int i;
            int nameSegmentEnd = i + this.name.length();
            for (i = this.begin + this.startTagType.startDelimiterPrefix.length(); i < nameSegmentEnd; ++i) {
                sb.append(this.source.charAt(i));
            }
        }
        try {
            this.attributes.appendTidy(sb, this.getNextTag());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            sb.append(" /");
        }
        sb.append(this.startTagType.getClosingDelimiter());
        return sb.toString();
    }

    public static String generateHTML(String tagName, Map<String, String> attributesMap, boolean emptyElementTag) {
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(tagName);
        try {
            Attributes.appendHTML(sb, attributesMap);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (emptyElementTag) {
            sb.append(" />");
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        this.appendDebugTag(sb);
        sb.append(' ');
        this.appendDebugTagType(sb);
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    StringBuilder appendDebugTag(StringBuilder sb) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            sb.append(this);
        } else {
            sb.append('<').append(this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                sb.append('/');
            }
            sb.append(this.startTagType.getClosingDelimiter());
        }
        return sb;
    }

    StringBuilder appendDebugTagType(StringBuilder sb) {
        if (this.startTagType != StartTagType.NORMAL) {
            sb.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return sb;
    }

    private EndTag getEndTagInternal() {
        EndTag nextEndTag;
        boolean checkForEmptyElementTag = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            boolean bl = checkForEmptyElementTag = !HTMLElements.isClosingSlashIgnored(this.name);
            if (checkForEmptyElementTag && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            HTMLElementTerminatingTagNameSets terminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(this.name);
            if (terminatingTagNameSets != null) {
                return this.getOptionalEndTag(terminatingTagNameSets);
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((nextEndTag = this.source.getNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag nextStartTag = this.source.getNextStartTag(this.end, this.name);
                if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
                    return nextEndTag;
                }
                if (this.source.logger.isErrorEnabled()) {
                    this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, nextStartTag.begin, nextStartTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] getResult = this.getEndTag(nextEndTag, checkForEmptyElementTag, Tag.isXMLName(this.name));
            if (getResult != null) {
                return (EndTag)getResult[0];
            }
        }
        if (this.source.logger.isErrorEnabled()) {
            this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag getOptionalEndTag(HTMLElementTerminatingTagNameSets terminatingTagNameSets) {
        Tag tag;
        int pos = this.end;
        while (pos < this.source.end && (tag = Tag.getNextTag(this.source, pos)) != null) {
            Set<String> terminatingTagNameSet;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                terminatingTagNameSet = terminatingTagNameSets.NonterminatingElementNameSet;
                if (terminatingTagNameSet != null && terminatingTagNameSet.contains(tag.name)) {
                    Element nonterminatingElement = ((StartTag)tag).getElement();
                    pos = nonterminatingElement.end;
                    continue;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (terminatingTagNameSet != null && terminatingTagNameSet.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            pos = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static String getStartDelimiter(String searchName) {
        if (searchName.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String startDelimiter = "<" + searchName;
        if (startDelimiter.charAt("<".length()) == '/') {
            throw new IllegalArgumentException("searchName argument \"" + searchName + "\" must not start with '/'");
        }
        return startDelimiter;
    }

    static StartTag getPrevious(Source source, int pos, String searchName, StartTagType searchStartTagType) {
        return StartTag.getPrevious(source, pos, searchName, searchStartTagType, searchStartTagType == StartTagType.NORMAL ? Tag.isXMLName(searchName) : true);
    }

    static StartTag getPrevious(Source source, int pos, String searchName, StartTagType searchStartTagType, boolean isXMLTagName) {
        if (searchName == null) {
            return (StartTag)source.getPreviousTag(pos, searchStartTagType);
        }
        if (source.wasFullSequentialParseCalled() && isXMLTagName) {
            StartTag startTag = (StartTag)Tag.getPreviousTag(source, pos, searchStartTagType);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.name.equals(searchName)) {
                    return startTag;
                }
                if (startTag.name.startsWith(searchName) && startTag.isPartialNameSearchMatch(searchName)) {
                    return startTag;
                }
                if (startTag.name.length() < searchName.length() && source.getParseText().containsAt(searchName, startTag.begin + searchStartTagType.startDelimiterPrefix.length())) {
                    return startTag;
                }
                startTag = (StartTag)startTag.getPreviousTag(searchStartTagType);
            }
        }
        String startDelimiter = StartTag.getStartDelimiter(searchName);
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf(startDelimiter, begin)) == -1) {
                return null;
            }
            StartTag startTag = (StartTag)Tag.getTagAt(source, begin, false);
            if (startTag == null || searchStartTagType != startTag.getStartTagType() && (searchStartTagType != StartTagType.NORMAL || isXMLTagName || !startTag.isUnregistered()) || startTag.getName().length() > searchName.length() && !startTag.isPartialNameSearchMatch(searchName)) continue;
            return startTag;
        } while ((begin -= 2) >= 0);
        return null;
    }

    final boolean isPartialNameSearchMatch(String searchName) {
        char lastSearchNameChar = searchName.charAt(searchName.length() - 1);
        return lastSearchNameChar == ':' || !StartTag.isXMLNameChar(lastSearchNameChar);
    }

    static StartTag getNext(Source source, int pos, String searchName, StartTagType searchStartTagType) {
        return StartTag.getNext(source, pos, searchName, searchStartTagType, searchStartTagType == StartTagType.NORMAL ? Tag.isXMLName(searchName) : true);
    }

    static StartTag getNext(Source source, int pos, String searchName, StartTagType searchStartTagType, boolean isXMLTagName) {
        if (searchName == null) {
            return (StartTag)source.getNextTag(pos, searchStartTagType);
        }
        if (source.wasFullSequentialParseCalled() && isXMLTagName) {
            StartTag startTag = (StartTag)Tag.getNextTag(source, pos, searchStartTagType);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.name.equals(searchName)) {
                    return startTag;
                }
                if (startTag.name.startsWith(searchName) && startTag.isPartialNameSearchMatch(searchName)) {
                    return startTag;
                }
                if (startTag.name.length() < searchName.length() && source.getParseText().containsAt(searchName, startTag.begin + searchStartTagType.startDelimiterPrefix.length())) {
                    return startTag;
                }
                startTag = (StartTag)startTag.getNextTag(searchStartTagType);
            }
        }
        String startDelimiter = StartTag.getStartDelimiter(searchName);
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf(startDelimiter, begin)) == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, begin, false);
                if (startTag == null || searchStartTagType != startTag.getStartTagType() && (searchStartTagType != StartTagType.NORMAL || isXMLTagName || !startTag.isUnregistered()) || startTag.getName().length() > searchName.length() && !startTag.isPartialNameSearchMatch(searchName)) continue;
                return startTag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static StartTag getPrevious(Source source, int pos) {
        Tag tag = Tag.getPreviousTag(source, pos);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getPreviousStartTag();
    }

    static StartTag getNext(Source source, int pos) {
        Tag tag = Tag.getNextTag(source, pos);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getNextStartTag();
    }

    static StartTag getNext(Source source, int pos, String attributeName, String value, boolean valueCaseSensitive) {
        if (value == null || attributeName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag = source.getNextStartTag(pos);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.hasAttribute(attributeName, value, valueCaseSensitive)) {
                    return startTag;
                }
                startTag = startTag.getNextStartTag();
            }
        }
        String searchString = value.length() >= 3 || value.length() > 0 && attributeName.length() < 3 ? value : attributeName;
        ParseText parseText = source.getParseText();
        int searchPos = pos;
        while (searchPos < source.end) {
            StartTag startTag;
            searchPos = parseText.indexOf(searchString.toLowerCase(), searchPos);
            if (searchPos == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(searchPos);
            if (tag == null || !(tag instanceof StartTag)) {
                ++searchPos;
                continue;
            }
            if (tag.begin >= pos && (startTag = (StartTag)tag).hasAttribute(attributeName, value, valueCaseSensitive)) {
                return startTag;
            }
            searchPos = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String attributeName, String value, boolean valueCaseSensitive) {
        if (this.attributes == null) {
            return false;
        }
        String attributeValue = this.attributes.getValue(attributeName);
        if (attributeValue == null) {
            return false;
        }
        if (value.equals(attributeValue)) {
            return true;
        }
        if ((!valueCaseSensitive || this.source.logger.isWarnEnabled()) && value.equalsIgnoreCase(attributeValue)) {
            if (!valueCaseSensitive) {
                return true;
            }
            if (this.source.logger.isWarnEnabled()) {
                this.source.logger.warn(this.getRowColumnVector().appendTo(new StringBuilder(200)).append(": StartTag with attribute ").append(attributeName).append("=\"").append(attributeValue).append("\" ignored during search because its case does not match search value \"").append(value).append('\"').toString());
            }
        }
        return false;
    }

    static StartTag getNext(Source source, int pos, String attributeName, Pattern valueRegexPattern) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag = source.getNextStartTag(pos);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.hasAttribute(attributeName, valueRegexPattern)) {
                    return startTag;
                }
                startTag = startTag.getNextStartTag();
            }
        }
        String searchString = attributeName;
        ParseText parseText = source.getParseText();
        int searchPos = pos;
        while (searchPos < source.end) {
            StartTag startTag;
            searchPos = parseText.indexOf(searchString.toLowerCase(), searchPos);
            if (searchPos == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(searchPos);
            if (tag == null || !(tag instanceof StartTag)) {
                ++searchPos;
                continue;
            }
            if (tag.begin >= pos && (startTag = (StartTag)tag).hasAttribute(attributeName, valueRegexPattern)) {
                return startTag;
            }
            searchPos = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String attributeName, Pattern valueRegexPattern) {
        if (this.attributes == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(attributeName);
        if (attribute == null) {
            return false;
        }
        if (valueRegexPattern == null) {
            return true;
        }
        String attributeValue = attribute.getValue();
        return attributeValue != null && valueRegexPattern.matcher(attributeValue).matches();
    }

    private Segment[] getEndTag(EndTag nextEndTag, boolean checkForEmptyElementTag, boolean isXMLTagName) {
        assert (nextEndTag != null);
        StartTag nextStartTag = StartTag.getNext(this.source, this.end, this.name, this.startTagType, isXMLTagName);
        if (checkForEmptyElementTag) {
            while (nextStartTag != null && nextStartTag.isSyntacticalEmptyElementTag()) {
                nextStartTag = StartTag.getNext(this.source, nextStartTag.end, this.name, this.startTagType, isXMLTagName);
            }
        }
        return this.getEndTag(this.end, nextStartTag, nextEndTag, checkForEmptyElementTag, isXMLTagName);
    }

    private Segment[] getEndTag(int afterPos, StartTag nextStartTag, EndTag nextEndTag, boolean checkForEmptyElementTag, boolean isXMLTagName) {
        if (nextEndTag == null) {
            return null;
        }
        Segment[] returnArray = new Segment[]{nextEndTag, nextStartTag};
        if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
            return returnArray;
        }
        Segment[] getResult = nextStartTag.getEndTag(nextEndTag, checkForEmptyElementTag, isXMLTagName);
        if (getResult == null) {
            return null;
        }
        EndTag nextStartTagsEndTag = (EndTag)getResult[0];
        EndTag nextNextEndTag = EndTag.getNext(this.source, nextStartTagsEndTag.end, nextEndTag.getName(), nextEndTag.getEndTagType());
        return this.getEndTag(nextStartTagsEndTag.end, (StartTag)getResult[1], nextNextEndTag, checkForEmptyElementTag, isXMLTagName);
    }
}

