/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.BasicLogFormatter;
import net.htmlparser.jericho.Logger;

public class WriterLogger
implements Logger {
    private final Writer writer;
    private final String name;
    private boolean errorEnabled = true;
    private boolean warnEnabled = true;
    private boolean infoEnabled = true;
    private boolean debugEnabled = true;

    public WriterLogger(Writer writer) {
        this(writer, "net.htmlparser.jericho");
    }

    public WriterLogger(Writer writer, String name) {
        this.writer = writer;
        this.name = name;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log("ERROR", message);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log("WARN", message);
        }
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log("INFO", message);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log("DEBUG", message);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public void setErrorEnabled(boolean errorEnabled) {
        this.errorEnabled = errorEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void setWarnEnabled(boolean warnEnabled) {
        this.warnEnabled = warnEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    protected void log(String level, String message) {
        try {
            this.writer.write(BasicLogFormatter.format(level, message, this.name));
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

