/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttrColor;
import org.eclipse.swt.internal.gtk.PangoAttrInt;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    boolean inComposition;

    IME() {
    }

    public IME(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] result = new int[this.ranges.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.ranges[i] + this.startOffset;
        }
        return result;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] result = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, result, 0, this.styles.length);
        return result;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    @Override
    int gtk_button_press_event(int widget, int event) {
        if (!this.isInlineEnabled()) {
            return 0;
        }
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            GTK.gtk_im_context_reset(imHandle);
        }
        return 0;
    }

    @Override
    int gtk_commit(int imcontext, int textPtr) {
        int length;
        if (!this.isInlineEnabled()) {
            return 0;
        }
        boolean doit = true;
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        if (textPtr != 0 && this.inComposition && (length = C.strlen(textPtr)) != 0) {
            byte[] buffer = new byte[length];
            C.memmove(buffer, textPtr, length);
            char[] chars = Converter.mbcsToWcs(buffer);
            Event event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = this.startOffset + this.text.length();
            this.text = chars != null ? new String(chars) : "";
            event.text = this.text;
            this.commitCount = this.text.length();
            this.sendEvent(43, event);
            doit = event.doit;
            this.text = "";
            this.startOffset = -1;
            this.commitCount = 0;
        }
        this.inComposition = false;
        return doit ? 0 : 1;
    }

    @Override
    int gtk_preedit_changed(int imcontext) {
        if (!this.isInlineEnabled()) {
            return 0;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        int imHandle = this.imHandle();
        int[] preeditString = new int[1];
        int[] pangoAttrs = new int[1];
        int[] cursorPos = new int[1];
        GTK.gtk_im_context_get_preedit_string(imHandle, preeditString, pangoAttrs, cursorPos);
        this.caretOffset = cursorPos[0];
        char[] chars = null;
        if (preeditString[0] != 0) {
            int length = C.strlen(preeditString[0]);
            byte[] buffer = new byte[length];
            C.memmove(buffer, preeditString[0], length);
            chars = Converter.mbcsToWcs(buffer);
            if (pangoAttrs[0] != 0) {
                int count = 0;
                int iterator = OS.pango_attr_list_get_iterator(pangoAttrs[0]);
                while (OS.pango_attr_iterator_next(iterator)) {
                    ++count;
                }
                OS.pango_attr_iterator_destroy(iterator);
                this.ranges = new int[count * 2];
                this.styles = new TextStyle[count];
                iterator = OS.pango_attr_list_get_iterator(pangoAttrs[0]);
                PangoAttrColor attrColor = new PangoAttrColor();
                PangoAttrInt attrInt = new PangoAttrInt();
                int[] start = new int[1];
                int[] end = new int[1];
                for (int i = 0; i < count; ++i) {
                    GdkColor color;
                    GdkRGBA rgba;
                    OS.pango_attr_iterator_range(iterator, start, end);
                    this.ranges[i * 2] = OS.g_utf16_pointer_to_offset(preeditString[0], preeditString[0] + start[0]);
                    this.ranges[i * 2 + 1] = OS.g_utf16_pointer_to_offset(preeditString[0], preeditString[0] + end[0]) - 1;
                    this.styles[i] = new TextStyle(null, null, null);
                    int attr = OS.pango_attr_iterator_get(iterator, 9);
                    if (attr != 0) {
                        OS.memmove(attrColor, attr, PangoAttrColor.sizeof);
                        if (GTK.GTK3) {
                            rgba = new GdkRGBA();
                            rgba.alpha = 1.0;
                            rgba.red = (float)(attrColor.color_red & 0xFFFF) / 65535.0f;
                            rgba.green = (float)(attrColor.color_green & 0xFFFF) / 65535.0f;
                            rgba.blue = (float)(attrColor.color_blue & 0xFFFF) / 65535.0f;
                            this.styles[i].foreground = Color.gtk_new((Device)this.display, rgba);
                        } else {
                            color = new GdkColor();
                            color.red = attrColor.color_red;
                            color.green = attrColor.color_green;
                            color.blue = attrColor.color_blue;
                            this.styles[i].foreground = Color.gtk_new((Device)this.display, color);
                        }
                    }
                    if ((attr = OS.pango_attr_iterator_get(iterator, 10)) != 0) {
                        OS.memmove(attrColor, attr, PangoAttrColor.sizeof);
                        if (GTK.GTK3) {
                            rgba = new GdkRGBA();
                            rgba.alpha = 1.0;
                            rgba.red = (float)(attrColor.color_red & 0xFFFF) / 65535.0f;
                            rgba.green = (float)(attrColor.color_green & 0xFFFF) / 65535.0f;
                            rgba.blue = (float)(attrColor.color_blue & 0xFFFF) / 65535.0f;
                            this.styles[i].background = Color.gtk_new((Device)this.display, rgba);
                        } else {
                            color = new GdkColor();
                            color.red = attrColor.color_red;
                            color.green = attrColor.color_green;
                            color.blue = attrColor.color_blue;
                            this.styles[i].background = Color.gtk_new((Device)this.display, color);
                        }
                    }
                    if ((attr = OS.pango_attr_iterator_get(iterator, 11)) != 0) {
                        OS.memmove(attrInt, attr, PangoAttrInt.sizeof);
                        this.styles[i].underline = attrInt.value != 0;
                        this.styles[i].underlineStyle = 0;
                        switch (attrInt.value) {
                            case 2: {
                                this.styles[i].underlineStyle = 1;
                                break;
                            }
                            case 4: {
                                this.styles[i].underlineStyle = 2;
                            }
                        }
                        if (this.styles[i].underline && (attr = OS.pango_attr_iterator_get(iterator, 18)) != 0) {
                            OS.memmove(attrColor, attr, PangoAttrColor.sizeof);
                            color = new GdkColor();
                            color.red = attrColor.color_red;
                            color.green = attrColor.color_green;
                            color.blue = attrColor.color_blue;
                            this.styles[i].underlineColor = Color.gtk_new((Device)this.display, color);
                        }
                    }
                    OS.pango_attr_iterator_next(iterator);
                }
                OS.pango_attr_iterator_destroy(iterator);
                OS.pango_attr_list_unref(pangoAttrs[0]);
            }
            OS.g_free(preeditString[0]);
        }
        if (chars != null) {
            Event event;
            if (this.text.length() == 0) {
                if (chars.length == 0) {
                    return 0;
                }
                this.startOffset = -1;
            }
            int end = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                event = new Event();
                event.detail = 3;
                this.sendEvent(43, event);
                this.startOffset = event.start;
                end = event.end;
            }
            this.inComposition = true;
            event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = end;
            this.text = chars != null ? new String(chars) : "";
            event.text = this.text;
            this.sendEvent(43, event);
        }
        return 1;
    }

    int imHandle() {
        return this.parent.imHandle();
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int offset) {
        this.checkWidget();
        if (offset < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = offset;
        }
    }
}

