/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.Model;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.IOUtil;

public class CRFModel
extends Model {
    public static final String version = "ansj1";

    @Override
    public CRFModel loadModel(String modelPath) throws Exception {
        InputStream is = IOUtil.getInputStream((String)modelPath);
        Throwable throwable = null;
        try {
            this.loadModel(is);
            CRFModel cRFModel = this;
            return cRFModel;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    @Override
    public CRFModel loadModel(InputStream is) throws Exception {
        long start = System.currentTimeMillis();
        ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(is));
        Throwable throwable = null;
        try {
            ois.readUTF();
            this.status = (float[][])ois.readObject();
            int[][] template = (int[][])ois.readObject();
            this.config = new Config(template);
            int win = 0;
            int size = 0;
            String name = null;
            this.featureTree = new SmartForest();
            float[] value = null;
            do {
                win = ois.readInt();
                size = ois.readInt();
                for (int i = 0; i < size; ++i) {
                    name = ois.readUTF();
                    value = new float[win];
                    for (int j = 0; j < value.length; ++j) {
                        value[j] = ois.readFloat();
                    }
                    this.featureTree.add(name, (Object)value);
                }
            } while (win == 0 || size == 0);
            logger.info("load crf model ok ! use time :" + (System.currentTimeMillis() - start));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (ois != null) {
                if (throwable != null) {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    ois.close();
                }
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkModel(String modelPath) {
        try {
            FileInputStream fis = new FileInputStream(modelPath);
            Throwable throwable = null;
            try {
                ObjectInputStream inputStream = new ObjectInputStream(new GZIPInputStream(fis));
                String version = inputStream.readUTF();
                if (!version.equals(version)) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (ZipException ze) {
            logger.warn("\u89e3\u538b\u5f02\u5e38", (Throwable)ze);
            return false;
        }
        catch (FileNotFoundException e) {
            logger.warn("\u6587\u4ef6\u6ca1\u6709\u627e\u5230", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }
}

