/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultFileCollectionFactory
implements FileCollectionFactory {
    public static final String DEFAULT_DISPLAY_NAME = "file collection";
    private final PathToFileResolver fileResolver;
    @Nullable
    private final TaskResolver taskResolver;

    @Deprecated
    public DefaultFileCollectionFactory() {
        this((PathToFileResolver)new IdentityFileResolver(), null);
    }

    public DefaultFileCollectionFactory(PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver) {
        this.fileResolver = fileResolver;
        this.taskResolver = taskResolver;
    }

    public ConfigurableFileCollection configurableFiles() {
        return new DefaultConfigurableFileCollection(this.fileResolver, this.taskResolver);
    }

    public ConfigurableFileCollection configurableFiles(String displayName) {
        return new DefaultConfigurableFileCollection(displayName, this.fileResolver, this.taskResolver);
    }

    public FileCollectionInternal create(final TaskDependency builtBy, MinimalFileSet contents) {
        if (contents instanceof Buildable) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        return new FileCollectionAdapter(contents){

            public TaskDependency getBuildDependencies() {
                return builtBy;
            }
        };
    }

    public FileCollectionInternal create(MinimalFileSet contents) {
        return new FileCollectionAdapter(contents);
    }

    public FileCollectionInternal resolving(String displayName, List<?> files) {
        if (files.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new ResolvingFileCollection(displayName, this.fileResolver, (ImmutableList<Object>)ImmutableList.copyOf(files));
    }

    public FileCollectionInternal resolving(Object ... files) {
        return this.resolving(DEFAULT_DISPLAY_NAME, files);
    }

    public FileCollectionInternal resolving(String displayName, Object ... files) {
        return this.resolving(displayName, (List<?>)ImmutableList.copyOf((Object[])files));
    }

    public FileCollectionInternal empty(String displayName) {
        return new EmptyFileCollection(displayName);
    }

    public FileCollectionInternal empty() {
        return this.empty(DEFAULT_DISPLAY_NAME);
    }

    public FileCollectionInternal fixed(File ... files) {
        return this.fixed(DEFAULT_DISPLAY_NAME, files);
    }

    public FileCollectionInternal fixed(String displayName, File ... files) {
        if (files.length == 0) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, (ImmutableSet<File>)ImmutableSet.copyOf((Object[])files));
    }

    public FileCollectionInternal fixed(Collection<File> files) {
        return this.fixed(DEFAULT_DISPLAY_NAME, files);
    }

    public FileCollectionInternal fixed(String displayName, Collection<File> files) {
        if (files.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, (ImmutableSet<File>)ImmutableSet.copyOf(files));
    }

    private static final class ResolvingFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private final PathToFileResolver resolver;
        private final ImmutableList<Object> paths;

        public ResolvingFileCollection(String displayName, PathToFileResolver resolver, ImmutableList<Object> paths) {
            this.displayName = displayName;
            this.resolver = resolver;
            this.paths = paths;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void visitContents(FileCollectionResolveContext context) {
            FileCollectionResolveContext nested = context.push(this.resolver);
            nested.add(this.paths);
        }
    }

    private static final class FixedFileCollection
    extends AbstractFileCollection {
        private final String displayName;
        private final ImmutableSet<File> files;

        public FixedFileCollection(String displayName, ImmutableSet<File> files) {
            this.displayName = displayName;
            this.files = files;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<File> getFiles() {
            return this.files;
        }

        public TaskDependency getBuildDependencies() {
            return TaskDependencyInternal.EMPTY;
        }
    }

    private static final class EmptyFileCollection
    extends AbstractFileCollection {
        private final String displayName;

        public EmptyFileCollection(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TaskDependency getBuildDependencies() {
            return TaskDependencyInternal.EMPTY;
        }

        public Set<File> getFiles() {
            return ImmutableSet.of();
        }

        public void visitLeafCollections(FileCollectionLeafVisitor visitor) {
        }
    }
}

