/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.functors.AbstractReducingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0014J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/IsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/functors/AbstractReducingFunctor;", "constants", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isNegated", "", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;Lorg/jetbrains/kotlin/types/KotlinType;Z)V", "()Z", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "invokeWithArguments", "arg", "invokeWithValue", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "value", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "resolution"})
public final class IsFunctor
extends AbstractReducingFunctor {
    @NotNull
    private final KotlinType type;
    private final boolean isNegated;

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2) {
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        boolean bl = arguments2.size() == 1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Wrong size of arguments list for Unary operator: expected 1, got " + arguments2.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.invokeWithArguments(arguments2.get(0));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation arg) {
        Intrinsics.checkParameterIsNotNull((Object)arg, (String)"arg");
        return arg instanceof ESValue ? this.invokeWithValue((ESValue)arg) : CollectionsKt.emptyList();
    }

    private final List<ConditionalEffect> invokeWithValue(ESValue value) {
        ESIs trueIs = new ESIs(value, this);
        ESIs falseIs = new ESIs(value, new IsFunctor(this.getConstants$resolution(), this.type, !this.isNegated));
        ConditionalEffect trueResult = new ConditionalEffect(trueIs, new ESReturns(this.getConstants$resolution().getTrueValue()));
        ConditionalEffect falseResult = new ConditionalEffect(falseIs, new ESReturns(this.getConstants$resolution().getFalseValue()));
        return CollectionsKt.listOf((Object[])new ConditionalEffect[]{trueResult, falseResult});
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    public IsFunctor(@NotNull ESConstants constants, @NotNull KotlinType type2, boolean isNegated) {
        Intrinsics.checkParameterIsNotNull((Object)constants, (String)"constants");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super(constants);
        this.type = type2;
        this.isNegated = isNegated;
    }
}

