/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.action.AbstractTableListCommand;

class CheckTableCommand
extends AbstractTableListCommand {
    private int _checkType;

    public CheckTableCommand(ISession session, MysqlPlugin plugin, int checkType) {
        super(session, plugin);
        this._checkType = checkType;
    }

    @Override
    protected String getMySQLCommand() {
        return "check table";
    }

    @Override
    protected String checkSQL(String sql) {
        StringBuffer buf = new StringBuffer(sql);
        buf.append(' ').append(this.getResolvedCheckType());
        return buf.toString();
    }

    private String getResolvedCheckType() {
        switch (this._checkType) {
            case 0: {
                return "Quick";
            }
            case 1: {
                return "Fast";
            }
            case 2: {
                return "Medium";
            }
            case 3: {
                return "Extended";
            }
            case 4: {
                return "Changed";
            }
        }
        throw new IllegalStateException("Invalid check type of " + this._checkType);
    }
}

